/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.MeasurableForPreparedCache;
import org.apache.cassandra.cql3.MultiColumnRelation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.SingleColumnRelation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.MultiColumnRestriction;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.Restriction;
import org.apache.cassandra.cql3.statements.SingleColumnRestriction;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.composites.CompositesBuilder;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.Pageable;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.QueryPagers;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStatement
implements CQLStatement,
MeasurableForPreparedCache {
    private static final Logger logger = LoggerFactory.getLogger(SelectStatement.class);
    private static final int DEFAULT_COUNT_PAGE_SIZE = 10000;
    private final int boundTerms;
    public final CFMetaData cfm;
    public final Parameters parameters;
    private final Selection selection;
    private final Term limit;
    private final Restriction[] keyRestrictions;
    private final Restriction[] columnRestrictions;
    private final Map<ColumnIdentifier, Restriction> metadataRestrictions = new HashMap<ColumnIdentifier, Restriction>();
    private final Set<ColumnDefinition> restrictedColumns = new HashSet<ColumnDefinition>();
    private Restriction.Slice sliceRestriction;
    private boolean isReversed;
    private boolean onToken;
    private boolean isKeyRange;
    private boolean keyIsInRelation;
    private boolean usesSecondaryIndexing;
    private Map<ColumnIdentifier, Integer> orderingIndexes;
    private boolean selectsStaticColumns;
    private boolean selectsOnlyStaticColumns;
    private static final Parameters defaultParameters = new Parameters(Collections.emptyMap(), false, false);
    private static final Predicate<ColumnDefinition> isStaticFilter = new Predicate<ColumnDefinition>(){

        public boolean apply(ColumnDefinition def) {
            return def.isStatic();
        }
    };

    public SelectStatement(CFMetaData cfm, int boundTerms, Parameters parameters, Selection selection, Term limit) {
        this.cfm = cfm;
        this.boundTerms = boundTerms;
        this.selection = selection;
        this.keyRestrictions = new Restriction[cfm.partitionKeyColumns().size()];
        this.columnRestrictions = new Restriction[cfm.clusteringColumns().size()];
        this.parameters = parameters;
        this.limit = limit;
        this.initStaticColumnsInfo();
    }

    private void initStaticColumnsInfo() {
        if (!this.cfm.hasStaticColumns()) {
            return;
        }
        if (this.selection.isWildcard()) {
            this.selectsStaticColumns = true;
            return;
        }
        this.selectsStaticColumns = !Iterables.isEmpty((Iterable)Iterables.filter(this.selection.getColumns(), isStaticFilter));
        this.selectsOnlyStaticColumns = true;
        for (ColumnDefinition def : this.selection.getColumns()) {
            if (def.kind == ColumnDefinition.Kind.PARTITION_KEY || def.kind == ColumnDefinition.Kind.STATIC) continue;
            this.selectsOnlyStaticColumns = false;
            break;
        }
    }

    static SelectStatement forSelection(CFMetaData cfm, Selection selection) {
        return new SelectStatement(cfm, 0, defaultParameters, selection, null);
    }

    public ResultSet.Metadata getResultMetadata() {
        return this.selection.getResultMetadata();
    }

    @Override
    public long measureForPreparedCache(MemoryMeter meter) {
        return meter.measure((Object)this) + meter.measureDeep((Object)this.parameters) + meter.measureDeep((Object)this.selection) + (this.limit == null ? 0L : meter.measureDeep((Object)this.limit)) + meter.measureDeep((Object)this.keyRestrictions) + meter.measureDeep((Object)this.columnRestrictions) + meter.measureDeep(this.metadataRestrictions) + meter.measureDeep(this.restrictedColumns) + (this.sliceRestriction == null ? 0L : meter.measureDeep((Object)this.sliceRestriction)) + (this.orderingIndexes == null ? 0L : meter.measureDeep(this.orderingIndexes));
    }

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage.Rows execute(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        ConsistencyLevel cl = options.getConsistency();
        if (cl == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        cl.validateForRead(this.keyspace());
        int limit = this.getLimit(options);
        long now = System.currentTimeMillis();
        Pageable command = this.getPageableCommand(options, limit, now);
        int pageSize = options.getPageSize();
        if (this.selection.isAggregate() && pageSize <= 0) {
            pageSize = 10000;
        }
        if (pageSize <= 0 || command == null || !QueryPagers.mayNeedPaging(command, pageSize)) {
            return this.execute(command, options, limit, now);
        }
        QueryPager pager = QueryPagers.pager(command, cl, options.getPagingState());
        if (this.selection.isAggregate()) {
            return this.pageAggregateQuery(pager, options, pageSize, now);
        }
        if (this.needsPostQueryOrdering()) {
            throw new InvalidRequestException("Cannot page queries with both ORDER BY and a IN restriction on the partition key; you must either remove the ORDER BY or the IN and sort client side, or disable paging for this query");
        }
        List<Row> page = pager.fetchPage(pageSize);
        ResultMessage.Rows msg = this.processResults(page, options, limit, now);
        if (!pager.isExhausted()) {
            msg.result.metadata.setHasMorePages(pager.state());
        }
        return msg;
    }

    private Pageable getPageableCommand(QueryOptions options, int limit, long now) throws RequestValidationException {
        int limitForQuery = this.updateLimitForQuery(limit);
        if (this.isKeyRange || this.usesSecondaryIndexing) {
            return this.getRangeCommand(options, limitForQuery, now);
        }
        List<ReadCommand> commands = this.getSliceCommands(options, limitForQuery, now);
        return commands == null ? null : new Pageable.ReadCommands(commands);
    }

    public Pageable getPageableCommand(QueryOptions options) throws RequestValidationException {
        return this.getPageableCommand(options, this.getLimit(options), System.currentTimeMillis());
    }

    private ResultMessage.Rows execute(Pageable command, QueryOptions options, int limit, long now) throws RequestValidationException, RequestExecutionException {
        List<Row> rows = command == null ? Collections.emptyList() : (command instanceof Pageable.ReadCommands ? StorageProxy.read(((Pageable.ReadCommands)command).commands, options.getConsistency()) : StorageProxy.getRangeSlice((RangeSliceCommand)command, options.getConsistency()));
        return this.processResults(rows, options, limit, now);
    }

    private ResultMessage.Rows pageAggregateQuery(QueryPager pager, QueryOptions options, int pageSize, long now) throws RequestValidationException, RequestExecutionException {
        Selection.ResultSetBuilder result = this.selection.resultSetBuilder(now);
        while (!pager.isExhausted()) {
            for (Row row : pager.fetchPage(pageSize)) {
                if (row.cf == null) continue;
                this.processColumnFamily(row.key.getKey(), row.cf, options, now, result);
            }
        }
        return new ResultMessage.Rows(result.build());
    }

    public ResultMessage.Rows processResults(List<Row> rows, QueryOptions options, int limit, long now) throws RequestValidationException {
        ResultSet rset = this.process(rows, options, limit, now);
        return new ResultMessage.Rows(rset);
    }

    static List<Row> readLocally(String keyspaceName, List<ReadCommand> cmds) {
        Keyspace keyspace = Keyspace.open(keyspaceName);
        ArrayList<Row> rows = new ArrayList<Row>(cmds.size());
        for (ReadCommand cmd : cmds) {
            rows.add(cmd.getRow(keyspace));
        }
        return rows;
    }

    @Override
    public ResultMessage.Rows executeInternal(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        long now;
        int limit = this.getLimit(options);
        Pageable command = this.getPageableCommand(options, limit, now = System.currentTimeMillis());
        List<Row> rows = command == null ? Collections.emptyList() : (command instanceof Pageable.ReadCommands ? SelectStatement.readLocally(this.keyspace(), ((Pageable.ReadCommands)command).commands) : ((RangeSliceCommand)command).executeLocally());
        return this.processResults(rows, options, limit, now);
    }

    public ResultSet process(List<Row> rows) throws InvalidRequestException {
        QueryOptions options = QueryOptions.DEFAULT;
        return this.process(rows, options, this.getLimit(options), System.currentTimeMillis());
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    private List<ReadCommand> getSliceCommands(QueryOptions options, int limit, long now) throws RequestValidationException {
        Collection<ByteBuffer> keys = this.getKeys(options);
        if (keys.isEmpty()) {
            return null;
        }
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        IDiskAtomFilter filter = this.makeFilter(options, limit);
        if (filter == null) {
            return null;
        }
        for (ByteBuffer key : keys) {
            QueryProcessor.validateKey(key);
            commands.add(ReadCommand.create(this.keyspace(), ByteBufferUtil.clone(key), this.columnFamily(), now, filter.cloneShallow()));
        }
        return commands;
    }

    private RangeSliceCommand getRangeCommand(QueryOptions options, int limit, long now) throws RequestValidationException {
        IDiskAtomFilter filter = this.makeFilter(options, limit);
        if (filter == null) {
            return null;
        }
        List<IndexExpression> expressions = this.getValidatedIndexExpressions(options);
        AbstractBounds<RowPosition> keyBounds = this.getKeyBounds(options);
        return keyBounds == null ? null : new RangeSliceCommand(this.keyspace(), this.columnFamily(), now, filter, keyBounds, expressions, limit, !this.parameters.isDistinct, false);
    }

    private AbstractBounds<RowPosition> getKeyBounds(QueryOptions options) throws InvalidRequestException {
        RowPosition finishKey;
        IPartitioner p = StorageService.getPartitioner();
        if (this.onToken) {
            Token startToken = this.getTokenBound(Bound.START, options, p);
            Token endToken = this.getTokenBound(Bound.END, options, p);
            boolean includeStart = this.includeKeyBound(Bound.START);
            boolean includeEnd = this.includeKeyBound(Bound.END);
            int cmp = startToken.compareTo(endToken);
            if (!(startToken.isMinimum() || endToken.isMinimum() || cmp <= 0 && (cmp != 0 || includeStart && includeEnd))) {
                return null;
            }
            Token.KeyBound start = includeStart ? startToken.minKeyBound() : startToken.maxKeyBound();
            Token.KeyBound end = includeEnd ? endToken.maxKeyBound() : endToken.minKeyBound();
            return new Range<RowPosition>(start, end);
        }
        ByteBuffer startKeyBytes = this.getKeyBound(Bound.START, options);
        ByteBuffer finishKeyBytes = this.getKeyBound(Bound.END, options);
        RowPosition startKey = RowPosition.ForKey.get(startKeyBytes, p);
        if (startKey.compareTo(finishKey = RowPosition.ForKey.get(finishKeyBytes, p)) > 0 && !finishKey.isMinimum(p)) {
            return null;
        }
        if (this.includeKeyBound(Bound.START)) {
            return this.includeKeyBound(Bound.END) ? new Bounds<RowPosition>(startKey, finishKey) : new IncludingExcludingBounds<RowPosition>(startKey, finishKey);
        }
        return this.includeKeyBound(Bound.END) ? new Range<RowPosition>(startKey, finishKey) : new ExcludingBounds<RowPosition>(startKey, finishKey);
    }

    private ColumnSlice makeStaticSlice() {
        return this.isReversed ? new ColumnSlice(this.cfm.comparator.staticPrefix().end(), Composites.EMPTY) : new ColumnSlice(Composites.EMPTY, this.cfm.comparator.staticPrefix().end());
    }

    private IDiskAtomFilter makeFilter(QueryOptions options, int limit) throws InvalidRequestException {
        int toGroup;
        int n = toGroup = this.cfm.comparator.isDense() ? -1 : this.cfm.clusteringColumns().size();
        if (this.parameters.isDistinct) {
            return new SliceQueryFilter(ColumnSlice.ALL_COLUMNS_ARRAY, false, 1, this.selectsStaticColumns ? toGroup : -1);
        }
        if (this.isColumnRange()) {
            ColumnSlice[] slices;
            ColumnSlice staticSlice;
            List<Composite> startBounds = this.getRequestedBound(Bound.START, options);
            List<Composite> endBounds = this.getRequestedBound(Bound.END, options);
            assert (startBounds.size() == endBounds.size());
            ColumnSlice columnSlice = staticSlice = this.selectsStaticColumns && !this.usesSecondaryIndexing ? this.makeStaticSlice() : null;
            if (startBounds.size() == 1) {
                ColumnSlice slice = new ColumnSlice(startBounds.get(0), endBounds.get(0));
                if (slice.isAlwaysEmpty(this.cfm.comparator, this.isReversed)) {
                    return staticSlice == null ? null : this.sliceFilter(staticSlice, limit, toGroup);
                }
                if (staticSlice == null) {
                    return this.sliceFilter(slice, limit, toGroup);
                }
                if (this.isReversed) {
                    return slice.includes(this.cfm.comparator.reverseComparator(), staticSlice.start) ? this.sliceFilter(new ColumnSlice(slice.start, staticSlice.finish), limit, toGroup) : this.sliceFilter(new ColumnSlice[]{slice, staticSlice}, limit, toGroup);
                }
                return slice.includes(this.cfm.comparator, staticSlice.finish) ? this.sliceFilter(new ColumnSlice(staticSlice.start, slice.finish), limit, toGroup) : this.sliceFilter(new ColumnSlice[]{staticSlice, slice}, limit, toGroup);
            }
            ArrayList<ColumnSlice> l = new ArrayList<ColumnSlice>(startBounds.size());
            for (int i = 0; i < startBounds.size(); ++i) {
                ColumnSlice slice = new ColumnSlice(startBounds.get(i), endBounds.get(i));
                if (slice.isAlwaysEmpty(this.cfm.comparator, this.isReversed)) continue;
                l.add(slice);
            }
            if (l.isEmpty()) {
                return staticSlice == null ? null : this.sliceFilter(staticSlice, limit, toGroup);
            }
            if (staticSlice == null) {
                return this.sliceFilter(l.toArray(new ColumnSlice[l.size()]), limit, toGroup);
            }
            if (this.isReversed) {
                if (((ColumnSlice)l.get(l.size() - 1)).includes(this.cfm.comparator.reverseComparator(), staticSlice.start)) {
                    slices = l.toArray(new ColumnSlice[l.size()]);
                    slices[slices.length - 1] = new ColumnSlice(slices[slices.length - 1].start, Composites.EMPTY);
                } else {
                    slices = l.toArray(new ColumnSlice[l.size() + 1]);
                    slices[slices.length - 1] = staticSlice;
                }
            } else if (((ColumnSlice)l.get(0)).includes(this.cfm.comparator, staticSlice.finish)) {
                slices = new ColumnSlice[l.size()];
                slices[0] = new ColumnSlice(Composites.EMPTY, ((ColumnSlice)l.get((int)0)).finish);
                for (int i = 1; i < l.size(); ++i) {
                    slices[i] = (ColumnSlice)l.get(i);
                }
            } else {
                slices = new ColumnSlice[l.size() + 1];
                slices[0] = staticSlice;
                for (int i = 0; i < l.size(); ++i) {
                    slices[i + 1] = (ColumnSlice)l.get(i);
                }
            }
            return this.sliceFilter(slices, limit, toGroup);
        }
        SortedSet<CellName> cellNames = this.getRequestedColumns(options);
        if (cellNames == null) {
            return null;
        }
        QueryProcessor.validateCellNames(cellNames, this.cfm.comparator);
        return new NamesQueryFilter(cellNames, true);
    }

    private SliceQueryFilter sliceFilter(ColumnSlice slice, int limit, int toGroup) {
        return this.sliceFilter(new ColumnSlice[]{slice}, limit, toGroup);
    }

    private SliceQueryFilter sliceFilter(ColumnSlice[] slices, int limit, int toGroup) {
        assert (ColumnSlice.validateSlices(slices, this.cfm.comparator, this.isReversed)) : String.format("Invalid slices: " + Arrays.toString(slices) + (this.isReversed ? " (reversed)" : ""), new Object[0]);
        return new SliceQueryFilter(slices, this.isReversed, limit, toGroup);
    }

    private int getLimit(QueryOptions options) throws InvalidRequestException {
        int l = Integer.MAX_VALUE;
        if (this.limit != null) {
            ByteBuffer b = this.limit.bindAndGet(options);
            if (b == null) {
                throw new InvalidRequestException("Invalid null value of limit");
            }
            try {
                Int32Type.instance.validate(b);
                l = (Integer)Int32Type.instance.compose(b);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException("Invalid limit value");
            }
        }
        if (l <= 0) {
            throw new InvalidRequestException("LIMIT must be strictly positive");
        }
        return l;
    }

    private int updateLimitForQuery(int limit) {
        return this.sliceRestriction != null && (!this.sliceRestriction.isInclusive(Bound.START) || !this.sliceRestriction.isInclusive(Bound.END)) && limit != Integer.MAX_VALUE ? limit + 1 : limit;
    }

    private Collection<ByteBuffer> getKeys(QueryOptions options) throws InvalidRequestException {
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        CBuilder builder = this.cfm.getKeyValidatorAsCType().builder();
        for (ColumnDefinition def : this.cfm.partitionKeyColumns()) {
            Restriction r = this.keyRestrictions[def.position()];
            assert (r != null && !r.isSlice());
            List<ByteBuffer> values = r.values(options);
            if (builder.remainingCount() == 1) {
                for (ByteBuffer val : values) {
                    if (val == null) {
                        throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", def.name));
                    }
                    keys.add(builder.buildWith(val).toByteBuffer());
                }
                continue;
            }
            if (values.size() != 1) {
                throw new InvalidRequestException("IN is only supported on the last column of the partition key");
            }
            ByteBuffer val = values.get(0);
            if (val == null) {
                throw new InvalidRequestException(String.format("Invalid null value for partition key part %s", def.name));
            }
            builder.add(val);
        }
        return keys;
    }

    private ByteBuffer getKeyBound(Bound b, QueryOptions options) throws InvalidRequestException {
        for (int i = 0; i < this.keyRestrictions.length; ++i) {
            if (this.keyRestrictions[i] != null) continue;
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        return SelectStatement.buildBound(b, this.cfm.partitionKeyColumns(), this.keyRestrictions, false, this.cfm.getKeyValidatorAsCType(), options).get(0).toByteBuffer();
    }

    private Token getTokenBound(Bound b, QueryOptions options, IPartitioner<?> p) throws InvalidRequestException {
        ByteBuffer value;
        assert (this.onToken);
        Restriction restriction = this.keyRestrictions[0];
        assert (!restriction.isMultiColumn()) : "Unexpectedly got a multi-column restriction on a partition key for a range query";
        SingleColumnRestriction keyRestriction = (SingleColumnRestriction)restriction;
        if (keyRestriction.isEQ()) {
            value = keyRestriction.values(options).get(0);
        } else {
            SingleColumnRestriction.Slice slice = (SingleColumnRestriction.Slice)keyRestriction;
            if (!slice.hasBound(b)) {
                return p.getMinimumToken();
            }
            value = slice.bound(b, options);
        }
        if (value == null) {
            throw new InvalidRequestException("Invalid null token value");
        }
        return p.getTokenFactory().fromByteArray(value);
    }

    private boolean includeKeyBound(Bound b) {
        for (Restriction r : this.keyRestrictions) {
            if (r == null) {
                return true;
            }
            if (!r.isSlice()) continue;
            assert (!r.isMultiColumn()) : "Unexpectedly got multi-column restriction on partition key";
            return ((SingleColumnRestriction.Slice)r).isInclusive(b);
        }
        return true;
    }

    private boolean isColumnRange() {
        if (!this.cfm.comparator.isDense()) {
            return this.cfm.comparator.isCompound();
        }
        for (Restriction r : this.columnRestrictions) {
            if (r != null && !r.isSlice()) continue;
            return true;
        }
        return false;
    }

    private SortedSet<CellName> getRequestedColumns(QueryOptions options) throws InvalidRequestException {
        assert (!this.isColumnRange());
        CompositesBuilder builder = new CompositesBuilder(this.cfm.comparator.prefixBuilder(), this.cfm.comparator);
        Iterator<ColumnDefinition> idIter = this.cfm.clusteringColumns().iterator();
        for (Restriction r : this.columnRestrictions) {
            ColumnDefinition def = idIter.next();
            assert (r != null && !r.isSlice());
            List<ByteBuffer> values = r.values(options);
            if (values.isEmpty()) {
                return null;
            }
            builder.addEachElementToAll(values);
            if (!builder.containsNull()) continue;
            throw new InvalidRequestException(String.format("Invalid null value for clustering key part %s", def.name));
        }
        TreeSet<Composite> columns = new TreeSet<Composite>(this.cfm.comparator);
        for (Composite composite : builder.build()) {
            columns.addAll(this.addSelectedColumns(composite));
        }
        return columns;
    }

    private SortedSet<CellName> addSelectedColumns(Composite prefix) {
        if (this.cfm.comparator.isDense()) {
            return FBUtilities.singleton(this.cfm.comparator.create(prefix, null), this.cfm.comparator);
        }
        assert (!this.selectACollection());
        TreeSet<Composite> columns = new TreeSet<Composite>(this.cfm.comparator);
        if (this.cfm.comparator.isCompound() && !this.cfm.isSuper()) {
            columns.add(this.cfm.comparator.rowMarker(prefix));
            for (ColumnDefinition def : this.selection.getColumns()) {
                if (def.kind != ColumnDefinition.Kind.REGULAR && def.kind != ColumnDefinition.Kind.STATIC) continue;
                columns.add(this.cfm.comparator.create(prefix, def));
            }
        } else {
            for (ColumnDefinition def : this.cfm.regularColumns()) {
                columns.add(this.cfm.comparator.create(prefix, def));
            }
        }
        return columns;
    }

    private boolean selectACollection() {
        if (!this.cfm.comparator.hasCollections()) {
            return false;
        }
        for (ColumnDefinition def : this.selection.getColumns()) {
            if (!(def.type instanceof CollectionType)) continue;
            return true;
        }
        return false;
    }

    private static List<Composite> buildBound(Bound bound, List<ColumnDefinition> defs, Restriction[] restrictions, boolean isReversed, CType type, QueryOptions options) throws InvalidRequestException {
        Restriction firstRestriction;
        CBuilder builder = type.builder();
        if (!defs.isEmpty() && (firstRestriction = restrictions[0]) != null && firstRestriction.isMultiColumn()) {
            if (firstRestriction.isSlice()) {
                return SelectStatement.buildMultiColumnSliceBound(bound, defs, (MultiColumnRestriction.Slice)firstRestriction, isReversed, builder, options);
            }
            if (firstRestriction.isIN()) {
                return SelectStatement.buildMultiColumnInBound(bound, defs, (MultiColumnRestriction.IN)firstRestriction, isReversed, builder, type, options);
            }
            return SelectStatement.buildMultiColumnEQBound(bound, defs, (MultiColumnRestriction.EQ)firstRestriction, isReversed, builder, options);
        }
        CompositesBuilder compositeBuilder = new CompositesBuilder(builder, isReversed ? type.reverseComparator() : type);
        Bound eocBound = isReversed ? Bound.reverse(bound) : bound;
        for (ColumnDefinition def : defs) {
            Bound b = isReversed == SelectStatement.isReversedType(def) ? bound : Bound.reverse(bound);
            Restriction r = restrictions[def.position()];
            if (SelectStatement.isNullRestriction(r, b)) {
                Composite.EOC eoc = !compositeBuilder.isEmpty() && eocBound == Bound.END ? Composite.EOC.END : Composite.EOC.NONE;
                return compositeBuilder.buildWithEOC(eoc);
            }
            if (r.isSlice()) {
                compositeBuilder.addElementToAll(SelectStatement.getSliceValue(r, b, options));
                Relation.Type relType = ((Restriction.Slice)r).getRelation(eocBound, b);
                return compositeBuilder.buildWithEOC(SelectStatement.eocForRelation(relType));
            }
            compositeBuilder.addEachElementToAll(r.values(options));
            if (!compositeBuilder.containsNull()) continue;
            throw new InvalidRequestException(String.format("Invalid null clustering key part %s", def.name));
        }
        Composite.EOC eoc = eocBound == Bound.END && compositeBuilder.hasRemaining() ? Composite.EOC.END : Composite.EOC.NONE;
        return compositeBuilder.buildWithEOC(eoc);
    }

    private static Composite.EOC eocForRelation(Relation.Type op) {
        switch (op) {
            case LT: {
                return Composite.EOC.START;
            }
            case GT: 
            case LTE: {
                return Composite.EOC.END;
            }
        }
        return Composite.EOC.NONE;
    }

    private static List<Composite> buildMultiColumnSliceBound(Bound bound, List<ColumnDefinition> defs, MultiColumnRestriction.Slice slice, boolean isReversed, CBuilder builder, QueryOptions options) throws InvalidRequestException {
        ColumnDefinition def;
        Bound firstComponentBound;
        Bound eocBound = isReversed ? Bound.reverse(bound) : bound;
        Iterator<ColumnDefinition> iter = defs.iterator();
        ColumnDefinition firstName = iter.next();
        Bound bound2 = firstComponentBound = isReversed == SelectStatement.isReversedType(firstName) ? bound : Bound.reverse(bound);
        if (!slice.hasBound(firstComponentBound)) {
            Composite prefix = builder.build();
            return Collections.singletonList(builder.remainingCount() > 0 && eocBound == Bound.END ? prefix.end() : prefix);
        }
        List<ByteBuffer> vals = slice.componentBounds(firstComponentBound, options);
        ByteBuffer v = vals.get(firstName.position());
        if (v == null) {
            throw new InvalidRequestException("Invalid null value in condition for column " + firstName.name);
        }
        builder.add(v);
        while (iter.hasNext() && (def = iter.next()).position() < vals.size()) {
            v = vals.get(def.position());
            if (v == null) {
                throw new InvalidRequestException("Invalid null value in condition for column " + def.name);
            }
            builder.add(v);
        }
        Relation.Type relType = slice.getRelation(eocBound, firstComponentBound);
        return Collections.singletonList(builder.build().withEOC(SelectStatement.eocForRelation(relType)));
    }

    private static List<Composite> buildMultiColumnInBound(Bound bound, List<ColumnDefinition> defs, MultiColumnRestriction.IN restriction, boolean isReversed, CBuilder builder, CType type, QueryOptions options) throws InvalidRequestException {
        List<List<ByteBuffer>> splitInValues = restriction.splitValues(options);
        Bound eocBound = isReversed ? Bound.reverse(bound) : bound;
        TreeSet<Composite> inValues = new TreeSet<Composite>(isReversed ? type.reverseComparator() : type);
        for (List<ByteBuffer> components : splitInValues) {
            for (int i = 0; i < components.size(); ++i) {
                if (components.get(i) != null) continue;
                throw new InvalidRequestException("Invalid null value in condition for column " + defs.get(i));
            }
            Composite prefix = builder.buildWith(components);
            inValues.add(eocBound == Bound.END && builder.remainingCount() - components.size() > 0 ? prefix.end() : prefix);
        }
        return new ArrayList<Composite>(inValues);
    }

    private static List<Composite> buildMultiColumnEQBound(Bound bound, List<ColumnDefinition> defs, MultiColumnRestriction.EQ restriction, boolean isReversed, CBuilder builder, QueryOptions options) throws InvalidRequestException {
        Bound eocBound = isReversed ? Bound.reverse(bound) : bound;
        List<ByteBuffer> values = restriction.values(options);
        for (int i = 0; i < values.size(); ++i) {
            ByteBuffer component = values.get(i);
            if (component == null) {
                throw new InvalidRequestException("Invalid null value in condition for column " + defs.get(i));
            }
            builder.add(component);
        }
        Composite prefix = builder.build();
        return Collections.singletonList(builder.remainingCount() > 0 && eocBound == Bound.END ? prefix.end() : prefix);
    }

    private static boolean isNullRestriction(Restriction r, Bound b) {
        return r == null || r.isSlice() && !((Restriction.Slice)r).hasBound(b);
    }

    private static ByteBuffer getSliceValue(Restriction r, Bound b, QueryOptions options) throws InvalidRequestException {
        Restriction.Slice slice = (Restriction.Slice)r;
        assert (slice.hasBound(b));
        ByteBuffer val = slice.bound(b, options);
        if (val == null) {
            throw new InvalidRequestException(String.format("Invalid null clustering key part %s", r));
        }
        return val;
    }

    private List<Composite> getRequestedBound(Bound b, QueryOptions options) throws InvalidRequestException {
        assert (this.isColumnRange());
        return SelectStatement.buildBound(b, this.cfm.clusteringColumns(), this.columnRestrictions, this.isReversed, this.cfm.comparator, options);
    }

    public List<IndexExpression> getValidatedIndexExpressions(QueryOptions options) throws InvalidRequestException {
        if (!this.usesSecondaryIndexing || this.restrictedColumns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexExpression> expressions = new ArrayList<IndexExpression>();
        for (ColumnDefinition def : this.restrictedColumns) {
            Restriction restriction;
            switch (def.kind) {
                case PARTITION_KEY: {
                    restriction = this.keyRestrictions[def.position()];
                    break;
                }
                case CLUSTERING_COLUMN: {
                    restriction = this.columnRestrictions[def.position()];
                    break;
                }
                case REGULAR: 
                case STATIC: {
                    restriction = this.metadataRestrictions.get(def.name);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (restriction.isSlice()) {
                Restriction.Slice slice = (Restriction.Slice)restriction;
                for (Bound b : Bound.values()) {
                    if (!slice.hasBound(b)) continue;
                    ByteBuffer value = SelectStatement.validateIndexedValue(def, slice.bound(b, options));
                    IndexExpression.Operator op = slice.getIndexOperator(b);
                    if (def.type instanceof ReversedType) {
                        op = SelectStatement.reverse(op);
                    }
                    expressions.add(new IndexExpression(def.name.bytes, op, value));
                }
                continue;
            }
            if (restriction.isContains()) {
                SingleColumnRestriction.Contains contains = (SingleColumnRestriction.Contains)restriction;
                for (ByteBuffer value : contains.values(options)) {
                    SelectStatement.validateIndexedValue(def, value);
                    expressions.add(new IndexExpression(def.name.bytes, IndexExpression.Operator.CONTAINS, value));
                }
                for (ByteBuffer key : contains.keys(options)) {
                    SelectStatement.validateIndexedValue(def, key);
                    expressions.add(new IndexExpression(def.name.bytes, IndexExpression.Operator.CONTAINS_KEY, key));
                }
                continue;
            }
            List<ByteBuffer> values = restriction.values(options);
            if (values.size() != 1) {
                throw new InvalidRequestException("IN restrictions are not supported on indexed columns");
            }
            ByteBuffer value = SelectStatement.validateIndexedValue(def, values.get(0));
            expressions.add(new IndexExpression(def.name.bytes, IndexExpression.Operator.EQ, value));
        }
        if (this.usesSecondaryIndexing) {
            ColumnFamilyStore cfs = Keyspace.open(this.keyspace()).getColumnFamilyStore(this.columnFamily());
            SecondaryIndexManager secondaryIndexManager = cfs.indexManager;
            secondaryIndexManager.validateIndexSearchersForQuery(expressions);
        }
        return expressions;
    }

    private static ByteBuffer validateIndexedValue(ColumnDefinition def, ByteBuffer value) throws InvalidRequestException {
        if (value == null) {
            throw new InvalidRequestException(String.format("Unsupported null value for indexed column %s", def.name));
        }
        if (value.remaining() > 65535) {
            throw new InvalidRequestException("Index expression values may not be larger than 64K");
        }
        return value;
    }

    private Iterator<Cell> applySliceRestriction(final Iterator<Cell> cells, QueryOptions options) throws InvalidRequestException {
        assert (this.sliceRestriction != null);
        final CellNameType type = this.cfm.comparator;
        final CellName excludedStart = this.sliceRestriction.isInclusive(Bound.START) ? null : type.makeCellName(this.sliceRestriction.bound(Bound.START, options));
        final CellName excludedEnd = this.sliceRestriction.isInclusive(Bound.END) ? null : type.makeCellName(this.sliceRestriction.bound(Bound.END, options));
        return new AbstractIterator<Cell>(){

            protected Cell computeNext() {
                while (cells.hasNext()) {
                    Cell c = (Cell)cells.next();
                    if (excludedStart != null && type.compare(c.name(), excludedStart) == 0 || excludedEnd != null && type.compare(c.name(), excludedEnd) == 0) continue;
                    return c;
                }
                return (Cell)this.endOfData();
            }
        };
    }

    private static IndexExpression.Operator reverse(IndexExpression.Operator op) {
        switch (op) {
            case LT: {
                return IndexExpression.Operator.GT;
            }
            case LTE: {
                return IndexExpression.Operator.GTE;
            }
            case GT: {
                return IndexExpression.Operator.LT;
            }
            case GTE: {
                return IndexExpression.Operator.LTE;
            }
        }
        return op;
    }

    private ResultSet process(List<Row> rows, QueryOptions options, int limit, long now) throws InvalidRequestException {
        Selection.ResultSetBuilder result = this.selection.resultSetBuilder(now);
        for (Row row : rows) {
            if (row.cf == null) continue;
            this.processColumnFamily(row.key.getKey(), row.cf, options, now, result);
        }
        ResultSet cqlRows = result.build();
        this.orderResults(cqlRows);
        if (this.isReversed) {
            cqlRows.reverse();
        }
        cqlRows.trim(limit);
        return cqlRows;
    }

    void processColumnFamily(ByteBuffer key, ColumnFamily cf, QueryOptions options, long now, Selection.ResultSetBuilder result) throws InvalidRequestException {
        CQL3Row.RowIterator iter;
        CQL3Row staticRow;
        CFMetaData cfm = cf.metadata();
        ByteBuffer[] keyComponents = null;
        keyComponents = cfm.getKeyValidator() instanceof CompositeType ? ((CompositeType)cfm.getKeyValidator()).split(key) : new ByteBuffer[]{key};
        Iterator<Cell> cells = cf.getSortedColumns().iterator();
        if (this.sliceRestriction != null) {
            cells = this.applySliceRestriction(cells, options);
        }
        if ((staticRow = (iter = cfm.comparator.CQL3RowBuilder(cfm, now).group(cells)).getStaticRow()) != null && !iter.hasNext() && !this.usesSecondaryIndexing && this.hasNoClusteringColumnsRestriction()) {
            result.newRow();
            block11: for (ColumnDefinition def : this.selection.getColumns()) {
                switch (def.kind) {
                    case PARTITION_KEY: {
                        result.add(keyComponents[def.position()]);
                        continue block11;
                    }
                    case STATIC: {
                        SelectStatement.addValue(result, def, staticRow, options);
                        continue block11;
                    }
                }
                result.add((ByteBuffer)null);
            }
            return;
        }
        while (iter.hasNext()) {
            CQL3Row cql3Row = (CQL3Row)iter.next();
            result.newRow();
            for (ColumnDefinition def : this.selection.getColumns()) {
                switch (def.kind) {
                    case PARTITION_KEY: {
                        result.add(keyComponents[def.position()]);
                        break;
                    }
                    case CLUSTERING_COLUMN: {
                        result.add(cql3Row.getClusteringColumn(def.position()));
                        break;
                    }
                    case COMPACT_VALUE: {
                        result.add(cql3Row.getColumn(null));
                        break;
                    }
                    case REGULAR: {
                        SelectStatement.addValue(result, def, cql3Row, options);
                        break;
                    }
                    case STATIC: {
                        SelectStatement.addValue(result, def, staticRow, options);
                    }
                }
            }
        }
    }

    private static void addValue(Selection.ResultSetBuilder result, ColumnDefinition def, CQL3Row row, QueryOptions options) {
        if (row == null) {
            result.add((ByteBuffer)null);
            return;
        }
        if (def.type.isCollection()) {
            List<Cell> collection = row.getCollection(def.name);
            ByteBuffer value = collection == null ? null : ((CollectionType)def.type).serializeForNativeProtocol(collection, options.getProtocolVersion());
            result.add(value);
            return;
        }
        result.add(row.getColumn(def.name));
    }

    private boolean hasNoClusteringColumnsRestriction() {
        for (int i = 0; i < this.columnRestrictions.length; ++i) {
            if (this.columnRestrictions[i] == null) continue;
            return false;
        }
        return true;
    }

    private boolean needsPostQueryOrdering() {
        return this.keyIsInRelation && !this.parameters.orderings.isEmpty();
    }

    private void orderResults(ResultSet cqlRows) {
        if (cqlRows.size() == 0 || !this.needsPostQueryOrdering()) {
            return;
        }
        assert (this.orderingIndexes != null);
        ArrayList<Integer> idToSort = new ArrayList<Integer>();
        ArrayList<AbstractType> sorters = new ArrayList<AbstractType>();
        for (ColumnIdentifier identifier : this.parameters.orderings.keySet()) {
            ColumnDefinition orderingColumn = this.cfm.getColumnDefinition(identifier);
            idToSort.add(this.orderingIndexes.get(orderingColumn.name));
            sorters.add(orderingColumn.type);
        }
        Comparator<List<ByteBuffer>> comparator = idToSort.size() == 1 ? new SingleColumnComparator((Integer)idToSort.get(0), (Comparator)sorters.get(0)) : new CompositeComparator(sorters, idToSort);
        Collections.sort(cqlRows.rows, comparator);
    }

    private static boolean isReversedType(ColumnDefinition def) {
        return def.type instanceof ReversedType;
    }

    private boolean columnFilterIsIdentity() {
        for (Restriction r : this.columnRestrictions) {
            if (r == null) continue;
            return false;
        }
        return true;
    }

    private boolean hasClusteringColumnsRestriction() {
        for (int i = 0; i < this.columnRestrictions.length; ++i) {
            if (this.columnRestrictions[i] == null) continue;
            return true;
        }
        return false;
    }

    private void validateDistinctSelection() throws InvalidRequestException {
        Collection<ColumnDefinition> requestedColumns = this.selection.getColumns();
        for (ColumnDefinition def : requestedColumns) {
            if (def.kind == ColumnDefinition.Kind.PARTITION_KEY || def.kind == ColumnDefinition.Kind.STATIC) continue;
            throw new InvalidRequestException(String.format("SELECT DISTINCT queries must only request partition key columns and/or static columns (not %s)", def.name));
        }
        if (!this.isKeyRange) {
            return;
        }
        for (ColumnDefinition def : this.cfm.partitionKeyColumns()) {
            if (requestedColumns.contains(def)) continue;
            throw new InvalidRequestException(String.format("SELECT DISTINCT queries must request all the partition key columns (missing %s)", def.name));
        }
    }

    private boolean isRestrictedByMultipleContains(ColumnDefinition columnDef) {
        if (!columnDef.type.isCollection()) {
            return false;
        }
        Restriction restriction = this.metadataRestrictions.get(columnDef.name);
        if (!(restriction instanceof SingleColumnRestriction.Contains)) {
            return false;
        }
        SingleColumnRestriction.Contains contains = (SingleColumnRestriction.Contains)restriction;
        return contains.numberOfValues() + contains.numberOfKeys() > 1;
    }

    private static class CompositeComparator
    implements Comparator<List<ByteBuffer>> {
        private final List<Comparator<ByteBuffer>> orderTypes;
        private final List<Integer> positions;

        private CompositeComparator(List<Comparator<ByteBuffer>> orderTypes, List<Integer> positions) {
            this.orderTypes = orderTypes;
            this.positions = positions;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            for (int i = 0; i < this.positions.size(); ++i) {
                ByteBuffer bValue;
                int columnPos;
                ByteBuffer aValue;
                Comparator<ByteBuffer> type = this.orderTypes.get(i);
                int comparison = type.compare(aValue = a.get(columnPos = this.positions.get(i).intValue()), bValue = b.get(columnPos));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    private static class SingleColumnComparator
    implements Comparator<List<ByteBuffer>> {
        private final int index;
        private final Comparator<ByteBuffer> comparator;

        public SingleColumnComparator(int columnIndex, Comparator<ByteBuffer> orderer) {
            this.index = columnIndex;
            this.comparator = orderer;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            return this.comparator.compare(a.get(this.index), b.get(this.index));
        }
    }

    public static class Parameters {
        private final Map<ColumnIdentifier, Boolean> orderings;
        private final boolean isDistinct;
        private final boolean allowFiltering;

        public Parameters(Map<ColumnIdentifier, Boolean> orderings, boolean isDistinct, boolean allowFiltering) {
            this.orderings = orderings;
            this.isDistinct = isDistinct;
            this.allowFiltering = allowFiltering;
        }
    }

    public static class RawStatement
    extends CFStatement {
        private final Parameters parameters;
        private final List<RawSelector> selectClause;
        private final List<Relation> whereClause;
        private final Term.Raw limit;

        public RawStatement(CFName cfName, Parameters parameters, List<RawSelector> selectClause, List<Relation> whereClause, Term.Raw limit) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause == null ? Collections.emptyList() : whereClause;
            this.limit = limit;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            VariableSpecifications boundNames = this.getBoundVariables();
            Selection selection = this.selectClause.isEmpty() ? Selection.wildcard(cfm) : Selection.fromSelectors(cfm, this.selectClause);
            SelectStatement stmt = new SelectStatement(cfm, boundNames.size(), this.parameters, selection, this.prepareLimit(boundNames));
            boolean hasQueriableIndex = false;
            boolean hasQueriableClusteringColumnIndex = false;
            boolean hasSingleColumnRelations = false;
            boolean hasMultiColumnRelations = false;
            for (Relation relation : this.whereClause) {
                Relation rel;
                if (relation.isMultiColumn()) {
                    rel = (MultiColumnRelation)relation;
                    ArrayList<ColumnDefinition> names = new ArrayList<ColumnDefinition>(((MultiColumnRelation)rel).getEntities().size());
                    for (ColumnIdentifier entity : ((MultiColumnRelation)rel).getEntities()) {
                        ColumnDefinition def = cfm.getColumnDefinition(entity);
                        boolean[] queriable = this.processRelationEntity(stmt, relation, entity, def);
                        hasQueriableIndex |= queriable[0];
                        hasQueriableClusteringColumnIndex |= queriable[1];
                        names.add(def);
                        hasMultiColumnRelations |= ColumnDefinition.Kind.CLUSTERING_COLUMN.equals((Object)def.kind);
                    }
                    this.updateRestrictionsForRelation(stmt, names, (MultiColumnRelation)rel, boundNames);
                    continue;
                }
                rel = (SingleColumnRelation)relation;
                ColumnIdentifier entity = ((SingleColumnRelation)rel).getEntity();
                ColumnDefinition def = cfm.getColumnDefinition(entity);
                boolean[] queriable = this.processRelationEntity(stmt, relation, entity, def);
                hasQueriableIndex |= queriable[0];
                hasQueriableClusteringColumnIndex |= queriable[1];
                hasSingleColumnRelations |= ColumnDefinition.Kind.CLUSTERING_COLUMN.equals((Object)def.kind);
                this.updateRestrictionsForRelation(stmt, def, (SingleColumnRelation)rel, boundNames);
            }
            if (hasSingleColumnRelations && hasMultiColumnRelations) {
                throw new InvalidRequestException("Mixing single column relations and multi column relations on clustering columns is not allowed");
            }
            this.processPartitionKeyRestrictions(stmt, hasQueriableIndex, cfm);
            if (!stmt.usesSecondaryIndexing) {
                stmt.restrictedColumns.removeAll(cfm.partitionKeyColumns());
            }
            if (stmt.selectsOnlyStaticColumns && stmt.hasClusteringColumnsRestriction()) {
                throw new InvalidRequestException("Cannot restrict clustering columns when selecting only static columns");
            }
            this.processColumnRestrictions(stmt, hasQueriableIndex, cfm);
            if (stmt.isKeyRange && hasQueriableClusteringColumnIndex) {
                stmt.usesSecondaryIndexing = true;
            }
            if (!stmt.usesSecondaryIndexing) {
                stmt.restrictedColumns.removeAll(cfm.clusteringColumns());
            }
            if (!stmt.metadataRestrictions.isEmpty()) {
                if (!hasQueriableIndex) {
                    throw new InvalidRequestException("No indexed columns present in by-columns clause with Equal operator");
                }
                stmt.usesSecondaryIndexing = true;
            }
            if (stmt.usesSecondaryIndexing) {
                this.validateSecondaryIndexSelections(stmt);
            }
            if (!stmt.parameters.orderings.isEmpty()) {
                this.processOrderingClause(stmt, cfm);
            }
            this.checkNeedsFiltering(stmt);
            if (this.parameters.isDistinct) {
                stmt.validateDistinctSelection();
            }
            return new ParsedStatement.Prepared((CQLStatement)stmt, boundNames);
        }

        private boolean[] processRelationEntity(SelectStatement stmt, Relation relation, ColumnIdentifier entity, ColumnDefinition def) throws InvalidRequestException {
            if (def == null) {
                this.handleUnrecognizedEntity(entity, relation);
            }
            stmt.restrictedColumns.add(def);
            if (def.isIndexed() && relation.operator().allowsIndexQuery()) {
                return new boolean[]{true, def.kind == ColumnDefinition.Kind.CLUSTERING_COLUMN};
            }
            return new boolean[]{false, false};
        }

        private void handleUnrecognizedEntity(ColumnIdentifier entity, Relation relation) throws InvalidRequestException {
            if (this.containsAlias(entity)) {
                throw new InvalidRequestException(String.format("Aliases aren't allowed in the where clause ('%s')", relation));
            }
            throw new InvalidRequestException(String.format("Undefined name %s in where clause ('%s')", entity, relation));
        }

        private Term prepareLimit(VariableSpecifications boundNames) throws InvalidRequestException {
            if (this.limit == null) {
                return null;
            }
            Term prepLimit = this.limit.prepare(this.keyspace(), this.limitReceiver());
            prepLimit.collectMarkerSpecification(boundNames);
            return prepLimit;
        }

        private void updateRestrictionsForRelation(SelectStatement stmt, List<ColumnDefinition> defs, MultiColumnRelation relation, VariableSpecifications boundNames) throws InvalidRequestException {
            ArrayList<ColumnDefinition> restrictedColumns = new ArrayList<ColumnDefinition>();
            HashSet<ColumnDefinition> seen = new HashSet<ColumnDefinition>();
            int previousPosition = -1;
            for (ColumnDefinition def : defs) {
                if (def.kind != ColumnDefinition.Kind.CLUSTERING_COLUMN) {
                    throw new InvalidRequestException(String.format("Multi-column relations can only be applied to clustering columns: %s", def));
                }
                if (seen.contains(def)) {
                    throw new InvalidRequestException(String.format("Column \"%s\" appeared twice in a relation: %s", def, relation));
                }
                seen.add(def);
                if (def.position() != previousPosition + 1) {
                    if (previousPosition == -1) {
                        throw new InvalidRequestException(String.format("Clustering columns may not be skipped in multi-column relations. They should appear in the PRIMARY KEY order. Got %s", relation));
                    }
                    throw new InvalidRequestException(String.format("Clustering columns must appear in the PRIMARY KEY order in multi-column relations: %s", relation));
                }
                ++previousPosition;
                Restriction existing = this.getExistingRestriction(stmt, def);
                Relation.Type operator = relation.operator();
                if (existing != null) {
                    if (operator == Relation.Type.EQ || operator == Relation.Type.IN) {
                        throw new InvalidRequestException(String.format("Column \"%s\" cannot be restricted by more than one relation if it is in an %s relation", new Object[]{def, relation.operator()}));
                    }
                    if (!existing.isSlice()) {
                        throw new InvalidRequestException(String.format("Column \"%s\" cannot be restricted by an equality relation and an inequality relation", def));
                    }
                }
                restrictedColumns.add(def);
            }
            switch (relation.operator()) {
                case EQ: {
                    Term t = relation.getValue().prepare(this.keyspace(), defs);
                    t.collectMarkerSpecification(boundNames);
                    MultiColumnRestriction.EQ restriction = new MultiColumnRestriction.EQ(t, false);
                    for (ColumnDefinition def : restrictedColumns) {
                        ((SelectStatement)stmt).columnRestrictions[def.position()] = restriction;
                    }
                    break;
                }
                case IN: {
                    SingleColumnRestriction restriction;
                    List<? extends Term.MultiColumnRaw> inValues = relation.getInValues();
                    if (inValues != null) {
                        ArrayList<Term> terms = new ArrayList<Term>(inValues.size());
                        for (Term.MultiColumnRaw multiColumnRaw : inValues) {
                            Term t = multiColumnRaw.prepare(this.keyspace(), defs);
                            t.collectMarkerSpecification(boundNames);
                            terms.add(t);
                        }
                        restriction = new MultiColumnRestriction.InWithValues(terms);
                    } else {
                        Tuples.INRaw rawMarker = relation.getInMarker();
                        AbstractMarker t = rawMarker.prepare(this.keyspace(), defs);
                        t.collectMarkerSpecification(boundNames);
                        restriction = new MultiColumnRestriction.InWithMarker(t);
                    }
                    for (ColumnDefinition def : restrictedColumns) {
                        ((SelectStatement)stmt).columnRestrictions[def.position()] = restriction;
                    }
                    break;
                }
                case LT: 
                case GT: 
                case LTE: 
                case GTE: {
                    Term t = relation.getValue().prepare(this.keyspace(), defs);
                    t.collectMarkerSpecification(boundNames);
                    for (ColumnDefinition def : defs) {
                        Restriction.Slice restriction = (Restriction.Slice)this.getExistingRestriction(stmt, def);
                        if (restriction == null) {
                            restriction = new MultiColumnRestriction.Slice(false);
                        } else if (!restriction.isMultiColumn()) {
                            throw new InvalidRequestException(String.format("Column \"%s\" cannot have both tuple-notation inequalities and single-column inequalities: %s", def.name, relation));
                        }
                        restriction.setBound(def.name, relation.operator(), t);
                        ((SelectStatement)stmt).columnRestrictions[def.position()] = restriction;
                    }
                    break;
                }
                case NEQ: {
                    throw new InvalidRequestException(String.format("Unsupported \"!=\" relation: %s", relation));
                }
            }
        }

        private Restriction getExistingRestriction(SelectStatement stmt, ColumnDefinition def) {
            switch (def.kind) {
                case PARTITION_KEY: {
                    return stmt.keyRestrictions[def.position()];
                }
                case CLUSTERING_COLUMN: {
                    return stmt.columnRestrictions[def.position()];
                }
                case REGULAR: 
                case STATIC: {
                    return (Restriction)stmt.metadataRestrictions.get(def.name);
                }
            }
            throw new AssertionError();
        }

        private void updateRestrictionsForRelation(SelectStatement stmt, ColumnDefinition def, SingleColumnRelation relation, VariableSpecifications names) throws InvalidRequestException {
            switch (def.kind) {
                case PARTITION_KEY: {
                    ((SelectStatement)stmt).keyRestrictions[def.position()] = this.updateSingleColumnRestriction(def, stmt.keyRestrictions[def.position()], relation, names);
                    break;
                }
                case CLUSTERING_COLUMN: {
                    ((SelectStatement)stmt).columnRestrictions[def.position()] = this.updateSingleColumnRestriction(def, stmt.columnRestrictions[def.position()], relation, names);
                    break;
                }
                case COMPACT_VALUE: {
                    throw new InvalidRequestException(String.format("Predicates on the non-primary-key column (%s) of a COMPACT table are not yet supported", def.name));
                }
                case REGULAR: 
                case STATIC: {
                    Restriction r = this.updateSingleColumnRestriction(def, (Restriction)stmt.metadataRestrictions.get(def.name), relation, names);
                    if (r.isIN() && !((Restriction.IN)r).canHaveOnlyOneValue()) {
                        throw new InvalidRequestException(String.format("IN predicates on non-primary-key columns (%s) is not yet supported", def.name));
                    }
                    stmt.metadataRestrictions.put(def.name, r);
                }
            }
        }

        Restriction updateSingleColumnRestriction(ColumnDefinition def, Restriction existingRestriction, SingleColumnRelation newRel, VariableSpecifications boundNames) throws InvalidRequestException {
            ColumnSpecification receiver = def;
            if (newRel.onToken) {
                if (def.kind != ColumnDefinition.Kind.PARTITION_KEY) {
                    throw new InvalidRequestException(String.format("The token() function is only supported on the partition key, found on %s", def.name));
                }
                receiver = new ColumnSpecification(def.ksName, def.cfName, new ColumnIdentifier("partition key token", true), StorageService.getPartitioner().getTokenValidator());
            }
            if (receiver.type.isCollection() && !newRel.operator().equals((Object)Relation.Type.CONTAINS_KEY) && newRel.operator() != Relation.Type.CONTAINS) {
                throw new InvalidRequestException(String.format("Collection column '%s' (%s) cannot be restricted by a '%s' relation", new Object[]{def.name, receiver.type.asCQL3Type(), newRel.operator()}));
            }
            switch (newRel.operator()) {
                case EQ: {
                    if (existingRestriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes an Equal", def.name));
                    }
                    Term t = newRel.getValue().prepare(this.keyspace(), receiver);
                    t.collectMarkerSpecification(boundNames);
                    existingRestriction = new SingleColumnRestriction.EQ(t, newRel.onToken);
                    break;
                }
                case IN: {
                    if (existingRestriction != null) {
                        throw new InvalidRequestException(String.format("%s cannot be restricted by more than one relation if it includes a IN", def.name));
                    }
                    if (newRel.getInValues() == null) {
                        assert (newRel.getValue() != null);
                        Term t = newRel.getValue().prepare(this.keyspace(), receiver);
                        t.collectMarkerSpecification(boundNames);
                        existingRestriction = new SingleColumnRestriction.InWithMarker((Lists.Marker)t);
                        break;
                    }
                    ArrayList<Term> inValues = new ArrayList<Term>(newRel.getInValues().size());
                    for (Term.Raw raw : newRel.getInValues()) {
                        Term t = raw.prepare(this.keyspace(), receiver);
                        t.collectMarkerSpecification(boundNames);
                        inValues.add(t);
                    }
                    existingRestriction = new SingleColumnRestriction.InWithValues(inValues);
                    break;
                }
                case NEQ: {
                    throw new InvalidRequestException(String.format("Unsupported \"!=\" relation on column \"%s\"", def.name));
                }
                case LT: 
                case GT: 
                case LTE: 
                case GTE: {
                    if (existingRestriction == null) {
                        existingRestriction = new SingleColumnRestriction.Slice(newRel.onToken);
                    } else {
                        if (!existingRestriction.isSlice()) {
                            throw new InvalidRequestException(String.format("Column \"%s\" cannot be restricted by both an equality and an inequality relation", def.name));
                        }
                        if (existingRestriction.isMultiColumn()) {
                            throw new InvalidRequestException(String.format("Column \"%s\" cannot be restricted by both a tuple notation inequality and a single column inequality (%s)", def.name, newRel));
                        }
                        if (existingRestriction.isOnToken() != newRel.onToken) {
                            throw new InvalidRequestException("Only EQ and IN relation are supported on the partition key (unless you use the token() function)");
                        }
                    }
                    Term t = newRel.getValue().prepare(this.keyspace(), receiver);
                    t.collectMarkerSpecification(boundNames);
                    ((SingleColumnRestriction.Slice)existingRestriction).setBound(def.name, newRel.operator(), t);
                    break;
                }
                case CONTAINS_KEY: {
                    if (!(receiver.type instanceof MapType)) {
                        throw new InvalidRequestException(String.format("Cannot use CONTAINS_KEY on non-map column %s", def.name));
                    }
                }
                case CONTAINS: {
                    if (!receiver.type.isCollection()) {
                        throw new InvalidRequestException(String.format("Cannot use %s relation on non collection column %s", new Object[]{newRel.operator(), def.name}));
                    }
                    if (existingRestriction == null) {
                        existingRestriction = new SingleColumnRestriction.Contains();
                    } else if (!existingRestriction.isContains()) {
                        throw new InvalidRequestException(String.format("Collection column %s can only be restricted by CONTAINS or CONTAINS KEY", def.name));
                    }
                    boolean isKey = newRel.operator() == Relation.Type.CONTAINS_KEY;
                    receiver = RawStatement.makeCollectionReceiver(receiver, isKey);
                    Term t = newRel.getValue().prepare(this.keyspace(), receiver);
                    t.collectMarkerSpecification(boundNames);
                    ((SingleColumnRestriction.Contains)existingRestriction).add(t, isKey);
                    break;
                }
            }
            return existingRestriction;
        }

        private void processPartitionKeyRestrictions(SelectStatement stmt, boolean hasQueriableIndex, CFMetaData cfm) throws InvalidRequestException {
            boolean canRestrictFurtherComponents = true;
            ColumnDefinition previous = null;
            stmt.keyIsInRelation = false;
            Iterator<ColumnDefinition> iter = cfm.partitionKeyColumns().iterator();
            for (int i = 0; i < stmt.keyRestrictions.length; ++i) {
                ColumnDefinition cdef = iter.next();
                Restriction restriction = stmt.keyRestrictions[i];
                if (restriction == null) {
                    if (stmt.onToken) {
                        throw new InvalidRequestException("The token() function must be applied to all partition key components or none of them");
                    }
                    if (i > 0 && stmt.keyRestrictions[i - 1] != null) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            stmt.isKeyRange = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("Partition key part %s must be restricted since preceding part is", cdef.name));
                    }
                    stmt.isKeyRange = true;
                    canRestrictFurtherComponents = false;
                } else {
                    if (!canRestrictFurtherComponents) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("Partitioning column \"%s\" cannot be restricted because the preceding column (\"%s\") is either not restricted or is restricted by a non-EQ relation", cdef.name, previous));
                    }
                    if (restriction.isOnToken()) {
                        stmt.isKeyRange = true;
                        stmt.onToken = true;
                    } else {
                        if (stmt.onToken) {
                            throw new InvalidRequestException(String.format("The token() function must be applied to all partition key components or none of them", new Object[0]));
                        }
                        if (!restriction.isSlice()) {
                            if (restriction.isIN()) {
                                if (i != stmt.keyRestrictions.length - 1) {
                                    throw new InvalidRequestException(String.format("Partition KEY part %s cannot be restricted by IN relation (only the last part of the partition key can)", cdef.name));
                                }
                                stmt.keyIsInRelation = true;
                            }
                        } else {
                            throw new InvalidRequestException("Only EQ and IN relation are supported on the partition key (unless you use the token() function)");
                        }
                    }
                }
                previous = cdef;
            }
            if (stmt.onToken) {
                this.checkTokenFunctionArgumentsOrder(cfm);
            }
        }

        private void checkTokenFunctionArgumentsOrder(CFMetaData cfm) throws InvalidRequestException {
            Iterator iter = Iterators.cycle(cfm.partitionKeyColumns());
            for (Relation relation : this.whereClause) {
                SingleColumnRelation singleColumnRelation = (SingleColumnRelation)relation;
                if (!singleColumnRelation.onToken || cfm.getColumnDefinition(singleColumnRelation.getEntity()).equals(iter.next())) continue;
                throw new InvalidRequestException(String.format("The token function arguments must be in the partition key order: %s", Joiner.on((char)',').join(cfm.partitionKeyColumns())));
            }
        }

        private void processColumnRestrictions(SelectStatement stmt, boolean hasQueriableIndex, CFMetaData cfm) throws InvalidRequestException {
            boolean canRestrictFurtherComponents = true;
            ColumnDefinition previous = null;
            boolean previousIsSlice = false;
            Iterator<ColumnDefinition> iter = cfm.clusteringColumns().iterator();
            for (int i = 0; i < stmt.columnRestrictions.length; ++i) {
                ColumnDefinition cdef = iter.next();
                Restriction restriction = stmt.columnRestrictions[i];
                if (restriction == null) {
                    canRestrictFurtherComponents = false;
                    previousIsSlice = false;
                } else if (!canRestrictFurtherComponents) {
                    if (!(previousIsSlice && restriction.isSlice() && restriction.isMultiColumn())) {
                        if (hasQueriableIndex) {
                            stmt.usesSecondaryIndexing = true;
                            break;
                        }
                        throw new InvalidRequestException(String.format("PRIMARY KEY column \"%s\" cannot be restricted (preceding column \"%s\" is either not restricted or by a non-EQ relation)", cdef.name, previous));
                    }
                } else if (restriction.isSlice()) {
                    canRestrictFurtherComponents = false;
                    previousIsSlice = true;
                    Restriction.Slice slice = (Restriction.Slice)restriction;
                    if (!(cfm.comparator.isCompound() || slice.isInclusive(Bound.START) && slice.isInclusive(Bound.END))) {
                        stmt.sliceRestriction = slice;
                    }
                } else if (restriction.isIN() && stmt.selectACollection()) {
                    throw new InvalidRequestException(String.format("Cannot restrict column \"%s\" by IN relation as a collection is selected by the query", cdef.name));
                }
                previous = cdef;
            }
        }

        private void validateSecondaryIndexSelections(SelectStatement stmt) throws InvalidRequestException {
            if (stmt.keyIsInRelation) {
                throw new InvalidRequestException("Select on indexed columns and with IN clause for the PRIMARY KEY are not supported");
            }
            if (stmt.selectsOnlyStaticColumns) {
                throw new InvalidRequestException("Queries using 2ndary indexes don't support selecting only static columns");
            }
        }

        private void verifyOrderingIsAllowed(SelectStatement stmt) throws InvalidRequestException {
            if (stmt.usesSecondaryIndexing) {
                throw new InvalidRequestException("ORDER BY with 2ndary indexes is not supported.");
            }
            if (stmt.isKeyRange) {
                throw new InvalidRequestException("ORDER BY is only supported when the partition key is restricted by an EQ or an IN.");
            }
        }

        private void handleUnrecognizedOrderingColumn(ColumnIdentifier column) throws InvalidRequestException {
            if (this.containsAlias(column)) {
                throw new InvalidRequestException(String.format("Aliases are not allowed in order by clause ('%s')", column));
            }
            throw new InvalidRequestException(String.format("Order by on unknown column %s", column));
        }

        private void processOrderingClause(SelectStatement stmt, CFMetaData cfm) throws InvalidRequestException {
            this.verifyOrderingIsAllowed(stmt);
            if (stmt.keyIsInRelation) {
                stmt.orderingIndexes = new HashMap();
                for (ColumnIdentifier column : stmt.parameters.orderings.keySet()) {
                    int index;
                    ColumnDefinition def = cfm.getColumnDefinition(column);
                    if (def == null) {
                        this.handleUnrecognizedOrderingColumn(column);
                    }
                    if ((index = this.indexOf(def, stmt.selection)) < 0) {
                        index = stmt.selection.addColumnForOrdering(def);
                    }
                    stmt.orderingIndexes.put(def.name, index);
                }
            }
            stmt.isReversed = this.isReversed(stmt, cfm);
        }

        private boolean isReversed(SelectStatement stmt, CFMetaData cfm) throws InvalidRequestException {
            Boolean[] reversedMap = new Boolean[cfm.clusteringColumns().size()];
            int i = 0;
            for (Map.Entry entry : stmt.parameters.orderings.entrySet()) {
                ColumnIdentifier column = (ColumnIdentifier)entry.getKey();
                boolean reversed = (Boolean)entry.getValue();
                ColumnDefinition def = cfm.getColumnDefinition(column);
                if (def == null) {
                    this.handleUnrecognizedOrderingColumn(column);
                }
                if (def.kind != ColumnDefinition.Kind.CLUSTERING_COLUMN) {
                    throw new InvalidRequestException(String.format("Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", column));
                }
                if (i++ != def.position()) {
                    throw new InvalidRequestException(String.format("Order by currently only support the ordering of columns following their declared order in the PRIMARY KEY", new Object[0]));
                }
                reversedMap[def.position()] = reversed != SelectStatement.isReversedType(def);
            }
            Boolean isReversed = null;
            for (Boolean b : reversedMap) {
                if (b == null) continue;
                if (isReversed == null) {
                    isReversed = b;
                    continue;
                }
                if (isReversed.equals(b)) continue;
                throw new InvalidRequestException(String.format("Unsupported order by relation", new Object[0]));
            }
            assert (isReversed != null);
            return isReversed;
        }

        private void checkNeedsFiltering(SelectStatement stmt) throws InvalidRequestException {
            if (!this.parameters.allowFiltering && (stmt.isKeyRange || stmt.usesSecondaryIndexing) && RawStatement.needFiltering(stmt)) {
                throw new InvalidRequestException("Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING");
            }
            if (stmt.sliceRestriction != null && stmt.isKeyRange && this.limit != null) {
                SingleColumnRelation rel = this.findInclusiveClusteringRelationForCompact(stmt.cfm);
                throw new InvalidRequestException(String.format("The query requests a restriction of rows with a strict bound (%s) over a range of partitions. This is not supported by the underlying storage engine for COMPACT tables if a LIMIT is provided. Please either make the condition non strict (%s) or remove the user LIMIT", rel, rel.withNonStrictOperator()));
            }
        }

        private static boolean needFiltering(SelectStatement stmt) {
            return stmt.restrictedColumns.size() > 1 || stmt.restrictedColumns.isEmpty() && !stmt.columnFilterIsIdentity() || !stmt.restrictedColumns.isEmpty() && stmt.isRestrictedByMultipleContains((ColumnDefinition)Iterables.getOnlyElement((Iterable)stmt.restrictedColumns));
        }

        private int indexOf(ColumnDefinition def, Selection selection) {
            return this.indexOf(def, selection.getColumns().iterator());
        }

        private int indexOf(final ColumnDefinition def, Iterator<ColumnDefinition> defs) {
            return Iterators.indexOf(defs, (Predicate)new Predicate<ColumnDefinition>(){

                public boolean apply(ColumnDefinition n) {
                    return def.name.equals(n.name);
                }
            });
        }

        private SingleColumnRelation findInclusiveClusteringRelationForCompact(CFMetaData cfm) {
            for (Relation r : this.whereClause) {
                SingleColumnRelation rel = (SingleColumnRelation)r;
                if (cfm.getColumnDefinition((ColumnIdentifier)rel.getEntity()).kind != ColumnDefinition.Kind.CLUSTERING_COLUMN || rel.operator() != Relation.Type.GT && rel.operator() != Relation.Type.LT) continue;
                return rel;
            }
            throw new AssertionError();
        }

        private boolean containsAlias(final ColumnIdentifier name) {
            return Iterables.any(this.selectClause, (Predicate)new Predicate<RawSelector>(){

                public boolean apply(RawSelector raw) {
                    return name.equals(raw.alias);
                }
            });
        }

        private ColumnSpecification limitReceiver() {
            return new ColumnSpecification(this.keyspace(), this.columnFamily(), new ColumnIdentifier("[limit]", true), Int32Type.instance);
        }

        private static ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
            assert (collection.type.isCollection());
            switch (((CollectionType)collection.type).kind) {
                case LIST: {
                    assert (!isKey);
                    return Lists.valueSpecOf(collection);
                }
                case SET: {
                    assert (!isKey);
                    return Sets.valueSpecOf(collection);
                }
                case MAP: {
                    return isKey ? Maps.keySpecOf(collection) : Maps.valueSpecOf(collection);
                }
            }
            throw new AssertionError();
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.cfName).add("selectClause", this.selectClause).add("whereClause", this.whereClause).add("isDistinct", this.parameters.isDistinct).toString();
        }
    }
}

