/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.Composite;

public final class CompositesBuilder {
    private final CBuilder builder;
    private final Comparator<Composite> comparator;
    private final List<List<ByteBuffer>> elementsList = new ArrayList<List<ByteBuffer>>();
    private int remaining;
    private boolean built;
    private boolean containsNull;

    public CompositesBuilder(CBuilder builder, Comparator<Composite> comparator) {
        this.builder = builder;
        this.comparator = comparator;
        this.remaining = builder.remainingCount();
    }

    public CompositesBuilder addElementToAll(ByteBuffer value) {
        this.checkUpdateable();
        if (this.isEmpty()) {
            this.elementsList.add(new ArrayList());
        }
        int m = this.elementsList.size();
        for (int i = 0; i < m; ++i) {
            if (value == null) {
                this.containsNull = true;
            }
            this.elementsList.get(i).add(value);
        }
        --this.remaining;
        return this;
    }

    public CompositesBuilder addEachElementToAll(List<ByteBuffer> values) {
        this.checkUpdateable();
        if (this.isEmpty()) {
            this.elementsList.add(new ArrayList());
        }
        int m = this.elementsList.size();
        for (int i = 0; i < m; ++i) {
            List<ByteBuffer> oldComposite = this.elementsList.remove(0);
            int n = values.size();
            for (int j = 0; j < n; ++j) {
                ArrayList<ByteBuffer> newComposite = new ArrayList<ByteBuffer>(oldComposite);
                this.elementsList.add(newComposite);
                ByteBuffer value = values.get(j);
                if (value == null) {
                    this.containsNull = true;
                }
                newComposite.add(values.get(j));
            }
        }
        --this.remaining;
        return this;
    }

    public int remainingCount() {
        return this.remaining;
    }

    public boolean hasRemaining() {
        return this.remaining > 0;
    }

    public boolean isEmpty() {
        return this.elementsList.isEmpty();
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public List<Composite> build() {
        return this.buildWithEOC(Composite.EOC.NONE);
    }

    public List<Composite> buildWithEOC(Composite.EOC eoc) {
        this.built = true;
        if (this.elementsList.isEmpty()) {
            return Collections.singletonList(this.builder.build().withEOC(eoc));
        }
        TreeSet<Composite> set = new TreeSet<Composite>(this.comparator);
        int m = this.elementsList.size();
        for (int i = 0; i < m; ++i) {
            List<ByteBuffer> elements = this.elementsList.get(i);
            set.add(this.builder.buildWith(elements).withEOC(eoc));
        }
        return new ArrayList<Composite>(set);
    }

    private void checkUpdateable() {
        if (!this.hasRemaining() || this.built) {
            throw new IllegalStateException("this CompositesBuilder cannot be updated anymore");
        }
    }
}

