/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;

public abstract class AbstractType<T>
implements Comparator<ByteBuffer> {
    public final Comparator<ByteBuffer> reverseComparator = new Comparator<ByteBuffer>(){

        @Override
        public int compare(ByteBuffer o1, ByteBuffer o2) {
            if (o1.remaining() == 0) {
                return o2.remaining() == 0 ? 0 : -1;
            }
            if (o2.remaining() == 0) {
                return 1;
            }
            return AbstractType.this.compare(o2, o1);
        }
    };

    protected AbstractType() {
    }

    public T compose(ByteBuffer bytes) {
        return this.getSerializer().deserialize(bytes);
    }

    public ByteBuffer decompose(T value) {
        return this.getSerializer().serialize(value);
    }

    public String getString(ByteBuffer bytes) {
        TypeSerializer<T> serializer = this.getSerializer();
        serializer.validate(bytes);
        return serializer.toString(serializer.deserialize(bytes));
    }

    public abstract ByteBuffer fromString(String var1) throws MarshalException;

    public void validate(ByteBuffer bytes) throws MarshalException {
        this.getSerializer().validate(bytes);
    }

    public void validateCellValue(ByteBuffer cellValue) throws MarshalException {
        this.validate(cellValue);
    }

    public CQL3Type asCQL3Type() {
        return new CQL3Type.Custom(this);
    }

    public abstract TypeSerializer<T> getSerializer();

    public String getString(Collection<ByteBuffer> names) {
        StringBuilder builder = new StringBuilder();
        for (ByteBuffer name : names) {
            builder.append(this.getString(name)).append(",");
        }
        return builder.toString();
    }

    public boolean isCounter() {
        return false;
    }

    public static AbstractType<?> parseDefaultParameters(AbstractType<?> baseType, TypeParser parser) throws SyntaxException {
        Map<String, String> parameters = parser.getKeyValueParameters();
        String reversed = parameters.get("reversed");
        if (reversed != null && (reversed.isEmpty() || reversed.equals("true"))) {
            return ReversedType.getInstance(baseType);
        }
        return baseType;
    }

    public boolean isCompatibleWith(AbstractType<?> previous) {
        return this.equals(previous);
    }

    public boolean isValueCompatibleWith(AbstractType<?> otherType) {
        return this.isValueCompatibleWithInternal(otherType instanceof ReversedType ? ((ReversedType)otherType).baseType : otherType);
    }

    protected boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this.isCompatibleWith(otherType);
    }

    public boolean isByteOrderComparable() {
        return false;
    }

    public int compareCollectionMembers(ByteBuffer v1, ByteBuffer v2, ByteBuffer collectionName) {
        return this.compare(v1, v2);
    }

    public void validateCollectionMember(ByteBuffer bytes, ByteBuffer collectionName) throws MarshalException {
        this.validate(bytes);
    }

    public boolean isCollection() {
        return false;
    }

    public int componentsCount() {
        return 1;
    }

    public List<AbstractType<?>> getComponents() {
        return Collections.singletonList(this);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

