/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.File;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.format.SSTableWriter;

public class SSTableSimpleWriter
extends AbstractSSTableSimpleWriter {
    private final SSTableWriter writer = this.getWriter();

    public SSTableSimpleWriter(File directory, IPartitioner partitioner, String keyspace, String columnFamily, AbstractType<?> comparator, AbstractType<?> subComparator) {
        this(directory, CFMetaData.denseCFMetaData(keyspace, columnFamily, comparator, subComparator), partitioner);
    }

    public SSTableSimpleWriter(File directory, CFMetaData metadata, IPartitioner partitioner) {
        super(directory, metadata, partitioner);
    }

    @Override
    public void close() {
        try {
            if (this.currentKey != null) {
                this.writeRow(this.currentKey, this.columnFamily);
            }
            this.writer.close();
        }
        catch (FSError e) {
            this.writer.abort();
            throw e;
        }
    }

    @Override
    protected void writeRow(DecoratedKey key, ColumnFamily columnFamily) {
        this.writer.append(key, columnFamily);
    }

    @Override
    protected ColumnFamily getColumnFamily() {
        return ArrayBackedSortedColumns.factory.create(this.metadata);
    }
}

