/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.big.BigTableScanner;
import org.apache.cassandra.io.sstable.format.big.SSTableNamesIterator;
import org.apache.cassandra.io.sstable.format.big.SSTableSliceIterator;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigTableReader
extends SSTableReader {
    private static final Logger logger = LoggerFactory.getLogger(BigTableReader.class);

    BigTableReader(Descriptor desc, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, Long maxDataAge, StatsMetadata sstableMetadata, SSTableReader.OpenReason openReason) {
        super(desc, components, metadata, partitioner, maxDataAge, sstableMetadata, openReason);
    }

    @Override
    public OnDiskAtomIterator iterator(DecoratedKey key, SortedSet<CellName> columns) {
        return new SSTableNamesIterator(this, key, columns);
    }

    @Override
    public OnDiskAtomIterator iterator(FileDataInput input, DecoratedKey key, SortedSet<CellName> columns, RowIndexEntry indexEntry) {
        return new SSTableNamesIterator(this, input, key, columns, indexEntry);
    }

    @Override
    public OnDiskAtomIterator iterator(DecoratedKey key, ColumnSlice[] slices, boolean reverse) {
        return new SSTableSliceIterator(this, key, slices, reverse);
    }

    @Override
    public OnDiskAtomIterator iterator(FileDataInput input, DecoratedKey key, ColumnSlice[] slices, boolean reverse, RowIndexEntry indexEntry) {
        return new SSTableSliceIterator(this, input, key, slices, reverse, indexEntry);
    }

    @Override
    public ICompactionScanner getScanner(DataRange dataRange, RateLimiter limiter) {
        return new BigTableScanner((SSTableReader)this, dataRange, limiter);
    }

    @Override
    public ICompactionScanner getScanner(Collection<Range<Token>> ranges, RateLimiter limiter) {
        List<Pair<Long, Long>> positions = this.getPositionsForRanges(Range.normalize(ranges));
        if (positions.isEmpty()) {
            return new SSTableReader.EmptyCompactionScanner(this.getFilename());
        }
        return new BigTableScanner((SSTableReader)this, ranges, limiter);
    }

    @Override
    public RowIndexEntry getPosition(RowPosition key, SSTableReader.Operator op, boolean updateCacheAndStats) {
        DecoratedKey decoratedKey;
        KeyCacheKey cacheKey;
        RowIndexEntry cachedPosition;
        if (op == SSTableReader.Operator.EQ) {
            assert (key instanceof DecoratedKey);
            if (!this.bf.isPresent(((DecoratedKey)key).getKey())) {
                Tracing.trace("Bloom filter allows skipping sstable {}", this.descriptor.generation);
                return null;
            }
        }
        if ((op == SSTableReader.Operator.EQ || op == SSTableReader.Operator.GE) && key instanceof DecoratedKey && (cachedPosition = this.getCachedPosition(cacheKey = new KeyCacheKey(this.metadata.cfId, this.descriptor, (decoratedKey = (DecoratedKey)key).getKey()), updateCacheAndStats)) != null) {
            Tracing.trace("Key cache hit for sstable {}", this.descriptor.generation);
            return cachedPosition;
        }
        if (this.first.compareTo(key) > 0 || this.last.compareTo(key) < 0) {
            if (op == SSTableReader.Operator.EQ && updateCacheAndStats) {
                this.bloomFilterTracker.addFalsePositive();
            }
            if (op.apply(1) < 0) {
                Tracing.trace("Check against min and max keys allows skipping sstable {}", this.descriptor.generation);
                return null;
            }
        }
        int binarySearchResult = this.indexSummary.binarySearch(key);
        long sampledPosition = BigTableReader.getIndexScanPositionFromBinarySearchResult(binarySearchResult, this.indexSummary);
        int sampledIndex = BigTableReader.getIndexSummaryIndexFromBinarySearchResult(binarySearchResult);
        sampledPosition = sampledPosition == -1L ? 0L : sampledPosition;
        int effectiveInterval = this.indexSummary.getEffectiveIndexIntervalAfterIndex(sampledIndex);
        int i = 0;
        Iterator<FileDataInput> segments = this.ifile.iterator(sampledPosition);
        while (segments.hasNext() && i <= effectiveInterval) {
            FileDataInput in = segments.next();
            try {
                while (!in.isEOF() && i <= effectiveInterval) {
                    boolean opSatisfied;
                    boolean exactMatch;
                    ++i;
                    ByteBuffer indexKey = ByteBufferUtil.readWithShortLength(in);
                    if (op == SSTableReader.Operator.EQ) {
                        opSatisfied = exactMatch = indexKey.equals(((DecoratedKey)key).getKey());
                    } else {
                        DecoratedKey indexDecoratedKey = this.partitioner.decorateKey(indexKey);
                        int comparison = indexDecoratedKey.compareTo(key);
                        int v = op.apply(comparison);
                        opSatisfied = v == 0;
                        boolean bl = exactMatch = comparison == 0;
                        if (v < 0) {
                            Tracing.trace("Partition index lookup allows skipping sstable {}", this.descriptor.generation);
                            RowIndexEntry rowIndexEntry = null;
                            return rowIndexEntry;
                        }
                    }
                    if (opSatisfied) {
                        RowIndexEntry indexEntry = this.rowIndexEntrySerializer.deserialize(in, this.descriptor.version);
                        if (exactMatch && updateCacheAndStats) {
                            assert (key instanceof DecoratedKey);
                            DecoratedKey decoratedKey2 = (DecoratedKey)key;
                            if (logger.isTraceEnabled()) {
                                FileDataInput fdi = this.dfile.getSegment(indexEntry.position);
                                DecoratedKey keyInDisk = this.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(fdi));
                                if (!keyInDisk.equals(key)) {
                                    throw new AssertionError((Object)String.format("%s != %s in %s", keyInDisk, key, fdi.getPath()));
                                }
                                fdi.close();
                            }
                            this.cacheKey(decoratedKey2, indexEntry);
                        }
                        if (op == SSTableReader.Operator.EQ && updateCacheAndStats) {
                            this.bloomFilterTracker.addTruePositive();
                        }
                        Tracing.trace("Partition index with {} entries found for sstable {}", indexEntry.columnsIndex().size(), this.descriptor.generation);
                        RowIndexEntry rowIndexEntry = indexEntry;
                        return rowIndexEntry;
                    }
                    RowIndexEntry.Serializer.skip(in);
                }
            }
            catch (IOException e) {
                this.markSuspect();
                throw new CorruptSSTableException((Exception)e, in.getPath());
            }
            finally {
                FileUtils.closeQuietly(in);
            }
        }
        if (op == SSTableReader.Operator.EQ && updateCacheAndStats) {
            this.bloomFilterTracker.addFalsePositive();
        }
        Tracing.trace("Partition index lookup complete (bloom filter false positive) for sstable {}", this.descriptor.generation);
        return null;
    }
}

