/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.columniterator.IColumnIteratorFactory;
import org.apache.cassandra.db.columniterator.LazyColumnIterator;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;

public class BigTableScanner
implements ICompactionScanner {
    protected final RandomAccessReader dfile;
    protected final RandomAccessReader ifile;
    public final SSTableReader sstable;
    private final Iterator<AbstractBounds<RowPosition>> rangeIterator;
    private AbstractBounds<RowPosition> currentRange;
    private final DataRange dataRange;
    private final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    protected Iterator<OnDiskAtomIterator> iterator;

    public BigTableScanner(SSTableReader sstable, DataRange dataRange, RateLimiter limiter) {
        assert (sstable != null);
        this.dfile = limiter == null ? sstable.openDataReader() : sstable.openDataReader(limiter);
        this.ifile = sstable.openIndexReader();
        this.sstable = sstable;
        this.dataRange = dataRange;
        this.rowIndexEntrySerializer = sstable.descriptor.version.getSSTableFormat().getIndexSerializer(sstable.metadata);
        ArrayList<Bounds<RowPosition>> boundsList = new ArrayList<Bounds<RowPosition>>(2);
        if (dataRange.isWrapAround() && !dataRange.stopKey().isMinimum(sstable.partitioner)) {
            boundsList.add(new Bounds<RowPosition>(((Token)sstable.partitioner.getMinimumToken()).minKeyBound(), dataRange.stopKey(), sstable.partitioner));
            boundsList.add(new Bounds<Token.KeyBound>((Token.KeyBound)dataRange.startKey(), ((Token)sstable.partitioner.getMinimumToken()).maxKeyBound(), sstable.partitioner));
        } else {
            boundsList.add(new Bounds<RowPosition>(dataRange.startKey(), dataRange.stopKey(), sstable.partitioner));
        }
        this.rangeIterator = boundsList.iterator();
    }

    public BigTableScanner(SSTableReader sstable, Collection<Range<Token>> tokenRanges, RateLimiter limiter) {
        assert (sstable != null);
        this.dfile = limiter == null ? sstable.openDataReader() : sstable.openDataReader(limiter);
        this.ifile = sstable.openIndexReader();
        this.sstable = sstable;
        this.dataRange = null;
        this.rowIndexEntrySerializer = sstable.descriptor.version.getSSTableFormat().getIndexSerializer(sstable.metadata);
        List normalized = Range.normalize(tokenRanges);
        ArrayList<Range<Token.KeyBound>> boundsList = new ArrayList<Range<Token.KeyBound>>(normalized.size());
        for (Range range : normalized) {
            boundsList.add(new Range<Token.KeyBound>(((Token)range.left).maxKeyBound(sstable.partitioner), ((Token)range.right).maxKeyBound(sstable.partitioner), sstable.partitioner));
        }
        this.rangeIterator = boundsList.iterator();
    }

    private void seekToCurrentRangeStart() {
        if (((RowPosition)this.currentRange.left).isMinimum(this.sstable.partitioner)) {
            return;
        }
        long indexPosition = this.sstable.getIndexScanPosition((RowPosition)this.currentRange.left);
        if (indexPosition == -1L) {
            this.ifile.seek(0L);
            this.dfile.seek(0L);
            return;
        }
        this.ifile.seek(indexPosition);
        try {
            while (!this.ifile.isEOF()) {
                indexPosition = this.ifile.getFilePointer();
                DecoratedKey indexDecoratedKey = this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(this.ifile));
                int comparison = indexDecoratedKey.compareTo((RowPosition)this.currentRange.left);
                if (comparison > 0 || this.currentRange.contains(indexDecoratedKey)) {
                    long dataPosition = this.ifile.readLong();
                    this.ifile.seek(indexPosition);
                    this.dfile.seek(dataPosition);
                    break;
                }
                RowIndexEntry.Serializer.skip(this.ifile);
            }
        }
        catch (IOException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, this.sstable.getFilename());
        }
    }

    @Override
    public void close() throws IOException {
        FileUtils.close(this.dfile, this.ifile);
    }

    @Override
    public long getLengthInBytes() {
        return this.dfile.length();
    }

    @Override
    public long getCurrentPosition() {
        return this.dfile.getFilePointer();
    }

    @Override
    public String getBackingFiles() {
        return this.sstable.toString();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public OnDiskAtomIterator next() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Iterator<OnDiskAtomIterator> createIterator() {
        return new KeyScanningIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "dfile=" + this.dfile + " ifile=" + this.ifile + " sstable=" + this.sstable + ")";
    }

    protected class KeyScanningIterator
    extends AbstractIterator<OnDiskAtomIterator> {
        private DecoratedKey nextKey;
        private RowIndexEntry nextEntry;
        private DecoratedKey currentKey;
        private RowIndexEntry currentEntry;

        protected KeyScanningIterator() {
        }

        protected OnDiskAtomIterator computeNext() {
            try {
                if (this.nextEntry == null) {
                    do {
                        if (!BigTableScanner.this.rangeIterator.hasNext()) {
                            return (OnDiskAtomIterator)this.endOfData();
                        }
                        BigTableScanner.this.currentRange = (AbstractBounds)BigTableScanner.this.rangeIterator.next();
                        BigTableScanner.this.seekToCurrentRangeStart();
                        if (BigTableScanner.this.ifile.isEOF()) {
                            return (OnDiskAtomIterator)this.endOfData();
                        }
                        this.currentKey = BigTableScanner.this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(BigTableScanner.this.ifile));
                        this.currentEntry = BigTableScanner.this.rowIndexEntrySerializer.deserialize(BigTableScanner.this.ifile, BigTableScanner.this.sstable.descriptor.version);
                    } while (!BigTableScanner.this.currentRange.contains(this.currentKey));
                } else {
                    this.currentKey = this.nextKey;
                    this.currentEntry = this.nextEntry;
                }
                if (BigTableScanner.this.ifile.isEOF()) {
                    this.nextEntry = null;
                    this.nextKey = null;
                    long readEnd = BigTableScanner.this.dfile.length();
                } else {
                    this.nextKey = BigTableScanner.this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(BigTableScanner.this.ifile));
                    this.nextEntry = BigTableScanner.this.rowIndexEntrySerializer.deserialize(BigTableScanner.this.ifile, BigTableScanner.this.sstable.descriptor.version);
                    long readEnd = this.nextEntry.position;
                    if (!BigTableScanner.this.currentRange.contains(this.nextKey)) {
                        this.nextKey = null;
                        this.nextEntry = null;
                    }
                }
                if (BigTableScanner.this.dataRange == null || BigTableScanner.this.dataRange.selectsFullRowFor(this.currentKey.getKey())) {
                    BigTableScanner.this.dfile.seek(this.currentEntry.position + this.currentEntry.headerOffset());
                    ByteBufferUtil.readWithShortLength(BigTableScanner.this.dfile);
                    return new SSTableIdentityIterator(BigTableScanner.this.sstable, BigTableScanner.this.dfile, this.currentKey);
                }
                return new LazyColumnIterator(this.currentKey, new IColumnIteratorFactory(){

                    @Override
                    public OnDiskAtomIterator create() {
                        return BigTableScanner.this.dataRange.columnFilter(KeyScanningIterator.this.currentKey.getKey()).getSSTableColumnIterator(BigTableScanner.this.sstable, BigTableScanner.this.dfile, KeyScanningIterator.this.currentKey, KeyScanningIterator.this.currentEntry);
                    }
                });
            }
            catch (IOException e) {
                BigTableScanner.this.sstable.markSuspect();
                throw new CorruptSSTableException((Exception)e, BigTableScanner.this.sstable.getFilename());
            }
        }
    }
}

