/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.AbstractCell;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.sstable.ColumnNameHelper;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.DataOutputStreamAndChannel;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.StreamingHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigTableWriter
extends SSTableWriter {
    private static final Logger logger = LoggerFactory.getLogger(BigTableWriter.class);
    public static final int END_OF_ROW = 0;
    private IndexWriter iwriter;
    private SegmentedFile.Builder dbuilder;
    private final SequentialWriter dataFile;
    private DecoratedKey lastWrittenKey;
    private FileMark dataMark;

    BigTableWriter(Descriptor descriptor, Long keyCount, Long repairedAt, CFMetaData metadata, IPartitioner partitioner, MetadataCollector metadataCollector) {
        super(descriptor, keyCount, repairedAt, metadata, partitioner, metadataCollector);
        this.iwriter = new IndexWriter(keyCount);
        if (this.compression) {
            this.dataFile = SequentialWriter.open(this.getFilename(), descriptor.filenameFor(Component.COMPRESSION_INFO), metadata.compressionParameters(), metadataCollector);
            this.dbuilder = SegmentedFile.getCompressedBuilder((CompressedSequentialWriter)this.dataFile);
        } else {
            this.dataFile = SequentialWriter.open(new File(this.getFilename()), new File(descriptor.filenameFor(Component.CRC)));
            this.dbuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getDiskAccessMode());
        }
    }

    @Override
    public void mark() {
        this.dataMark = this.dataFile.mark();
        this.iwriter.mark();
    }

    @Override
    public void resetAndTruncate() {
        this.dataFile.resetAndTruncate(this.dataMark);
        this.iwriter.resetAndTruncate();
    }

    private long beforeAppend(DecoratedKey decoratedKey) {
        assert (decoratedKey != null) : "Keys must not be null";
        if (this.lastWrittenKey != null && this.lastWrittenKey.compareTo(decoratedKey) >= 0) {
            throw new RuntimeException("Last written key " + this.lastWrittenKey + " >= current key " + decoratedKey + " writing into " + this.getFilename());
        }
        return this.lastWrittenKey == null ? 0L : this.dataFile.getFilePointer();
    }

    private void afterAppend(DecoratedKey decoratedKey, long dataPosition, RowIndexEntry index) {
        this.metadataCollector.addKey(decoratedKey.getKey());
        this.last = this.lastWrittenKey = decoratedKey;
        if (this.first == null) {
            this.first = this.lastWrittenKey;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("wrote {} at {}", (Object)decoratedKey, (Object)dataPosition);
        }
        this.iwriter.append(decoratedKey, index);
        this.dbuilder.addPotentialBoundary(dataPosition);
    }

    @Override
    public RowIndexEntry append(AbstractCompactedRow row) {
        RowIndexEntry entry;
        long currentPosition = this.beforeAppend(row.key);
        try {
            entry = row.write(currentPosition, this.dataFile);
            if (entry == null) {
                return null;
            }
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.metadataCollector.update(this.dataFile.getFilePointer() - currentPosition, row.columnStats());
        this.afterAppend(row.key, currentPosition, entry);
        return entry;
    }

    @Override
    public void append(DecoratedKey decoratedKey, ColumnFamily cf) {
        long startPosition = this.beforeAppend(decoratedKey);
        try {
            RowIndexEntry entry = BigTableWriter.rawAppend(cf, startPosition, decoratedKey, this.dataFile.stream);
            this.afterAppend(decoratedKey, startPosition, entry);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.metadataCollector.update(this.dataFile.getFilePointer() - startPosition, cf.getColumnStats());
    }

    private static RowIndexEntry rawAppend(ColumnFamily cf, long startPosition, DecoratedKey key, DataOutputPlus out) throws IOException {
        assert (cf.hasColumns() || cf.isMarkedForDelete());
        ColumnIndex.Builder builder = new ColumnIndex.Builder(cf, key.getKey(), out);
        ColumnIndex index = builder.build(cf);
        out.writeShort(0);
        return RowIndexEntry.create(startPosition, cf.deletionInfo().getTopLevelDeletion(), index);
    }

    @Override
    public long appendFromStream(DecoratedKey key, CFMetaData metadata, DataInput in, Version version) throws IOException {
        long currentPosition = this.beforeAppend(key);
        ColumnStats.MaxLongTracker maxTimestampTracker = new ColumnStats.MaxLongTracker(Long.MAX_VALUE);
        ColumnStats.MinLongTracker minTimestampTracker = new ColumnStats.MinLongTracker(Long.MIN_VALUE);
        ColumnStats.MaxIntTracker maxDeletionTimeTracker = new ColumnStats.MaxIntTracker(Integer.MAX_VALUE);
        List<ByteBuffer> minColumnNames = Collections.emptyList();
        List<ByteBuffer> maxColumnNames = Collections.emptyList();
        StreamingHistogram tombstones = new StreamingHistogram(100);
        boolean hasLegacyCounterShards = false;
        ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(metadata);
        ((ColumnFamily)cf).delete(DeletionTime.serializer.deserialize(in));
        ColumnIndex.Builder columnIndexer = new ColumnIndex.Builder(cf, key.getKey(), this.dataFile.stream);
        if (((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().localDeletionTime < Integer.MAX_VALUE) {
            tombstones.update(((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().localDeletionTime);
            maxDeletionTimeTracker.update(((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().localDeletionTime);
            minTimestampTracker.update(((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().markedForDeleteAt);
            maxTimestampTracker.update(((ColumnFamily)cf).deletionInfo().getTopLevelDeletion().markedForDeleteAt);
        }
        Iterator<RangeTombstone> rangeTombstoneIterator = ((ColumnFamily)cf).deletionInfo().rangeIterator();
        while (rangeTombstoneIterator.hasNext()) {
            RangeTombstone rangeTombstone = rangeTombstoneIterator.next();
            tombstones.update(rangeTombstone.getLocalDeletionTime());
            minTimestampTracker.update(rangeTombstone.timestamp());
            maxTimestampTracker.update(rangeTombstone.timestamp());
            maxDeletionTimeTracker.update(rangeTombstone.getLocalDeletionTime());
            minColumnNames = ColumnNameHelper.minComponents(minColumnNames, (Composite)rangeTombstone.min, metadata.comparator);
            maxColumnNames = ColumnNameHelper.maxComponents(maxColumnNames, (Composite)rangeTombstone.max, metadata.comparator);
        }
        Iterator<OnDiskAtom> iter = AbstractCell.onDiskIterator(in, ColumnSerializer.Flag.PRESERVE_SIZE, Integer.MIN_VALUE, version, metadata.comparator);
        try {
            OnDiskAtom atom;
            while (iter.hasNext() && (atom = iter.next()) != null) {
                int deletionTime;
                if (atom instanceof CounterCell) {
                    atom = ((CounterCell)atom).markLocalToBeCleared();
                    boolean bl = hasLegacyCounterShards = hasLegacyCounterShards || ((CounterCell)atom).hasLegacyShards();
                }
                if ((deletionTime = atom.getLocalDeletionTime()) < Integer.MAX_VALUE) {
                    tombstones.update(deletionTime);
                }
                minTimestampTracker.update(atom.timestamp());
                maxTimestampTracker.update(atom.timestamp());
                minColumnNames = ColumnNameHelper.minComponents(minColumnNames, atom.name(), metadata.comparator);
                maxColumnNames = ColumnNameHelper.maxComponents(maxColumnNames, atom.name(), metadata.comparator);
                maxDeletionTimeTracker.update(atom.getLocalDeletionTime());
                columnIndexer.add(atom);
            }
            columnIndexer.maybeWriteEmptyRowHeader();
            this.dataFile.stream.writeShort(0);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
        this.metadataCollector.updateMinTimestamp(minTimestampTracker.get()).updateMaxTimestamp(maxTimestampTracker.get()).updateMaxLocalDeletionTime(maxDeletionTimeTracker.get()).addRowSize(this.dataFile.getFilePointer() - currentPosition).addColumnCount(columnIndexer.writtenAtomCount()).mergeTombstoneHistogram(tombstones).updateMinColumnNames(minColumnNames).updateMaxColumnNames(maxColumnNames).updateHasLegacyCounterShards(hasLegacyCounterShards);
        this.afterAppend(key, currentPosition, RowIndexEntry.create(currentPosition, ((ColumnFamily)cf).deletionInfo().getTopLevelDeletion(), columnIndexer.build()));
        return currentPosition;
    }

    @Override
    public void abort(boolean closeBf) {
        assert (this.descriptor.type.isTemporary);
        if (this.iwriter == null && this.dataFile == null) {
            return;
        }
        if (this.iwriter != null) {
            FileUtils.closeQuietly(this.iwriter.indexFile);
            if (closeBf) {
                this.iwriter.bf.close();
            }
        }
        if (this.dataFile != null) {
            FileUtils.closeQuietly(this.dataFile);
        }
        Set<Component> components = SSTable.componentsFor(this.descriptor);
        try {
            if (!components.isEmpty()) {
                SSTable.delete(this.descriptor, components);
            }
        }
        catch (FSWriteError e) {
            logger.error(String.format("Failed deleting temp components for %s", this.descriptor), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void isolateReferences() {
        this.first = BigTableWriter.getMinimalKey(this.first);
        this.last = this.lastWrittenKey = BigTableWriter.getMinimalKey(this.last);
    }

    @Override
    public SSTableReader openEarly(long maxDataAge) {
        RowIndexEntry indexEntry;
        StatsMetadata sstableMetadata = (StatsMetadata)this.metadataCollector.finalizeMetadata(this.partitioner.getClass().getCanonicalName(), this.metadata.getBloomFilterFpChance(), this.repairedAt).get((Object)MetadataType.STATS);
        DecoratedKey exclusiveUpperBoundOfReadableIndex = this.iwriter.getMaxReadableKey(0);
        if (exclusiveUpperBoundOfReadableIndex == null) {
            return null;
        }
        Descriptor link = this.descriptor.asType(Descriptor.Type.TEMPLINK);
        if (!new File(link.filenameFor(Component.PRIMARY_INDEX)).exists()) {
            FileUtils.createHardLink(new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)), new File(link.filenameFor(Component.PRIMARY_INDEX)));
            FileUtils.createHardLink(new File(this.descriptor.filenameFor(Component.DATA)), new File(link.filenameFor(Component.DATA)));
        }
        SegmentedFile ifile = this.iwriter.builder.openEarly(link.filenameFor(Component.PRIMARY_INDEX));
        SegmentedFile dfile = this.dbuilder.openEarly(link.filenameFor(Component.DATA));
        SSTableReader sstable = SSTableReader.internalOpen(this.descriptor.asType(Descriptor.Type.FINAL), this.components, this.metadata, this.partitioner, ifile, dfile, this.iwriter.summary.build(this.partitioner, exclusiveUpperBoundOfReadableIndex), this.iwriter.bf, maxDataAge, sstableMetadata, SSTableReader.OpenReason.EARLY);
        sstable.first = BigTableWriter.getMinimalKey(this.first);
        sstable.last = BigTableWriter.getMinimalKey(exclusiveUpperBoundOfReadableIndex);
        DecoratedKey inclusiveUpperBoundOfReadableData = this.iwriter.getMaxReadableKey(1);
        if (inclusiveUpperBoundOfReadableData == null) {
            return null;
        }
        int offset = 2;
        while ((indexEntry = sstable.getPosition(inclusiveUpperBoundOfReadableData, SSTableReader.Operator.GT)) == null || indexEntry.position > this.dataFile.getLastFlushOffset()) {
            if ((inclusiveUpperBoundOfReadableData = this.iwriter.getMaxReadableKey(offset++)) != null) continue;
            return null;
        }
        sstable.last = BigTableWriter.getMinimalKey(inclusiveUpperBoundOfReadableData);
        return sstable;
    }

    @Override
    public SSTableReader closeAndOpenReader(long maxDataAge, long repairedAt) {
        Pair<Descriptor, StatsMetadata> p = this.close(repairedAt);
        Descriptor newdesc = (Descriptor)p.left;
        StatsMetadata sstableMetadata = (StatsMetadata)p.right;
        SegmentedFile ifile = this.iwriter.builder.complete(newdesc.filenameFor(Component.PRIMARY_INDEX));
        SegmentedFile dfile = this.dbuilder.complete(newdesc.filenameFor(Component.DATA));
        SSTableReader sstable = SSTableReader.internalOpen(newdesc, this.components, this.metadata, this.partitioner, ifile, dfile, this.iwriter.summary.build(this.partitioner), this.iwriter.bf, maxDataAge, sstableMetadata, SSTableReader.OpenReason.NORMAL);
        sstable.first = BigTableWriter.getMinimalKey(this.first);
        sstable.last = BigTableWriter.getMinimalKey(this.last);
        sstable.saveSummary(this.iwriter.builder, this.dbuilder);
        this.iwriter = null;
        this.dbuilder = null;
        return sstable;
    }

    @Override
    public Pair<Descriptor, StatsMetadata> close() {
        return this.close(this.repairedAt);
    }

    private Pair<Descriptor, StatsMetadata> close(long repairedAt) {
        this.iwriter.close();
        this.dataFile.close();
        this.dataFile.writeFullChecksum(this.descriptor);
        Map<MetadataType, MetadataComponent> metadataComponents = this.metadataCollector.finalizeMetadata(this.partitioner.getClass().getCanonicalName(), this.metadata.getBloomFilterFpChance(), repairedAt);
        BigTableWriter.writeMetadata(this.descriptor, metadataComponents);
        SSTable.appendTOC(this.descriptor, this.components);
        return Pair.create(SSTableWriter.rename(this.descriptor, this.components), (StatsMetadata)metadataComponents.get((Object)MetadataType.STATS));
    }

    private static void writeMetadata(Descriptor desc, Map<MetadataType, MetadataComponent> components) {
        try (SequentialWriter out = SequentialWriter.open(new File(desc.filenameFor(Component.STATS)));){
            desc.getMetadataSerializer().serialize(components, out.stream);
        }
    }

    @Override
    public long getFilePointer() {
        return this.dataFile.getFilePointer();
    }

    @Override
    public long getOnDiskFilePointer() {
        return this.dataFile.getOnDiskFilePointer();
    }

    class IndexWriter
    implements Closeable {
        private final SequentialWriter indexFile;
        public final SegmentedFile.Builder builder;
        public final IndexSummaryBuilder summary;
        public final IFilter bf;
        private FileMark mark;

        IndexWriter(long keyCount) {
            this.indexFile = SequentialWriter.open(new File(BigTableWriter.this.descriptor.filenameFor(Component.PRIMARY_INDEX)));
            this.builder = SegmentedFile.getBuilder(DatabaseDescriptor.getIndexAccessMode());
            this.summary = new IndexSummaryBuilder(keyCount, BigTableWriter.this.metadata.getMinIndexInterval(), 128);
            this.bf = FilterFactory.getFilter(keyCount, BigTableWriter.this.metadata.getBloomFilterFpChance(), true);
        }

        DecoratedKey getMaxReadableKey(int offset) {
            long maxIndexLength = this.indexFile.getLastFlushOffset();
            return this.summary.getMaxReadableKey(maxIndexLength, offset);
        }

        public void append(DecoratedKey key, RowIndexEntry indexEntry) {
            this.bf.add(key.getKey());
            long indexPosition = this.indexFile.getFilePointer();
            try {
                ByteBufferUtil.writeWithShortLength(key.getKey(), this.indexFile.stream);
                BigTableWriter.this.rowIndexEntrySerializer.serialize(indexEntry, this.indexFile.stream);
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.indexFile.getPath());
            }
            if (logger.isTraceEnabled()) {
                logger.trace("wrote index entry: {} at {}", (Object)indexEntry, (Object)indexPosition);
            }
            this.summary.maybeAddEntry(key, indexPosition);
            this.builder.addPotentialBoundary(indexPosition);
        }

        @Override
        public void close() {
            if (BigTableWriter.this.components.contains(Component.FILTER)) {
                String path = BigTableWriter.this.descriptor.filenameFor(Component.FILTER);
                try {
                    FileOutputStream fos = new FileOutputStream(path);
                    DataOutputStreamAndChannel stream = new DataOutputStreamAndChannel(fos);
                    FilterFactory.serialize(this.bf, stream);
                    stream.flush();
                    fos.getFD().sync();
                    stream.close();
                }
                catch (IOException e) {
                    throw new FSWriteError((Throwable)e, path);
                }
            }
            long position = this.indexFile.getFilePointer();
            this.indexFile.close();
            FileUtils.truncate(this.indexFile.getPath(), position);
        }

        public void mark() {
            this.mark = this.indexFile.mark();
        }

        public void resetAndTruncate() {
            this.indexFile.resetAndTruncate(this.mark);
        }
    }
}

