/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.util.RatioGauge;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.metrics.LatencyMetrics;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.EstimatedHistogram;

public class ColumnFamilyMetrics {
    public final Gauge<Long> memtableOnHeapSize;
    public final Gauge<Long> memtableOffHeapSize;
    public final Gauge<Long> memtableLiveDataSize;
    public final Gauge<Long> allMemtablesOnHeapSize;
    public final Gauge<Long> allMemtablesOffHeapSize;
    public final Gauge<Long> allMemtablesLiveDataSize;
    public final Gauge<Long> memtableColumnsCount;
    public final Counter memtableSwitchCount;
    public final Gauge<Double> compressionRatio;
    public final Gauge<long[]> estimatedRowSizeHistogram;
    public final Gauge<long[]> estimatedColumnCountHistogram;
    public final ColumnFamilyHistogram sstablesPerReadHistogram;
    public final LatencyMetrics readLatency;
    public final LatencyMetrics rangeLatency;
    public final LatencyMetrics writeLatency;
    public final Counter pendingFlushes;
    public final Gauge<Integer> pendingCompactions;
    public final Gauge<Integer> liveSSTableCount;
    public final Counter liveDiskSpaceUsed;
    public final Counter totalDiskSpaceUsed;
    public final Gauge<Long> minRowSize;
    public final Gauge<Long> maxRowSize;
    public final Gauge<Long> meanRowSize;
    public final Gauge<Long> bloomFilterFalsePositives;
    public final Gauge<Long> recentBloomFilterFalsePositives;
    public final Gauge<Double> bloomFilterFalseRatio;
    public final Gauge<Double> recentBloomFilterFalseRatio;
    public final Gauge<Long> bloomFilterDiskSpaceUsed;
    public final Gauge<Double> keyCacheHitRate;
    public final ColumnFamilyHistogram tombstoneScannedHistogram;
    public final ColumnFamilyHistogram liveScannedHistogram;
    public final Gauge<Long> trueSnapshotsSize;
    public final Counter rowCacheHitOutOfRange;
    public final Counter rowCacheHit;
    public final Counter rowCacheMiss;
    public final LatencyMetrics casPrepare;
    public final LatencyMetrics casPropose;
    public final LatencyMetrics casCommit;
    public final Timer coordinatorReadLatency;
    public final Timer coordinatorScanLatency;
    public final Timer waitingOnFreeMemtableSpace;
    private final MetricNameFactory factory;
    private static final MetricNameFactory globalNameFactory = new AllColumnFamilyMetricNameFactory();
    public final Counter speculativeRetries;
    @Deprecated
    public final EstimatedHistogram sstablesPerRead = new EstimatedHistogram(35);
    @Deprecated
    public final EstimatedHistogram recentSSTablesPerRead = new EstimatedHistogram(35);
    public static final LatencyMetrics globalReadLatency = new LatencyMetrics(globalNameFactory, "Read");
    public static final LatencyMetrics globalWriteLatency = new LatencyMetrics(globalNameFactory, "Write");
    public static final LatencyMetrics globalRangeLatency = new LatencyMetrics(globalNameFactory, "Range");
    public static final ConcurrentMap<String, Set<Metric>> allColumnFamilyMetrics = Maps.newConcurrentMap();
    public static final Set<String> all = Sets.newHashSet();

    public ColumnFamilyMetrics(final ColumnFamilyStore cfs) {
        this.factory = new ColumnFamilyMetricNameFactory(cfs);
        this.memtableColumnsCount = this.createColumnFamilyGauge("MemtableColumnsCount", new Gauge<Long>(){

            public Long value() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getOperations();
            }
        });
        this.memtableOnHeapSize = this.createColumnFamilyGauge("MemtableOnHeapSize", new Gauge<Long>(){

            public Long value() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getAllocator().onHeap().owns();
            }
        });
        this.memtableOffHeapSize = this.createColumnFamilyGauge("MemtableOffHeapSize", new Gauge<Long>(){

            public Long value() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getAllocator().offHeap().owns();
            }
        });
        this.memtableLiveDataSize = this.createColumnFamilyGauge("MemtableLiveDataSize", new Gauge<Long>(){

            public Long value() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getLiveDataSize();
            }
        });
        this.allMemtablesOnHeapSize = this.createColumnFamilyGauge("AllMemtablesHeapSize", new Gauge<Long>(){

            public Long value() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getDataTracker().getView().getCurrentMemtable().getAllocator().onHeap().owns();
                }
                return size;
            }
        });
        this.allMemtablesOffHeapSize = this.createColumnFamilyGauge("AllMemtablesOffHeapSize", new Gauge<Long>(){

            public Long value() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getDataTracker().getView().getCurrentMemtable().getAllocator().offHeap().owns();
                }
                return size;
            }
        });
        this.allMemtablesLiveDataSize = this.createColumnFamilyGauge("AllMemtablesLiveDataSize", new Gauge<Long>(){

            public Long value() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getDataTracker().getView().getCurrentMemtable().getLiveDataSize();
                }
                return size;
            }
        });
        this.memtableSwitchCount = this.createColumnFamilyCounter("MemtableSwitchCount");
        this.estimatedRowSizeHistogram = Metrics.newGauge((MetricName)this.factory.createMetricName("EstimatedRowSizeHistogram"), (Gauge)new Gauge<long[]>(){

            public long[] value() {
                long[] histogram = new long[90];
                for (SSTableReader sstable : cfs.getSSTables()) {
                    long[] rowSize = sstable.getEstimatedRowSize().getBuckets(false);
                    for (int i = 0; i < histogram.length; ++i) {
                        int n = i;
                        histogram[n] = histogram[n] + rowSize[i];
                    }
                }
                return histogram;
            }
        });
        this.estimatedColumnCountHistogram = Metrics.newGauge((MetricName)this.factory.createMetricName("EstimatedColumnCountHistogram"), (Gauge)new Gauge<long[]>(){

            public long[] value() {
                long[] histogram = new long[90];
                for (SSTableReader sstable : cfs.getSSTables()) {
                    long[] columnSize = sstable.getEstimatedColumnCount().getBuckets(false);
                    for (int i = 0; i < histogram.length; ++i) {
                        int n = i;
                        histogram[n] = histogram[n] + columnSize[i];
                    }
                }
                return histogram;
            }
        });
        this.sstablesPerReadHistogram = this.createColumnFamilyHistogram("SSTablesPerReadHistogram", cfs.keyspace.metric.sstablesPerReadHistogram);
        this.compressionRatio = this.createColumnFamilyGauge("CompressionRatio", new Gauge<Double>(){

            public Double value() {
                double sum = 0.0;
                int total = 0;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    if (sstable.getCompressionRatio() == -1.0) continue;
                    sum += sstable.getCompressionRatio();
                    ++total;
                }
                return total != 0 ? sum / (double)total : 0.0;
            }
        }, new Gauge<Double>(){

            public Double value() {
                double sum = 0.0;
                int total = 0;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables()) {
                        if (sstable.getCompressionRatio() == -1.0) continue;
                        sum += sstable.getCompressionRatio();
                        ++total;
                    }
                }
                return total != 0 ? sum / (double)total : 0.0;
            }
        });
        this.readLatency = new LatencyMetrics(this.factory, "Read", cfs.keyspace.metric.readLatency, globalReadLatency);
        this.writeLatency = new LatencyMetrics(this.factory, "Write", cfs.keyspace.metric.writeLatency, globalWriteLatency);
        this.rangeLatency = new LatencyMetrics(this.factory, "Range", cfs.keyspace.metric.rangeLatency, globalRangeLatency);
        this.pendingFlushes = this.createColumnFamilyCounter("PendingFlushes");
        this.pendingCompactions = this.createColumnFamilyGauge("PendingCompactions", new Gauge<Integer>(){

            public Integer value() {
                return cfs.getCompactionStrategy().getEstimatedRemainingTasks();
            }
        });
        this.liveSSTableCount = this.createColumnFamilyGauge("LiveSSTableCount", new Gauge<Integer>(){

            public Integer value() {
                return cfs.getDataTracker().getSSTables().size();
            }
        });
        this.liveDiskSpaceUsed = this.createColumnFamilyCounter("LiveDiskSpaceUsed");
        this.totalDiskSpaceUsed = this.createColumnFamilyCounter("TotalDiskSpaceUsed");
        this.minRowSize = this.createColumnFamilyGauge("MinRowSize", new Gauge<Long>(){

            public Long value() {
                long min = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    if (min != 0L && sstable.getEstimatedRowSize().min() >= min) continue;
                    min = sstable.getEstimatedRowSize().min();
                }
                return min;
            }
        }, new Gauge<Long>(){

            public Long value() {
                long min = Long.MAX_VALUE;
                for (Metric cfGauge : (Set)allColumnFamilyMetrics.get("MinRowSize")) {
                    min = Math.min(min, ((Number)((Gauge)cfGauge).value()).longValue());
                }
                return min;
            }
        });
        this.maxRowSize = this.createColumnFamilyGauge("MaxRowSize", new Gauge<Long>(){

            public Long value() {
                long max = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    if (sstable.getEstimatedRowSize().max() <= max) continue;
                    max = sstable.getEstimatedRowSize().max();
                }
                return max;
            }
        }, new Gauge<Long>(){

            public Long value() {
                long max = 0L;
                for (Metric cfGauge : (Set)allColumnFamilyMetrics.get("MaxRowSize")) {
                    max = Math.max(max, ((Number)((Gauge)cfGauge).value()).longValue());
                }
                return max;
            }
        });
        this.meanRowSize = this.createColumnFamilyGauge("MeanRowSize", new Gauge<Long>(){

            public Long value() {
                long sum = 0L;
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    long n = sstable.getEstimatedRowSize().count();
                    sum += sstable.getEstimatedRowSize().mean() * n;
                    count += n;
                }
                return count > 0L ? sum / count : 0L;
            }
        }, new Gauge<Long>(){

            public Long value() {
                long sum = 0L;
                long count = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables()) {
                        long n = sstable.getEstimatedRowSize().count();
                        sum += sstable.getEstimatedRowSize().mean() * n;
                        count += n;
                    }
                }
                return count > 0L ? sum / count : 0L;
            }
        });
        this.bloomFilterFalsePositives = this.createColumnFamilyGauge("BloomFilterFalsePositives", new Gauge<Long>(){

            public Long value() {
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    count += sstable.getBloomFilterFalsePositiveCount();
                }
                return count;
            }
        });
        this.recentBloomFilterFalsePositives = this.createColumnFamilyGauge("RecentBloomFilterFalsePositives", new Gauge<Long>(){

            public Long value() {
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    count += sstable.getRecentBloomFilterFalsePositiveCount();
                }
                return count;
            }
        });
        this.bloomFilterFalseRatio = this.createColumnFamilyGauge("BloomFilterFalseRatio", new Gauge<Double>(){

            public Double value() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    falseCount += sstable.getBloomFilterFalsePositiveCount();
                    trueCount += sstable.getBloomFilterTruePositiveCount();
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        }, new Gauge<Double>(){

            public Double value() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables()) {
                        falseCount += sstable.getBloomFilterFalsePositiveCount();
                        trueCount += sstable.getBloomFilterTruePositiveCount();
                    }
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        });
        this.recentBloomFilterFalseRatio = this.createColumnFamilyGauge("RecentBloomFilterFalseRatio", new Gauge<Double>(){

            public Double value() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    falseCount += sstable.getRecentBloomFilterFalsePositiveCount();
                    trueCount += sstable.getRecentBloomFilterTruePositiveCount();
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        }, new Gauge<Double>(){

            public Double value() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables()) {
                        falseCount += sstable.getRecentBloomFilterFalsePositiveCount();
                        trueCount += sstable.getRecentBloomFilterTruePositiveCount();
                    }
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        });
        this.bloomFilterDiskSpaceUsed = this.createColumnFamilyGauge("BloomFilterDiskSpaceUsed", new Gauge<Long>(){

            public Long value() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables()) {
                    total += sst.getBloomFilterSerializedSize();
                }
                return total;
            }
        });
        this.speculativeRetries = this.createColumnFamilyCounter("SpeculativeRetries");
        this.keyCacheHitRate = Metrics.newGauge((MetricName)this.factory.createMetricName("KeyCacheHitRate"), (Gauge)new RatioGauge(){

            protected double getNumerator() {
                long hits = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    hits += sstable.getKeyCacheHit();
                }
                return hits;
            }

            protected double getDenominator() {
                long requests = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    requests += sstable.getKeyCacheRequest();
                }
                return Math.max(requests, 1L);
            }
        });
        this.tombstoneScannedHistogram = this.createColumnFamilyHistogram("TombstoneScannedHistogram", cfs.keyspace.metric.tombstoneScannedHistogram);
        this.liveScannedHistogram = this.createColumnFamilyHistogram("LiveScannedHistogram", cfs.keyspace.metric.liveScannedHistogram);
        this.coordinatorReadLatency = Metrics.newTimer((MetricName)this.factory.createMetricName("CoordinatorReadLatency"), (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.coordinatorScanLatency = Metrics.newTimer((MetricName)this.factory.createMetricName("CoordinatorScanLatency"), (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.waitingOnFreeMemtableSpace = Metrics.newTimer((MetricName)this.factory.createMetricName("WaitingOnFreeMemtableSpace"), (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.trueSnapshotsSize = this.createColumnFamilyGauge("SnapshotsSize", new Gauge<Long>(){

            public Long value() {
                return cfs.trueSnapshotsSize();
            }
        });
        this.rowCacheHitOutOfRange = this.createColumnFamilyCounter("RowCacheHitOutOfRange");
        this.rowCacheHit = this.createColumnFamilyCounter("RowCacheHit");
        this.rowCacheMiss = this.createColumnFamilyCounter("RowCacheMiss");
        this.casPrepare = new LatencyMetrics(this.factory, "CasPrepare", cfs.keyspace.metric.casPrepare);
        this.casPropose = new LatencyMetrics(this.factory, "CasPropose", cfs.keyspace.metric.casPropose);
        this.casCommit = new LatencyMetrics(this.factory, "CasCommit", cfs.keyspace.metric.casCommit);
    }

    public void updateSSTableIterated(int count) {
        this.sstablesPerReadHistogram.update(count);
        this.recentSSTablesPerRead.add(count);
        this.sstablesPerRead.add(count);
    }

    public void release() {
        for (String name : all) {
            ((Set)allColumnFamilyMetrics.get(name)).remove(Metrics.defaultRegistry().allMetrics().get(this.factory.createMetricName(name)));
            Metrics.defaultRegistry().removeMetric(this.factory.createMetricName(name));
        }
        this.readLatency.release();
        this.writeLatency.release();
        this.rangeLatency.release();
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("EstimatedRowSizeHistogram"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("EstimatedColumnCountHistogram"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("KeyCacheHitRate"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CoordinatorReadLatency"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CoordinatorScanLatency"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("WaitingOnFreeMemtableSpace"));
    }

    protected <T extends Number> Gauge<T> createColumnFamilyGauge(final String name, Gauge<T> gauge) {
        return this.createColumnFamilyGauge(name, gauge, new Gauge<Long>(){

            public Long value() {
                long total = 0L;
                for (Metric cfGauge : (Set)allColumnFamilyMetrics.get(name)) {
                    total += ((Number)((Gauge)cfGauge).value()).longValue();
                }
                return total;
            }
        });
    }

    protected <G, T> Gauge<T> createColumnFamilyGauge(String name, Gauge<T> gauge, Gauge<G> globalGauge) {
        Gauge cfGauge = Metrics.newGauge((MetricName)this.factory.createMetricName(name), gauge);
        if (this.register(name, (Metric)cfGauge)) {
            Metrics.newGauge((MetricName)globalNameFactory.createMetricName(name), globalGauge);
        }
        return cfGauge;
    }

    protected Counter createColumnFamilyCounter(final String name) {
        Counter cfCounter = Metrics.newCounter((MetricName)this.factory.createMetricName(name));
        if (this.register(name, (Metric)cfCounter)) {
            Metrics.newGauge((MetricName)globalNameFactory.createMetricName(name), (Gauge)new Gauge<Long>(){

                public Long value() {
                    long total = 0L;
                    for (Metric cfGauge : (Set)allColumnFamilyMetrics.get(name)) {
                        total += ((Counter)cfGauge).count();
                    }
                    return total;
                }
            });
        }
        return cfCounter;
    }

    protected ColumnFamilyHistogram createColumnFamilyHistogram(String name, Histogram keyspaceHistogram) {
        Histogram cfHistogram = Metrics.newHistogram((MetricName)this.factory.createMetricName(name), (boolean)true);
        this.register(name, (Metric)cfHistogram);
        return new ColumnFamilyHistogram(cfHistogram, keyspaceHistogram, Metrics.newHistogram((MetricName)globalNameFactory.createMetricName(name), (boolean)true));
    }

    private boolean register(String name, Metric metric) {
        boolean ret = allColumnFamilyMetrics.putIfAbsent(name, new HashSet()) == null;
        ((Set)allColumnFamilyMetrics.get(name)).add(metric);
        all.add(name);
        return ret;
    }

    static class AllColumnFamilyMetricNameFactory
    implements MetricNameFactory {
        AllColumnFamilyMetricNameFactory() {
        }

        @Override
        public MetricName createMetricName(String metricName) {
            String groupName = ColumnFamilyMetrics.class.getPackage().getName();
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=ColumnFamily");
            mbeanName.append(",name=").append(metricName);
            return new MetricName(groupName, "ColumnFamily", metricName, "all", mbeanName.toString());
        }
    }

    class ColumnFamilyMetricNameFactory
    implements MetricNameFactory {
        private final String keyspaceName;
        private final String columnFamilyName;
        private final boolean isIndex;

        ColumnFamilyMetricNameFactory(ColumnFamilyStore cfs) {
            this.keyspaceName = cfs.keyspace.getName();
            this.columnFamilyName = cfs.name;
            this.isIndex = cfs.isIndex();
        }

        @Override
        public MetricName createMetricName(String metricName) {
            String groupName = ColumnFamilyMetrics.class.getPackage().getName();
            String type = this.isIndex ? "IndexColumnFamily" : "ColumnFamily";
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=").append(type);
            mbeanName.append(",keyspace=").append(this.keyspaceName);
            mbeanName.append(",scope=").append(this.columnFamilyName);
            mbeanName.append(",name=").append(metricName);
            return new MetricName(groupName, type, metricName, this.keyspaceName + "." + this.columnFamilyName, mbeanName.toString());
        }
    }

    public class ColumnFamilyHistogram {
        public final Histogram[] all;
        public final Histogram cf;

        private ColumnFamilyHistogram(Histogram cf, Histogram keyspace, Histogram global) {
            this.cf = cf;
            this.all = new Histogram[]{cf, keyspace, global};
        }

        public void update(long i) {
            for (Histogram histo : this.all) {
                histo.update(i);
            }
        }
    }
}

