/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.net.InetAddress;
import java.util.List;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SyncTask;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSyncTask
extends SyncTask
implements StreamEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(LocalSyncTask.class);
    private final long repairedAt;

    public LocalSyncTask(RepairJobDesc desc, TreeResponse r1, TreeResponse r2, long repairedAt) {
        super(desc, r1, r2);
        this.repairedAt = repairedAt;
    }

    @Override
    protected void startSync(List<Range<Token>> differences) {
        InetAddress local = FBUtilities.getBroadcastAddress();
        InetAddress dst = this.r2.endpoint.equals(local) ? this.r1.endpoint : this.r2.endpoint;
        InetAddress preferred = SystemKeyspace.getPreferredIP(dst);
        logger.info(String.format("[repair #%s] Performing streaming repair of %d ranges with %s", this.desc.sessionId, differences.size(), dst));
        new StreamPlan("Repair", this.repairedAt, 1, false).listeners(this, new StreamEventHandler[0]).flushBeforeTransfer(true).requestRanges(dst, preferred, this.desc.keyspace, differences, this.desc.columnFamily).transferRanges(dst, preferred, this.desc.keyspace, differences, this.desc.columnFamily).execute();
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
    }

    public void onSuccess(StreamState result) {
        logger.info(String.format("[repair #%s] Sync complete between %s and %s on %s", this.desc.sessionId, this.r1.endpoint, this.r2.endpoint, this.desc.columnFamily));
        this.set(this.stat);
    }

    public void onFailure(Throwable t) {
        this.setException(t);
    }
}

