/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.repair.NodePair;
import org.apache.cassandra.repair.RemoteSyncTask;
import org.apache.cassandra.repair.RepairJob;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RepairResult;
import org.apache.cassandra.repair.ValidationTask;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTree;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairSession
extends AbstractFuture<List<RepairResult>>
implements IEndpointStateChangeSubscriber,
IFailureDetectionEventListener {
    private static Logger logger = LoggerFactory.getLogger(RepairSession.class);
    public final UUID parentRepairSession;
    private final UUID id;
    public final String keyspace;
    private final String[] cfnames;
    public final boolean isSequential;
    public final Range<Token> range;
    public final Set<InetAddress> endpoints;
    private final long repairedAt;
    private final AtomicBoolean isFailed = new AtomicBoolean(false);
    private final ConcurrentMap<Pair<RepairJobDesc, InetAddress>, ValidationTask> validating = new ConcurrentHashMap<Pair<RepairJobDesc, InetAddress>, ValidationTask>();
    private final ConcurrentMap<Pair<RepairJobDesc, NodePair>, RemoteSyncTask> syncingTasks = new ConcurrentHashMap<Pair<RepairJobDesc, NodePair>, RemoteSyncTask>();
    private final ListeningExecutorService taskExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new NamedThreadFactory("RepairJobTask")));
    private volatile boolean terminated = false;

    public RepairSession(UUID parentRepairSession, UUID id, Range<Token> range, String keyspace, boolean isSequential, Set<InetAddress> endpoints, long repairedAt, String ... cfnames) {
        assert (cfnames.length > 0) : "Repairing no column families seems pointless, doesn't it";
        this.parentRepairSession = parentRepairSession;
        this.id = id;
        this.isSequential = isSequential;
        this.keyspace = keyspace;
        this.cfnames = cfnames;
        this.range = range;
        this.endpoints = endpoints;
        this.repairedAt = repairedAt;
    }

    public UUID getId() {
        return this.id;
    }

    public Range<Token> getRange() {
        return this.range;
    }

    public void waitForValidation(Pair<RepairJobDesc, InetAddress> key, ValidationTask task) {
        this.validating.put(key, task);
    }

    public void waitForSync(Pair<RepairJobDesc, NodePair> key, RemoteSyncTask task) {
        this.syncingTasks.put(key, task);
    }

    public void validationComplete(RepairJobDesc desc, InetAddress endpoint, MerkleTree tree) {
        ValidationTask task = (ValidationTask)this.validating.remove(Pair.create(desc, endpoint));
        if (task == null) {
            assert (this.terminated);
            return;
        }
        logger.info(String.format("[repair #%s] Received merkle tree for %s from %s", this.getId(), desc.columnFamily, endpoint));
        task.treeReceived(tree);
    }

    public void syncComplete(RepairJobDesc desc, NodePair nodes, boolean success) {
        RemoteSyncTask task = (RemoteSyncTask)this.syncingTasks.get(Pair.create(desc, nodes));
        if (task == null) {
            assert (this.terminated);
            return;
        }
        logger.debug(String.format("[repair #%s] Repair completed between %s and %s on %s", this.getId(), nodes.endpoint1, nodes.endpoint2, desc.columnFamily));
        task.syncComplete(success);
    }

    private String repairedNodes() {
        StringBuilder sb = new StringBuilder();
        sb.append(FBUtilities.getBroadcastAddress());
        for (InetAddress ep : this.endpoints) {
            sb.append(", ").append(ep);
        }
        return sb.toString();
    }

    public void start(ListeningExecutorService executor) {
        if (this.terminated) {
            return;
        }
        logger.info(String.format("[repair #%s] new session: will sync %s on range %s for %s.%s", this.getId(), this.repairedNodes(), this.range, this.keyspace, Arrays.toString(this.cfnames)));
        if (this.endpoints.isEmpty()) {
            logger.info(String.format("[repair #%s] No neighbors to repair with on range %s: session completed", this.getId(), this.range));
            this.set(Lists.newArrayList());
            return;
        }
        for (InetAddress endpoint : this.endpoints) {
            if (FailureDetector.instance.isAlive(endpoint)) continue;
            String message = String.format("Cannot proceed on repair because a neighbor (%s) is dead: session failed", endpoint);
            logger.error("[repair #{}] {}", (Object)this.getId(), (Object)message);
            this.setException(new IOException(message));
            return;
        }
        ArrayList<RepairJob> jobs = new ArrayList<RepairJob>(this.cfnames.length);
        for (String cfname : this.cfnames) {
            RepairJob job = new RepairJob(this, cfname, this.isSequential, this.repairedAt, this.taskExecutor);
            executor.execute((Runnable)job);
            jobs.add(job);
        }
        Futures.addCallback((ListenableFuture)Futures.allAsList(jobs), (FutureCallback)new FutureCallback<List<RepairResult>>(){

            public void onSuccess(List<RepairResult> results) {
                logger.info(String.format("[repair #%s] session completed successfully", RepairSession.this.getId()));
                RepairSession.this.set(results);
                RepairSession.this.taskExecutor.shutdown();
                RepairSession.this.terminate();
            }

            public void onFailure(Throwable t) {
                logger.error("Repair job failed", t);
                RepairSession.this.setException(t);
            }
        });
    }

    public void terminate() {
        this.terminated = true;
        this.validating.clear();
        this.syncingTasks.clear();
    }

    public void forceShutdown(Throwable reason) {
        this.setException(reason);
        this.taskExecutor.shutdownNow();
        this.terminate();
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
    }

    @Override
    public void beforeChange(InetAddress endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState epState) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void convict(InetAddress endpoint, double phi) {
        if (!this.endpoints.contains(endpoint)) {
            return;
        }
        if (phi < 2.0 * DatabaseDescriptor.getPhiConvictThreshold()) {
            return;
        }
        if (!this.isFailed.compareAndSet(false, true)) {
            return;
        }
        IOException exception = new IOException(String.format("Endpoint %s died", endpoint));
        logger.error(String.format("[repair #%s] session completed with the following error", this.getId()), (Throwable)exception);
        this.forceShutdown(exception);
    }
}

