/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.streaming.DefaultConnectionFactory;
import org.apache.cassandra.streaming.StreamConnectionFactory;
import org.apache.cassandra.streaming.StreamCoordinator;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.utils.UUIDGen;

public class StreamPlan {
    private final UUID planId = UUIDGen.getTimeUUID();
    private final String description;
    private final List<StreamEventHandler> handlers = new ArrayList<StreamEventHandler>();
    private final long repairedAt;
    private final StreamCoordinator coordinator;
    private boolean flushBeforeTransfer = true;

    public StreamPlan(String description) {
        this(description, 0L, 1, false);
    }

    public StreamPlan(String description, boolean keepSSTableLevels) {
        this(description, 0L, 1, keepSSTableLevels);
    }

    public StreamPlan(String description, long repairedAt, int connectionsPerHost, boolean keepSSTableLevels) {
        this.description = description;
        this.repairedAt = repairedAt;
        this.coordinator = new StreamCoordinator(connectionsPerHost, keepSSTableLevels, new DefaultConnectionFactory());
    }

    public StreamPlan requestRanges(InetAddress from, InetAddress connecting, String keyspace, Collection<Range<Token>> ranges) {
        return this.requestRanges(from, connecting, keyspace, ranges, new String[0]);
    }

    public StreamPlan requestRanges(InetAddress from, InetAddress connecting, String keyspace, Collection<Range<Token>> ranges, String ... columnFamilies) {
        StreamSession session = this.coordinator.getOrCreateNextSession(from, connecting);
        session.addStreamRequest(keyspace, ranges, Arrays.asList(columnFamilies), this.repairedAt);
        return this;
    }

    public StreamPlan transferRanges(InetAddress to, String keyspace, Collection<Range<Token>> ranges, String ... columnFamilies) {
        return this.transferRanges(to, to, keyspace, ranges, columnFamilies);
    }

    public StreamPlan transferRanges(InetAddress to, InetAddress connecting, String keyspace, Collection<Range<Token>> ranges) {
        return this.transferRanges(to, connecting, keyspace, ranges, new String[0]);
    }

    public StreamPlan transferRanges(InetAddress to, InetAddress connecting, String keyspace, Collection<Range<Token>> ranges, String ... columnFamilies) {
        StreamSession session = this.coordinator.getOrCreateNextSession(to, connecting);
        session.addTransferRanges(keyspace, ranges, Arrays.asList(columnFamilies), this.flushBeforeTransfer, this.repairedAt);
        return this;
    }

    public StreamPlan transferFiles(InetAddress to, Collection<StreamSession.SSTableStreamingSections> sstableDetails) {
        this.coordinator.transferFiles(to, sstableDetails);
        return this;
    }

    public StreamPlan listeners(StreamEventHandler handler, StreamEventHandler ... handlers) {
        this.handlers.add(handler);
        if (handlers != null) {
            Collections.addAll(this.handlers, handlers);
        }
        return this;
    }

    public StreamPlan connectionFactory(StreamConnectionFactory factory) {
        this.coordinator.setConnectionFactory(factory);
        return this;
    }

    public boolean isEmpty() {
        return !this.coordinator.hasActiveSessions();
    }

    public StreamResultFuture execute() {
        return StreamResultFuture.init(this.planId, this.description, this.handlers, this.coordinator);
    }

    public StreamPlan flushBeforeTransfer(boolean flushBeforeTransfer) {
        this.flushBeforeTransfer = flushBeforeTransfer;
        return this;
    }
}

