/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.cassandra.transport.CBUtil;

public abstract class Event {
    public final Type type;

    private Event(Type type) {
        this.type = type;
    }

    public static Event deserialize(ByteBuf cb, int version) {
        switch (CBUtil.readEnumValue(Type.class, cb)) {
            case TOPOLOGY_CHANGE: {
                return TopologyChange.deserializeEvent(cb, version);
            }
            case STATUS_CHANGE: {
                return StatusChange.deserializeEvent(cb, version);
            }
            case SCHEMA_CHANGE: {
                return SchemaChange.deserializeEvent(cb, version);
            }
        }
        throw new AssertionError();
    }

    public void serialize(ByteBuf dest, int version) {
        CBUtil.writeEnumValue(this.type, dest);
        this.serializeEvent(dest, version);
    }

    public int serializedSize(int version) {
        return CBUtil.sizeOfEnumValue(this.type) + this.eventSerializedSize(version);
    }

    protected abstract void serializeEvent(ByteBuf var1, int var2);

    protected abstract int eventSerializedSize(int var1);

    public static class SchemaChange
    extends Event {
        public final Change change;
        public final Target target;
        public final String keyOrNamespace;
        public final String tableOrTypeOrFunction;

        public SchemaChange(Change change, Target target, String keyOrNamespace, String tableOrTypeOrFunction) {
            super(Type.SCHEMA_CHANGE);
            this.change = change;
            this.target = target;
            this.keyOrNamespace = keyOrNamespace;
            this.tableOrTypeOrFunction = tableOrTypeOrFunction;
            if (target != Target.KEYSPACE) assert (this.tableOrTypeOrFunction != null) : "Table or type should be set for non-keyspace schema change events";
        }

        public SchemaChange(Change change, String keyspace) {
            this(change, Target.KEYSPACE, keyspace, null);
        }

        public static SchemaChange deserializeEvent(ByteBuf cb, int version) {
            Change change = CBUtil.readEnumValue(Change.class, cb);
            if (version >= 3) {
                Target target = CBUtil.readEnumValue(Target.class, cb);
                String keyspace = CBUtil.readString(cb);
                String tableOrType = target == Target.KEYSPACE ? null : CBUtil.readString(cb);
                return new SchemaChange(change, target, keyspace, tableOrType);
            }
            String keyspace = CBUtil.readString(cb);
            String table = CBUtil.readString(cb);
            return new SchemaChange(change, table.isEmpty() ? Target.KEYSPACE : Target.TABLE, keyspace, table.isEmpty() ? null : table);
        }

        @Override
        public void serializeEvent(ByteBuf dest, int version) {
            if (version >= 3) {
                CBUtil.writeEnumValue(this.change, dest);
                CBUtil.writeEnumValue(this.target, dest);
                CBUtil.writeString(this.keyOrNamespace, dest);
                if (this.target != Target.KEYSPACE) {
                    CBUtil.writeString(this.tableOrTypeOrFunction, dest);
                }
            } else if (this.target == Target.TYPE) {
                CBUtil.writeEnumValue(Change.UPDATED, dest);
                CBUtil.writeString(this.keyOrNamespace, dest);
                CBUtil.writeString("", dest);
            } else {
                CBUtil.writeEnumValue(this.change, dest);
                CBUtil.writeString(this.keyOrNamespace, dest);
                CBUtil.writeString(this.target == Target.KEYSPACE ? "" : this.tableOrTypeOrFunction, dest);
            }
        }

        @Override
        public int eventSerializedSize(int version) {
            if (version >= 3) {
                int size = CBUtil.sizeOfEnumValue(this.change) + CBUtil.sizeOfEnumValue(this.target) + CBUtil.sizeOfString(this.keyOrNamespace);
                if (this.target != Target.KEYSPACE) {
                    size += CBUtil.sizeOfString(this.tableOrTypeOrFunction);
                }
                return size;
            }
            if (this.target == Target.TYPE) {
                return CBUtil.sizeOfEnumValue(Change.UPDATED) + CBUtil.sizeOfString(this.keyOrNamespace) + CBUtil.sizeOfString("");
            }
            return CBUtil.sizeOfEnumValue(this.change) + CBUtil.sizeOfString(this.keyOrNamespace) + CBUtil.sizeOfString(this.target == Target.KEYSPACE ? "" : this.tableOrTypeOrFunction);
        }

        public String toString() {
            return (Object)((Object)this.change) + " " + (Object)((Object)this.target) + " " + this.keyOrNamespace + (this.tableOrTypeOrFunction == null ? "" : "." + this.tableOrTypeOrFunction);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.change, this.target, this.keyOrNamespace, this.tableOrTypeOrFunction});
        }

        public boolean equals(Object other) {
            if (!(other instanceof SchemaChange)) {
                return false;
            }
            SchemaChange scc = (SchemaChange)other;
            return Objects.equal((Object)((Object)this.change), (Object)((Object)scc.change)) && Objects.equal((Object)((Object)this.target), (Object)((Object)scc.target)) && Objects.equal((Object)this.keyOrNamespace, (Object)scc.keyOrNamespace) && Objects.equal((Object)this.tableOrTypeOrFunction, (Object)scc.tableOrTypeOrFunction);
        }

        public static enum Target {
            KEYSPACE,
            TABLE,
            TYPE;

        }

        public static enum Change {
            CREATED,
            UPDATED,
            DROPPED;

        }
    }

    public static class StatusChange
    extends Event {
        public final Status status;
        public final InetSocketAddress node;

        private StatusChange(Status status, InetSocketAddress node) {
            super(Type.STATUS_CHANGE);
            this.status = status;
            this.node = node;
        }

        public static StatusChange nodeUp(InetAddress host, int port) {
            return new StatusChange(Status.UP, new InetSocketAddress(host, port));
        }

        public static StatusChange nodeDown(InetAddress host, int port) {
            return new StatusChange(Status.DOWN, new InetSocketAddress(host, port));
        }

        private static StatusChange deserializeEvent(ByteBuf cb, int version) {
            Status status = CBUtil.readEnumValue(Status.class, cb);
            InetSocketAddress node = CBUtil.readInet(cb);
            return new StatusChange(status, node);
        }

        @Override
        protected void serializeEvent(ByteBuf dest, int version) {
            CBUtil.writeEnumValue(this.status, dest);
            CBUtil.writeInet(this.node, dest);
        }

        @Override
        protected int eventSerializedSize(int version) {
            return CBUtil.sizeOfEnumValue(this.status) + CBUtil.sizeOfInet(this.node);
        }

        public String toString() {
            return (Object)((Object)this.status) + " " + this.node;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.status, this.node});
        }

        public boolean equals(Object other) {
            if (!(other instanceof StatusChange)) {
                return false;
            }
            StatusChange stc = (StatusChange)other;
            return Objects.equal((Object)((Object)this.status), (Object)((Object)stc.status)) && Objects.equal((Object)this.node, (Object)stc.node);
        }

        public static enum Status {
            UP,
            DOWN;

        }
    }

    public static class TopologyChange
    extends Event {
        public final Change change;
        public final InetSocketAddress node;

        private TopologyChange(Change change, InetSocketAddress node) {
            super(Type.TOPOLOGY_CHANGE);
            this.change = change;
            this.node = node;
        }

        public static TopologyChange newNode(InetAddress host, int port) {
            return new TopologyChange(Change.NEW_NODE, new InetSocketAddress(host, port));
        }

        public static TopologyChange removedNode(InetAddress host, int port) {
            return new TopologyChange(Change.REMOVED_NODE, new InetSocketAddress(host, port));
        }

        public static TopologyChange movedNode(InetAddress host, int port) {
            return new TopologyChange(Change.MOVED_NODE, new InetSocketAddress(host, port));
        }

        private static TopologyChange deserializeEvent(ByteBuf cb, int version) {
            Change change = CBUtil.readEnumValue(Change.class, cb);
            InetSocketAddress node = CBUtil.readInet(cb);
            return new TopologyChange(change, node);
        }

        @Override
        protected void serializeEvent(ByteBuf dest, int version) {
            CBUtil.writeEnumValue(this.change, dest);
            CBUtil.writeInet(this.node, dest);
        }

        @Override
        protected int eventSerializedSize(int version) {
            return CBUtil.sizeOfEnumValue(this.change) + CBUtil.sizeOfInet(this.node);
        }

        public String toString() {
            return (Object)((Object)this.change) + " " + this.node;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.change, this.node});
        }

        public boolean equals(Object other) {
            if (!(other instanceof TopologyChange)) {
                return false;
            }
            TopologyChange tpc = (TopologyChange)other;
            return Objects.equal((Object)((Object)this.change), (Object)((Object)tpc.change)) && Objects.equal((Object)this.node, (Object)tpc.node);
        }

        public static enum Change {
            NEW_NODE,
            REMOVED_NODE,
            MOVED_NODE;

        }
    }

    public static enum Type {
        TOPOLOGY_CHANGE,
        STATUS_CHANGE,
        SCHEMA_CHANGE;

    }
}

