/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.StatementAttributes;
import com.datastax.oss.driver.api.mapper.result.MapperResultProducer;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.internal.core.util.Reflection;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnType;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.DefaultDaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public abstract class DaoMethodGenerator
implements MethodGenerator {
    protected final ExecutableElement methodElement;
    protected final TypeElement processedType;
    protected final DaoImplementationSharedCode enclosingClass;
    protected final ProcessorContext context;
    protected final Map<Name, TypeElement> typeParameters;

    public DaoMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, TypeElement processedType, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        this.methodElement = methodElement;
        this.typeParameters = typeParameters;
        this.processedType = processedType;
        this.enclosingClass = enclosingClass;
        this.context = context;
    }

    @Nullable
    protected DaoReturnType parseAndValidateReturnType(@NonNull Set<DaoReturnTypeKind> validKinds, @NonNull String annotationName) {
        DaoReturnType returnType = this.context.getCodeGeneratorFactory().getDaoReturnTypeParser().parse(this.methodElement.getReturnType(), this.typeParameters);
        if (!validKinds.contains(returnType.getKind())) {
            this.context.getMessager().error(this.methodElement, "Invalid return type: %s methods must return one of %s", annotationName, validKinds.stream().filter(k -> k != DefaultDaoReturnTypeKind.CUSTOM).map(Object::toString).collect(Collectors.joining(", ", "[", "]")));
            return null;
        }
        return returnType;
    }

    protected void maybeAddTtl(String ttl, MethodSpec.Builder methodBuilder) {
        this.maybeAddSimpleClause(ttl, Integer::parseInt, "usingTtl", "ttl", methodBuilder);
    }

    protected void maybeAddTimestamp(String timestamp, MethodSpec.Builder methodBuilder) {
        this.maybeAddSimpleClause(timestamp, Long::parseLong, "usingTimestamp", "timestamp", methodBuilder);
    }

    protected void maybeAddSimpleClause(String annotationValue, Function<String, ? extends Number> numberParser, String dslMethodName, String valueDescription, MethodSpec.Builder methodBuilder) {
        if (!annotationValue.isEmpty()) {
            if (annotationValue.startsWith(":")) {
                String bindMarkerName = annotationValue.substring(1);
                try {
                    CqlIdentifier.fromCql((String)bindMarkerName);
                }
                catch (IllegalArgumentException ignored) {
                    this.context.getMessager().warn(this.methodElement, "Invalid " + valueDescription + " value: '%s' is not a valid placeholder, the generated query will probably fail", annotationValue);
                }
                methodBuilder.addCode(".$L($T.bindMarker($S))", new Object[]{dslMethodName, QueryBuilder.class, bindMarkerName});
            } else {
                try {
                    Number bindMarkerName = numberParser.apply(annotationValue);
                }
                catch (NumberFormatException ignored) {
                    this.context.getMessager().warn(this.methodElement, "Invalid " + valueDescription + " value: '%s' is not a bind marker name and can't be parsed as a number literal either, the generated query will probably fail", annotationValue);
                }
                methodBuilder.addCode(".$L($L)", new Object[]{dslMethodName, annotationValue});
            }
        }
    }

    protected void populateBuilderWithFunction(CodeBlock.Builder builder, VariableElement functionParam) {
        if (functionParam != null) {
            builder.addStatement("boundStatementBuilder = $L.apply(boundStatementBuilder)", new Object[]{functionParam.getSimpleName().toString()});
        }
    }

    protected void populateBuilderWithStatementAttributes(CodeBlock.Builder builder, ExecutableElement methodElement) {
        StatementAttributes statementAttributes = methodElement.getAnnotation(StatementAttributes.class);
        if (statementAttributes != null) {
            builder.addStatement("boundStatementBuilder = populateBoundStatementWithStatementAttributes(boundStatementBuilder, $1S, $2S, $3S, $4L, $5L, $6S, $7S)", new Object[]{statementAttributes.executionProfileName(), statementAttributes.consistencyLevel(), statementAttributes.serialConsistencyLevel(), statementAttributes.idempotence().length == 0 ? null : Boolean.valueOf(statementAttributes.idempotence()[0]), statementAttributes.pageSize(), statementAttributes.timeout(), statementAttributes.routingKeyspace()});
        }
    }

    protected VariableElement findBoundStatementFunction(ExecutableElement methodElement) {
        if (methodElement.getParameters().size() > 0) {
            int lastParamIndex = methodElement.getParameters().size() - 1;
            VariableElement lastParam = methodElement.getParameters().get(lastParamIndex);
            TypeMirror mirror = lastParam.asType();
            if (mirror.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)mirror;
                if (this.context.getClassUtils().isSame(declaredType.asElement(), Function.class) && this.context.getClassUtils().isSame(declaredType.getTypeArguments().get(0), BoundStatementBuilder.class) && this.context.getClassUtils().isSame(declaredType.getTypeArguments().get(1), BoundStatementBuilder.class) || this.context.getClassUtils().isSame(declaredType.asElement(), UnaryOperator.class) && this.context.getClassUtils().isSame(declaredType.getTypeArguments().get(0), BoundStatementBuilder.class)) {
                    return lastParam;
                }
            }
        }
        return null;
    }

    protected boolean validateCqlNamesPresent(List<? extends VariableElement> parameters) {
        boolean valid = true;
        if (this.isFromClassFile()) {
            for (VariableElement variableElement : parameters) {
                CqlName cqlName = variableElement.getAnnotation(CqlName.class);
                if (cqlName != null) continue;
                this.context.getMessager().error(this.methodElement, "Parameter %s is declared in a compiled method and refers to a bind marker and thus must be annotated with @%s", variableElement.getSimpleName(), CqlName.class.getSimpleName());
                valid = false;
            }
        }
        return valid;
    }

    protected void warnIfCqlNamePresent(List<? extends VariableElement> parameters) {
        for (VariableElement variableElement : parameters) {
            CqlName cqlName = variableElement.getAnnotation(CqlName.class);
            if (cqlName == null) continue;
            this.context.getMessager().warn(this.methodElement, "Parameter %s does not refer to a bind marker, @%s annotation will be ignored", variableElement.getSimpleName(), CqlName.class.getSimpleName());
        }
    }

    protected boolean isFromClassFile() {
        TypeElement enclosingElement = (TypeElement)this.methodElement.getEnclosingElement();
        return Reflection.loadClass(null, (String)enclosingElement.getQualifiedName().toString()) != null;
    }

    protected Optional<MethodSpec> crudMethod(CodeBlock.Builder createStatementBlock, DaoReturnType returnType, String helperFieldName) {
        MethodSpec.Builder method = GeneratedCodePatterns.override(this.methodElement, this.typeParameters);
        if (returnType.getKind() == DefaultDaoReturnTypeKind.CUSTOM) {
            method.addStatement("$T producer = context.getResultProducer($L)", new Object[]{MapperResultProducer.class, this.enclosingClass.addGenericTypeConstant(GeneratedCodePatterns.getTypeName(this.methodElement.getReturnType(), this.typeParameters))});
        }
        returnType.getKind().addExecuteStatement(createStatementBlock, helperFieldName, this.methodElement, this.typeParameters);
        method.addCode(returnType.getKind().wrapWithErrorHandling(createStatementBlock.build(), this.methodElement, this.typeParameters));
        return Optional.of(method.build());
    }

    protected TypeElement getEntityClassFromAnnotation(Class<?> annotation) {
        AnnotationMirror annotationMirror = null;
        for (AnnotationMirror annotationMirror2 : this.methodElement.getAnnotationMirrors()) {
            if (!this.context.getClassUtils().isSame(annotationMirror2.getAnnotationType(), annotation)) continue;
            annotationMirror = annotationMirror2;
            break;
        }
        assert (annotationMirror != null);
        for (Map.Entry entry : annotationMirror.getElementValues().entrySet()) {
            if (!((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("entityClass")) continue;
            List values = (List)((AnnotationValue)entry.getValue()).getValue();
            if (values.isEmpty()) {
                return null;
            }
            TypeMirror mirror = (TypeMirror)((AnnotationValue)values.get(0)).getValue();
            TypeElement element = EntityUtils.asEntityElement(mirror, this.typeParameters);
            if (values.size() > 1) {
                this.context.getMessager().warn(this.methodElement, "Too many entity classes: %s must have at most one 'entityClass' argument (will use the first one: %s)", annotation.getSimpleName(), mirror);
            }
            return element;
        }
        return null;
    }
}

