/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.access.TransactionDelegate;

class ExternalTransaction
extends Transaction {
    ExternalTransaction() {
    }

    ExternalTransaction(TransactionDelegate delegate) {
        this.setDelegate(delegate);
    }

    public synchronized void begin() {
        if (this.status != 6) {
            throw new IllegalStateException("Transaction must have 'STATUS_NO_TRANSACTION' to begin. Current status: " + Transaction.decodeStatus(this.status));
        }
        this.status = 1;
    }

    public boolean addConnection(String name, Connection connection) throws SQLException {
        if (super.addConnection(name, connection)) {
            if (this.status == 6) {
                this.begin();
            }
            if (this.status != 1) {
                throw new IllegalStateException("Transaction must have 'STATUS_ACTIVE' to add a connection. Current status: " + Transaction.decodeStatus(this.status));
            }
            this.fixConnectionState(connection);
            return true;
        }
        return false;
    }

    public void commit() throws IllegalStateException, SQLException, CayenneException {
        if (this.status == 6) {
            return;
        }
        if (this.delegate != null && !this.delegate.willCommit(this)) {
            return;
        }
        if (this.status != 1) {
            throw new IllegalStateException("Transaction must have 'STATUS_ACTIVE' to be committed. Current status: " + Transaction.decodeStatus(this.status));
        }
        this.processCommit();
        this.status = 3;
        if (this.delegate != null) {
            this.delegate.didCommit(this);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SQLException, CayenneException {
        try {
            if (this.status == 6 || this.status == 4 || this.status == 5) {
                return;
            }
            if (this.delegate != null && !this.delegate.willRollback(this)) {
                return;
            }
            if (this.status != 1 && this.status != 7) {
                throw new IllegalStateException("Transaction must have 'STATUS_ACTIVE' or 'STATUS_MARKED_ROLLEDBACK' to be rolled back. Current status: " + Transaction.decodeStatus(this.status));
            }
            this.processRollback();
            this.status = 4;
            if (this.delegate != null) {
                this.delegate.didRollback(this);
            }
        }
        finally {
            this.close();
        }
    }

    void fixConnectionState(Connection connection) throws SQLException {
    }

    void processCommit() throws SQLException, CayenneException {
        this.jdbcEventLogger.logCommitTransaction("no commit - transaction controlled externally.");
    }

    void processRollback() throws SQLException, CayenneException {
        this.jdbcEventLogger.logRollbackTransaction("no rollback - transaction controlled externally.");
    }

    void close() {
        if (this.connections == null || this.connections.isEmpty()) {
            return;
        }
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            try {
                ((Connection)it.next()).close();
            }
            catch (Throwable throwable) {}
        }
    }
}

