/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import org.apache.cayenne.DataChannel;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DefaultObjectMapRetainStrategy;
import org.apache.cayenne.access.ObjectMapRetainStrategy;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategy;
import org.apache.cayenne.access.dbsync.SkipSchemaUpdateStrategy;
import org.apache.cayenne.access.jdbc.BatchQueryBuilderFactory;
import org.apache.cayenne.access.jdbc.DefaultBatchQueryBuilderFactory;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.cache.MapQueryCacheProvider;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.AdhocObjectFactory;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DefaultAdhocObjectFactory;
import org.apache.cayenne.configuration.DefaultConfigurationNameMapper;
import org.apache.cayenne.configuration.DefaultDataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DefaultObjectStoreFactory;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.configuration.ObjectStoreFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.configuration.XMLDataMapLoader;
import org.apache.cayenne.configuration.server.DataContextFactory;
import org.apache.cayenne.configuration.server.DataDomainProvider;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.configuration.server.DefaultDbAdapterFactory;
import org.apache.cayenne.configuration.server.DelegatingDataSourceFactory;
import org.apache.cayenne.configuration.server.DomainDataChannelProvider;
import org.apache.cayenne.dba.db2.DB2Sniffer;
import org.apache.cayenne.dba.derby.DerbySniffer;
import org.apache.cayenne.dba.frontbase.FrontBaseSniffer;
import org.apache.cayenne.dba.h2.H2Sniffer;
import org.apache.cayenne.dba.hsqldb.HSQLDBSniffer;
import org.apache.cayenne.dba.ingres.IngresSniffer;
import org.apache.cayenne.dba.mysql.MySQLSniffer;
import org.apache.cayenne.dba.openbase.OpenBaseSniffer;
import org.apache.cayenne.dba.oracle.OracleSniffer;
import org.apache.cayenne.dba.postgres.PostgresSniffer;
import org.apache.cayenne.dba.sqlite.SQLiteSniffer;
import org.apache.cayenne.dba.sqlserver.SQLServerSniffer;
import org.apache.cayenne.dba.sybase.SybaseSniffer;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.log.CommonsJdbcEventLogger;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.resource.ClassLoaderResourceLocator;
import org.apache.cayenne.resource.ResourceLocator;

public class ServerModule
implements Module {
    protected String[] configurationLocations;

    public ServerModule(String ... configurationLocations) {
        if (configurationLocations == null) {
            throw new NullPointerException("Null configurationLocations");
        }
        if (configurationLocations.length < 1) {
            throw new IllegalArgumentException("Empty configurationLocations");
        }
        this.configurationLocations = configurationLocations;
    }

    public void configure(Binder binder) {
        binder.bindMap("org.apache.cayenne.configuration.DefaultRuntimeProperties.properties");
        binder.bind(JdbcEventLogger.class).to(CommonsJdbcEventLogger.class);
        binder.bindList("org.apache.cayenne.configuration.server.DefaultDbAdapterFactory.detectors").add(new OpenBaseSniffer()).add((OpenBaseSniffer)((Object)new FrontBaseSniffer())).add((OpenBaseSniffer)((Object)new IngresSniffer())).add((OpenBaseSniffer)((Object)new SQLiteSniffer())).add((OpenBaseSniffer)((Object)new DB2Sniffer())).add((OpenBaseSniffer)((Object)new H2Sniffer())).add((OpenBaseSniffer)((Object)new HSQLDBSniffer())).add((OpenBaseSniffer)((Object)new SybaseSniffer())).add((OpenBaseSniffer)((Object)new DerbySniffer())).add((OpenBaseSniffer)((Object)new SQLServerSniffer())).add((OpenBaseSniffer)((Object)new OracleSniffer())).add((OpenBaseSniffer)((Object)new PostgresSniffer())).add((OpenBaseSniffer)((Object)new MySQLSniffer()));
        binder.bindList("org.apache.cayenne.configuration.server.DataDomainProvider.filters");
        ListBuilder<String> locationsListBuilder = binder.bindList("org.apache.cayenne.configuration.server.DataDomainProvider.locations");
        for (String location : this.configurationLocations) {
            locationsListBuilder.add(location);
        }
        binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
        binder.bind(ConfigurationNameMapper.class).to(DefaultConfigurationNameMapper.class);
        binder.bind(EventManager.class).to(DefaultEventManager.class);
        binder.bind(QueryCache.class).toProvider(MapQueryCacheProvider.class);
        binder.bind(DataDomain.class).toProvider(DataDomainProvider.class);
        binder.bind(DataChannel.class).toProvider(DomainDataChannelProvider.class);
        binder.bind(ObjectContextFactory.class).to(DataContextFactory.class);
        binder.bind(DataChannelDescriptorLoader.class).to(XMLDataChannelDescriptorLoader.class);
        binder.bind(DataChannelDescriptorMerger.class).to(DefaultDataChannelDescriptorMerger.class);
        binder.bind(DataMapLoader.class).to(XMLDataMapLoader.class);
        binder.bind(ResourceLocator.class).to(ClassLoaderResourceLocator.class);
        binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
        binder.bind(DataSourceFactory.class).to(DelegatingDataSourceFactory.class);
        binder.bind(SchemaUpdateStrategy.class).to(SkipSchemaUpdateStrategy.class);
        binder.bind(DbAdapterFactory.class).to(DefaultDbAdapterFactory.class);
        binder.bind(EntitySorter.class).to(AshwoodEntitySorter.class).withoutScope();
        binder.bind(BatchQueryBuilderFactory.class).to(DefaultBatchQueryBuilderFactory.class);
        binder.bind(ObjectMapRetainStrategy.class).to(DefaultObjectMapRetainStrategy.class);
        binder.bind(ObjectStoreFactory.class).to(DefaultObjectStoreFactory.class);
    }
}

