/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentDescriptor
implements ClassDescriptor {
    static final Integer TRANSIENT_STATE = 1;
    static final Integer HOLLOW_STATE = 5;
    static final Integer COMMITTED_STATE = 3;
    protected ClassDescriptor superclassDescriptor;
    protected Class<?> objectClass;
    protected Map<String, Property> declaredProperties = new HashMap<String, Property>();
    protected Map<String, Property> superProperties = new HashMap<String, Property>();
    protected Map<String, ClassDescriptor> subclassDescriptors = new HashMap<String, ClassDescriptor>();
    protected Accessor persistenceStateAccessor;
    protected ObjEntity entity;
    protected Collection<DbEntity> rootDbEntities = new HashSet<DbEntity>(1);
    protected EntityInheritanceTree entityInheritanceTree;
    protected Collection<AttributeProperty> idProperties;
    protected Collection<ArcProperty> mapArcProperties;
    protected Collection<ObjAttribute> allDiscriminatorColumns;
    protected Expression entityQualifier;

    public void setDiscriminatorColumns(Collection<ObjAttribute> columns) {
        this.allDiscriminatorColumns = columns == null || columns.isEmpty() ? null : new ArrayList<ObjAttribute>(columns);
    }

    public void addSuperProperty(Property property) {
        this.superProperties.put(property.getName(), property);
        this.indexAddedProperty(property);
    }

    public void addDeclaredProperty(Property property) {
        this.declaredProperties.put(property.getName(), property);
        this.indexAddedProperty(property);
    }

    public void addRootDbEntity(DbEntity dbEntity) {
        this.rootDbEntities.add(dbEntity);
    }

    void indexAddedProperty(Property property) {
        ObjRelationship relationship;
        ObjRelationship reverseRelationship;
        if (property instanceof AttributeProperty) {
            AttributeProperty attributeProperty = (AttributeProperty)property;
            ObjAttribute attribute = attributeProperty.getAttribute();
            if (attribute.isPrimaryKey()) {
                if (this.idProperties == null) {
                    this.idProperties = new ArrayList<AttributeProperty>(2);
                }
                this.idProperties.add(attributeProperty);
            }
        } else if (property instanceof ArcProperty && (reverseRelationship = (relationship = ((ArcProperty)property).getRelationship()).getReverseRelationship()) != null && "java.util.Map".equals(reverseRelationship.getCollectionType())) {
            if (this.mapArcProperties == null) {
                this.mapArcProperties = new ArrayList<ArcProperty>(2);
            }
            this.mapArcProperties.add((ArcProperty)property);
        }
    }

    public void removeDeclaredProperty(String propertyName) {
        Property removed = this.declaredProperties.remove(propertyName);
        if (removed != null) {
            if (this.idProperties != null) {
                this.idProperties.remove(removed);
            }
            if (this.mapArcProperties != null) {
                this.mapArcProperties.remove(removed);
            }
        }
    }

    public void addSubclassDescriptor(String className, ClassDescriptor subclassDescriptor) {
        this.subclassDescriptors.put(className, subclassDescriptor);
    }

    @Override
    public ObjEntity getEntity() {
        return this.entity;
    }

    @Override
    public Collection<DbEntity> getRootDbEntities() {
        return this.rootDbEntities;
    }

    @Override
    public boolean isFault(Object object) {
        if (this.superclassDescriptor != null) {
            return this.superclassDescriptor.isFault(object);
        }
        if (object == null) {
            return false;
        }
        return HOLLOW_STATE.equals(this.persistenceStateAccessor.getValue(object));
    }

    @Override
    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    void setObjectClass(Class<?> objectClass) {
        this.objectClass = objectClass;
    }

    @Override
    public ClassDescriptor getSubclassDescriptor(Class<?> objectClass) {
        if (objectClass == null) {
            throw new IllegalArgumentException("Null objectClass");
        }
        if (this.subclassDescriptors.isEmpty()) {
            return this;
        }
        ClassDescriptor subclassDescriptor = this.subclassDescriptors.get(objectClass.getName());
        if (subclassDescriptor == null) {
            Class<?> currentClass = objectClass;
            while (subclassDescriptor == null && (currentClass = currentClass.getSuperclass()) != null) {
                subclassDescriptor = this.subclassDescriptors.get(currentClass.getName());
            }
        }
        return subclassDescriptor != null ? subclassDescriptor : this;
    }

    @Override
    public Collection<ObjAttribute> getDiscriminatorColumns() {
        return this.allDiscriminatorColumns != null ? this.allDiscriminatorColumns : Collections.emptyList();
    }

    @Override
    public Collection<AttributeProperty> getIdProperties() {
        if (this.idProperties != null) {
            return this.idProperties;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ArcProperty> getMapArcProperties() {
        if (this.mapArcProperties != null) {
            return this.mapArcProperties;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Property getProperty(String propertyName) {
        Property property = this.getDeclaredProperty(propertyName);
        if (property == null && this.superclassDescriptor != null) {
            property = this.superclassDescriptor.getProperty(propertyName);
        }
        return property;
    }

    @Override
    public Property getDeclaredProperty(String propertyName) {
        return this.declaredProperties.get(propertyName);
    }

    @Override
    public ClassDescriptor getSuperclassDescriptor() {
        return this.superclassDescriptor;
    }

    @Override
    public Object createObject() {
        if (this.objectClass == null) {
            throw new NullPointerException("Null objectClass. Descriptor wasn't initialized properly.");
        }
        try {
            return this.objectClass.newInstance();
        }
        catch (Throwable e) {
            throw new CayenneRuntimeException("Error creating object of class '" + this.objectClass.getName() + "'", e, new Object[0]);
        }
    }

    @Override
    public void injectValueHolders(Object object) throws PropertyException {
        if (this.getSuperclassDescriptor() != null) {
            this.getSuperclassDescriptor().injectValueHolders(object);
        }
        for (Property property : this.declaredProperties.values()) {
            property.injectValueHolder(object);
        }
    }

    @Override
    public void shallowMerge(final Object from, final Object to) throws PropertyException {
        this.visitProperties(new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                property.writePropertyDirectly(to, property.readPropertyDirectly(to), property.readPropertyDirectly(from));
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                property.invalidate(to);
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                return true;
            }
        });
    }

    boolean visitSuperProperties(PropertyVisitor visitor) {
        for (Property next : this.superProperties.values()) {
            if (next.visit(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean visitDeclaredProperties(PropertyVisitor visitor) {
        for (Property next : this.declaredProperties.values()) {
            if (next.visit(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean visitAllProperties(PropertyVisitor visitor) {
        if (!this.visitProperties(visitor)) {
            return false;
        }
        if (!this.subclassDescriptors.isEmpty()) {
            for (ClassDescriptor next : this.subclassDescriptors.values()) {
                if (next.visitDeclaredProperties(visitor)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean visitProperties(PropertyVisitor visitor) {
        if (!this.visitSuperProperties(visitor)) {
            return false;
        }
        return this.visitDeclaredProperties(visitor);
    }

    public void setPersistenceStateAccessor(Accessor persistenceStateAccessor) {
        this.persistenceStateAccessor = persistenceStateAccessor;
    }

    public void setEntity(ObjEntity entity) {
        this.entity = entity;
    }

    public void setSuperclassDescriptor(ClassDescriptor superclassDescriptor) {
        this.superclassDescriptor = superclassDescriptor;
    }

    @Override
    public Expression getEntityQualifier() {
        return this.entityQualifier;
    }

    public void setEntityQualifier(Expression entityQualifier) {
        this.entityQualifier = entityQualifier;
    }

    @Override
    public EntityInheritanceTree getEntityInheritanceTree() {
        return this.entityInheritanceTree;
    }

    public void setEntityInheritanceTree(EntityInheritanceTree entityInheritanceTree) {
        this.entityInheritanceTree = entityInheritanceTree;
    }

    @Override
    public boolean hasSubclasses() {
        return this.entityInheritanceTree != null && !this.entityInheritanceTree.getChildren().isEmpty();
    }
}

