/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.hessian;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.SerializerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.remote.hessian.CayenneSerializerFactory;
import org.apache.cayenne.util.Util;

public class HessianConfig {
    public static SerializerFactory createFactory(String[] factoryNames, EntityResolver resolver) {
        CayenneSerializerFactory factory = new CayenneSerializerFactory();
        if (factoryNames != null && factoryNames.length > 0) {
            for (String factoryName : factoryNames) {
                try {
                    factory.addFactory(HessianConfig.loadFactory(factoryName, resolver));
                }
                catch (Exception e) {
                    throw new CayenneRuntimeException("Error configuring factory class " + factoryName, (Throwable)e, new Object[0]);
                }
            }
        }
        return factory;
    }

    static AbstractSerializerFactory loadFactory(String factoryName, EntityResolver resolver) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> factoryClass = Class.forName(factoryName, true, loader);
        if (!AbstractSerializerFactory.class.isAssignableFrom(factoryClass)) {
            throw new IllegalArgumentException(factoryClass + " is not a AbstractSerializerFactory");
        }
        Constructor<?> c = factoryClass.getDeclaredConstructor(new Class[0]);
        if (!Util.isAccessible(c)) {
            c.setAccessible(true);
        }
        AbstractSerializerFactory object = (AbstractSerializerFactory)c.newInstance(new Object[0]);
        if (resolver != null) {
            try {
                Method setter = factoryClass.getDeclaredMethod("setEntityResolver", EntityResolver.class);
                if (!Util.isAccessible(setter)) {
                    setter.setAccessible(true);
                }
                setter.invoke((Object)object, resolver);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return object;
    }
}

