/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.cayenne.util.RegexUtil;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static File toFile(URL url) throws IllegalArgumentException {
        URI uri;
        String urlString = url.toExternalForm();
        try {
            uri = new URI(urlString.replace(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL " + urlString + " can't be converted to URI", e);
        }
        return new File(uri);
    }

    public static String stringFromFile(File file) throws IOException {
        return Util.stringFromFile(file, System.getProperty("line.separator"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringFromFile(File file, String joinWith) throws IOException {
        StringBuilder buf = new StringBuilder();
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                buf.append(line).append(joinWith);
            }
        }
        finally {
            in.close();
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File source, File destination) {
        BufferedInputStream fin = null;
        FilterOutputStream fout = null;
        try {
            int bufSize = 8192;
            fin = new BufferedInputStream(new FileInputStream(source), bufSize);
            fout = new BufferedOutputStream(new FileOutputStream(destination), bufSize);
            Util.copyPipe(fin, fout, bufSize);
        }
        catch (IOException ioex) {
            boolean bl = false;
            return bl;
        }
        catch (SecurityException sx) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException cioex) {}
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException cioex) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(URL from, File to) {
        BufferedInputStream urlin = null;
        FilterOutputStream fout = null;
        try {
            int bufSize = 8192;
            urlin = new BufferedInputStream(from.openConnection().getInputStream(), bufSize);
            fout = new BufferedOutputStream(new FileOutputStream(to), bufSize);
            Util.copyPipe(urlin, fout, bufSize);
        }
        catch (IOException ioex) {
            boolean bl = false;
            return bl;
        }
        catch (SecurityException sx) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (urlin != null) {
                try {
                    urlin.close();
                }
                catch (IOException cioex) {}
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException cioex) {}
            }
        }
        return true;
    }

    public static void copyPipe(InputStream in, OutputStream out, int bufSizeHint) throws IOException {
        int read = -1;
        byte[] buf = new byte[bufSizeHint];
        while ((read = in.read(buf, 0, bufSizeHint)) >= 0) {
            out.write(buf, 0, read);
        }
        out.flush();
    }

    public static boolean delete(String filePath, boolean recursive) {
        File file = new File(filePath);
        if (!file.exists()) {
            return true;
        }
        if (!recursive || !file.isDirectory()) {
            return file.delete();
        }
        String[] contents = file.list();
        if (contents != null) {
            for (String item : contents) {
                if (Util.delete(filePath + File.separator + item, true)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static String substBackslashes(String string) {
        return RegexUtil.substBackslashes(string);
    }

    public static Throwable unwindException(Throwable th) {
        if (th instanceof SAXException) {
            SAXException sax = (SAXException)th;
            if (sax.getException() != null) {
                return Util.unwindException(sax.getException());
            }
        } else if (th instanceof SQLException) {
            SQLException sql = (SQLException)th;
            if (sql.getNextException() != null) {
                return Util.unwindException(sql.getNextException());
            }
        } else if (th.getCause() != null) {
            return Util.unwindException(th.getCause());
        }
        return th;
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1.getClass().isArray()) {
            EqualsBuilder builder = new EqualsBuilder();
            builder.append(o1, o2);
            return builder.isEquals();
        }
        return o1.equals(o2);
    }

    public static <T> int nullSafeCompare(boolean nullsFirst, Comparable<T> o1, T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return nullsFirst ? -1 : 1;
        }
        if (o2 == null) {
            return nullsFirst ? 1 : -1;
        }
        return o1.compareTo(o2);
    }

    public static boolean isEmptyString(String string) {
        return string == null || string.length() == 0;
    }

    public static <T extends Serializable> T cloneViaSerialization(T object) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(){

            public byte[] toByteArray() {
                return this.buf;
            }
        };
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(object);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
        Serializable copy = (Serializable)in.readObject();
        return (T)copy;
    }

    public static XMLReader createXmlReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser saxParser = spf.newSAXParser();
        XMLReader reader = saxParser.getXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        return reader;
    }

    public static String getPackagePath(String className) {
        return RegexUtil.getPackagePath(className);
    }

    public static String stripPackageName(String className) {
        if (className == null || className.length() == 0) {
            return className;
        }
        int lastDot = className.lastIndexOf(46);
        if (-1 == lastDot || className.length() - 1 == lastDot) {
            return className;
        }
        return className.substring(lastDot + 1);
    }

    public static <K, V> Map<K, V> toMap(K[] keys, V[] values) {
        int valuesSize;
        int keysSize = keys != null ? keys.length : 0;
        int n = valuesSize = values != null ? values.length : 0;
        if (keysSize == 0 && valuesSize == 0) {
            return new HashMap();
        }
        if (keysSize != valuesSize) {
            throw new IllegalArgumentException("The number of keys doesn't match the number of values.");
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < keysSize; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static String extractFileExtension(String fileName) {
        int dotInd = fileName.lastIndexOf(46);
        return dotInd > 0 && dotInd < fileName.length() ? fileName.substring(dotInd + 1) : null;
    }

    public static String stripFileExtension(String fileName) {
        int dotInd = fileName.lastIndexOf(46);
        return dotInd > 0 ? fileName.substring(0, dotInd) : fileName;
    }

    @Deprecated
    public static String stripLineBreaks(String string, String replaceWith) {
        if (Util.isEmptyString(string)) {
            return string;
        }
        int len = string.length();
        StringBuilder buffer = new StringBuilder(len);
        block3: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    if (i + 1 < len && string.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    buffer.append(replaceWith);
                    continue block3;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static String stripLineBreaks(String string, char replaceWith) {
        if (string == null) {
            return null;
        }
        int len = string.length();
        char[] buffer = new char[len];
        boolean matched = false;
        int j = 0;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == '\n' || c == '\r') {
                matched = true;
                if (i + 1 < len && string.charAt(i + 1) == '\n') {
                    ++i;
                }
                buffer[j] = replaceWith;
            } else {
                buffer[j] = c;
            }
            ++i;
            ++j;
        }
        return matched ? new String(buffer, 0, j) : string;
    }

    public static String encodeXmlAttribute(String string) {
        if (string == null) {
            return null;
        }
        int len = string.length();
        if (len == 0) {
            return string;
        }
        StringBuilder encoded = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                encoded.append("&lt;");
                continue;
            }
            if (c == '\"') {
                encoded.append("&quot;");
                continue;
            }
            if (c == '>') {
                encoded.append("&gt;");
                continue;
            }
            if (c == '\'') {
                encoded.append("&apos;");
                continue;
            }
            if (c == '&') {
                encoded.append("&amp;");
                continue;
            }
            encoded.append(c);
        }
        return encoded.toString();
    }

    public static String prettyTrim(String str, int maxLength) {
        if (maxLength < 5) {
            throw new IllegalArgumentException("Algorithm for 'prettyTrim' works only with length >= 5. Supplied length is " + maxLength);
        }
        if (str == null || str.length() <= maxLength) {
            return str;
        }
        int len = maxLength - 3;
        int startLen = len / 2;
        int endLen = len - startLen;
        return str.substring(0, startLen) + "..." + str.substring(str.length() - endLen);
    }

    public static <T> Iterator<T> sortedIterator(Iterator<T> it, Comparator<T> comparator) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, comparator);
        return list.iterator();
    }

    public static int hashCode(Collection<?> c) {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (Object o : c) {
            builder.append(o);
        }
        return builder.toHashCode();
    }

    public static Pattern sqlPatternToPattern(String pattern, boolean ignoreCase) {
        String preprocessed = RegexUtil.sqlPatternToRegex(pattern);
        int flag = ignoreCase ? 2 : 0;
        return Pattern.compile(preprocessed, flag);
    }

    public static boolean isAccessible(Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers());
    }

    public static Class<?> getJavaClass(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new ClassNotFoundException("Null class name");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = Util.class.getClassLoader();
        }
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            if (!className.endsWith("[]")) {
                if ("byte".equals(className)) {
                    return Byte.TYPE;
                }
                if ("int".equals(className)) {
                    return Integer.TYPE;
                }
                if ("short".equals(className)) {
                    return Short.TYPE;
                }
                if ("char".equals(className)) {
                    return Character.TYPE;
                }
                if ("double".equals(className)) {
                    return Double.TYPE;
                }
                if ("long".equals(className)) {
                    return Long.TYPE;
                }
                if ("float".equals(className)) {
                    return Float.TYPE;
                }
                if ("boolean".equals(className)) {
                    return Boolean.TYPE;
                }
                int dot = className.lastIndexOf(46);
                if (dot > 0 && dot + 1 < className.length()) {
                    className = className.substring(0, dot) + "$" + className.substring(dot + 1);
                    try {
                        return Class.forName(className, true, classLoader);
                    }
                    catch (ClassNotFoundException nestedE) {
                        // empty catch block
                    }
                }
                throw e;
            }
            if (className.length() < 3) {
                throw new IllegalArgumentException("Invalid class name: " + className);
            }
            if ("byte".equals(className = className.substring(0, className.length() - 2))) {
                return byte[].class;
            }
            if ("int".equals(className)) {
                return int[].class;
            }
            if ("short".equals(className)) {
                return short[].class;
            }
            if ("char".equals(className)) {
                return char[].class;
            }
            if ("double".equals(className)) {
                return double[].class;
            }
            if ("float".equals(className)) {
                return float[].class;
            }
            if ("boolean".equals(className)) {
                return boolean[].class;
            }
            return Class.forName("[L" + className + ";", true, classLoader);
        }
    }

    static void setReverse(final Persistent sourceObject, String propertyName, final Persistent targetObject) {
        ArcProperty property = (ArcProperty)Cayenne.getClassDescriptor(sourceObject).getProperty(propertyName);
        ArcProperty reverseArc = property.getComplimentaryReverseArc();
        if (reverseArc != null) {
            reverseArc.visit(new PropertyVisitor(){

                public boolean visitToMany(ToManyProperty property) {
                    property.addTargetDirectly(targetObject, sourceObject);
                    return false;
                }

                public boolean visitToOne(ToOneProperty property) {
                    property.setTarget(targetObject, sourceObject, false);
                    return false;
                }

                public boolean visitAttribute(AttributeProperty property) {
                    return false;
                }
            });
            sourceObject.getObjectContext().getGraphManager().arcCreated(targetObject.getObjectId(), sourceObject.getObjectId(), reverseArc.getName());
            Util.markAsDirty(targetObject);
        }
    }

    static void unsetReverse(final Persistent sourceObject, String propertyName, final Persistent targetObject) {
        ArcProperty property = (ArcProperty)Cayenne.getClassDescriptor(sourceObject).getProperty(propertyName);
        ArcProperty reverseArc = property.getComplimentaryReverseArc();
        if (reverseArc != null) {
            reverseArc.visit(new PropertyVisitor(){

                public boolean visitToMany(ToManyProperty property) {
                    property.removeTargetDirectly(targetObject, sourceObject);
                    return false;
                }

                public boolean visitToOne(ToOneProperty property) {
                    property.setTarget(targetObject, null, false);
                    return false;
                }

                public boolean visitAttribute(AttributeProperty property) {
                    return false;
                }
            });
            sourceObject.getObjectContext().getGraphManager().arcDeleted(targetObject.getObjectId(), sourceObject.getObjectId(), reverseArc.getName());
            Util.markAsDirty(targetObject);
        }
    }

    static boolean markAsDirty(Persistent object) {
        if (object.getPersistenceState() == 3) {
            object.setPersistenceState(4);
            return true;
        }
        return false;
    }
}

