/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLUtil {
    static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss zzz";
    static DocumentBuilderFactory sharedFactory;

    XMLUtil() {
    }

    static DocumentBuilder newBuilder() throws CayenneRuntimeException {
        if (sharedFactory == null) {
            sharedFactory = DocumentBuilderFactory.newInstance();
        }
        try {
            return sharedFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new CayenneRuntimeException("Can't create DocumentBuilder", (Throwable)e, new Object[0]);
        }
    }

    static List<Element> replaceParent(Node oldParent, Node newParent) {
        List<Element> children = XMLUtil.getChildren(oldParent);
        for (Element child : children) {
            oldParent.removeChild(child);
            newParent.appendChild(child);
        }
        return children;
    }

    static String getText(Node node) {
        NodeList nodes = node.getChildNodes();
        int len = nodes.getLength();
        if (len == 0) {
            return null;
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            Node child = nodes.item(i);
            if (!(child instanceof CharacterData)) continue;
            text.append(((CharacterData)child).getData());
        }
        return text.length() == 0 ? null : text.toString();
    }

    static Element getChild(Node node, final String name) {
        Predicate p = new Predicate(){

            public boolean evaluate(Object object) {
                if (object instanceof Element) {
                    Element e = (Element)object;
                    return name.equals(e.getNodeName());
                }
                return false;
            }
        };
        return (Element)XMLUtil.firstMatch(node.getChildNodes(), p);
    }

    static List<Element> getChildren(Node node, final String name) {
        Predicate p = new Predicate(){

            public boolean evaluate(Object object) {
                if (object instanceof Element) {
                    Element e = (Element)object;
                    return name.equals(e.getNodeName());
                }
                return false;
            }
        };
        return (List)CollectionUtils.select(XMLUtil.getChildren(node), (Predicate)p);
    }

    static List<Element> getChildren(Node node) {
        NodeList list = node.getChildNodes();
        int len = list.getLength();
        ArrayList<Element> children = new ArrayList<Element>(len);
        for (int i = 0; i < len; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            children.add((Element)child);
        }
        return children;
    }

    private static Node firstMatch(NodeList list, Predicate predicate) {
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = list.item(i);
            if (!predicate.evaluate((Object)node)) continue;
            return node;
        }
        return null;
    }
}

