/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AtomEntryWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;

public class PolicyServiceImpl
extends AbstractAtomPubService
implements PolicyService {
    public PolicyServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        String link = this.loadLink(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/policies", "application/atom+xml;type=feed");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/policies", "application/atom+xml;type=feed");
        }
        UrlBuilder url = new UrlBuilder(link);
        final AtomEntryWriter entryWriter = new AtomEntryWriter(this.createIdObject(objectId), this.getCmisVersion(repositoryId));
        this.postAndConsume(url, "application/atom+xml;type=entry", new Output(){

            @Override
            public void write(OutputStream out) throws XMLStreamException, IOException {
                entryWriter.write(out);
            }
        });
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        ArrayList<ObjectData> result = new ArrayList<ObjectData>();
        String link = this.loadLink(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/policies", "application/atom+xml;type=feed");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/policies", "application/atom+xml;type=feed");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("filter", (Object)filter);
        Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        if (!feed.getEntries().isEmpty()) {
            for (AtomEntry entry : feed.getEntries()) {
                ObjectData policy = null;
                for (AtomElement element : entry.getElements()) {
                    if (!(element.getObject() instanceof ObjectData)) continue;
                    policy = (ObjectData)element.getObject();
                }
                if (policy == null) continue;
                result.add(policy);
            }
        }
        return result;
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        if (policyId == null) {
            throw new CmisInvalidArgumentException("Policy id must be set!");
        }
        String link = this.loadLink(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/policies", "application/atom+xml;type=feed");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/policies", "application/atom+xml;type=feed");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("filter", (Object)"cmis:objectId");
        Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        String policyLink = null;
        boolean found = false;
        if (!feed.getEntries().isEmpty()) {
            for (AtomEntry entry : feed.getEntries()) {
                for (AtomElement element : entry.getElements()) {
                    String id;
                    if (element.getObject() instanceof AtomLink) {
                        AtomLink atomLink = (AtomLink)element.getObject();
                        if (!"self".equals(atomLink.getRel())) continue;
                        policyLink = atomLink.getHref();
                        continue;
                    }
                    if (!(element.getObject() instanceof ObjectData) || !policyId.equals(id = ((ObjectData)element.getObject()).getId())) continue;
                    found = true;
                }
                if (!found) continue;
                break;
            }
        }
        if (found && policyLink != null) {
            this.delete(new UrlBuilder(policyLink));
        }
    }
}

