/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.apache.chemistry.opencmis.client.bindings.impl.ClientVersion;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpInvoker;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpHttpInvoker
implements HttpInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(OkHttpHttpInvoker.class);
    protected static final String HTTP_CLIENT = "org.apache.chemistry.opencmis.client.bindings.spi.http.OkHttpHttpInvoker.httpClient";

    @Override
    public Response invokeGET(UrlBuilder url, BindingSession session) {
        return this.invoke(url, "GET", null, null, null, session, null, null);
    }

    @Override
    public Response invokeGET(UrlBuilder url, BindingSession session, BigInteger offset, BigInteger length) {
        return this.invoke(url, "GET", null, null, null, session, offset, length);
    }

    @Override
    public Response invokePOST(UrlBuilder url, String contentType, Output writer, BindingSession session) {
        return this.invoke(url, "POST", contentType, null, writer, session, null, null);
    }

    @Override
    public Response invokePUT(UrlBuilder url, String contentType, Map<String, String> headers, Output writer, BindingSession session) {
        return this.invoke(url, "PUT", contentType, headers, writer, session, null, null);
    }

    @Override
    public Response invokeDELETE(UrlBuilder url, BindingSession session) {
        return this.invoke(url, "DELETE", null, null, null, session, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response invoke(UrlBuilder url, String method, final String contentType, Map<String, String> headers, final Output writer, BindingSession session, BigInteger offset, BigInteger length) {
        int respCode = -1;
        try {
            Object compression;
            Map httpHeaders;
            OkHttpClient httpclient;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {}: {} {}", new Object[]{session.getSessionId(), method, url});
            }
            if ((httpclient = (OkHttpClient)session.get(HTTP_CLIENT)) == null) {
                session.writeLock();
                try {
                    httpclient = (OkHttpClient)session.get(HTTP_CLIENT);
                    if (httpclient == null) {
                        httpclient = this.createClientBuilder(session).build();
                        session.put(HTTP_CLIENT, httpclient, true);
                    }
                }
                finally {
                    session.writeUnlock();
                }
            }
            Request.Builder requestBuilder = new Request.Builder().url(url.toString());
            RequestBody body = null;
            if (writer != null) {
                body = new RequestBody(){

                    public void writeTo(BufferedSink sink) throws IOException {
                        try {
                            OutputStream out = sink.outputStream();
                            writer.write(out);
                            out.flush();
                        }
                        catch (IOException ioe) {
                            throw ioe;
                        }
                        catch (Exception e) {
                            throw new IOException("Could not send stream to server: " + e.toString(), e);
                        }
                    }

                    public MediaType contentType() {
                        if (contentType != null) {
                            return MediaType.parse((String)contentType);
                        }
                        return MediaType.parse((String)"application/octet-stream");
                    }
                };
            }
            if ("GET".equals(method)) {
                requestBuilder.get();
            } else if ("POST".equals(method)) {
                requestBuilder.post(body);
            } else if ("PUT".equals(method)) {
                requestBuilder.put(body);
            } else if ("DELETE".equals(method)) {
                requestBuilder.delete();
            } else {
                throw new CmisRuntimeException("Invalid HTTP method!");
            }
            if (contentType != null) {
                requestBuilder.header("Content-Type", contentType);
            }
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    requestBuilder.addHeader(header.getKey(), header.getValue());
                }
            }
            requestBuilder.header("User-Agent", (String)session.get("org.apache.chemistry.opencmis.binding.useragent", ClientVersion.OPENCMIS_USER_AGENT));
            AuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(session);
            if (authProvider != null && (httpHeaders = authProvider.getHTTPHeaders(url.toString())) != null) {
                for (Map.Entry header : httpHeaders.entrySet()) {
                    if (header.getKey() == null || !CollectionsHelper.isNotEmpty((Collection)((Collection)header.getValue()))) continue;
                    String key = (String)header.getKey();
                    if (key.equalsIgnoreCase("user-agent")) {
                        requestBuilder.header("User-Agent", (String)((List)header.getValue()).get(0));
                        continue;
                    }
                    for (String value : (List)header.getValue()) {
                        if (value == null) continue;
                        requestBuilder.addHeader(key, value);
                    }
                }
            }
            if (offset != null || length != null) {
                StringBuilder sb = new StringBuilder("bytes=");
                if (offset == null || offset.signum() == -1) {
                    offset = BigInteger.ZERO;
                }
                sb.append(offset.toString());
                sb.append('-');
                if (length != null && length.signum() == 1) {
                    sb.append(offset.add(length.subtract(BigInteger.ONE)).toString());
                }
                requestBuilder.header("Range", sb.toString());
            }
            if ((compression = session.get("org.apache.chemistry.opencmis.binding.compression")) != null && Boolean.parseBoolean(compression.toString())) {
                requestBuilder.header("Accept-Encoding", "gzip,deflate");
            }
            if (session.get("org.apache.chemistry.opencmis.binding.acceptLanguage") instanceof String) {
                requestBuilder.header("Accept-Language", session.get("org.apache.chemistry.opencmis.binding.acceptLanguage").toString());
            }
            okhttp3.Response okResponse = httpclient.newCall(requestBuilder.build()).execute();
            respCode = okResponse.code();
            InputStream inputStream = null;
            InputStream errorStream = null;
            if (respCode == 200 || respCode == 201 || respCode == 203 || respCode == 206) {
                inputStream = okResponse.body().byteStream();
            } else {
                errorStream = okResponse.body().byteStream();
            }
            Map responseHeaders = okResponse.headers().toMultimap();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Session {}: {} {} > Headers: {}", new Object[]{session.getSessionId(), method, url, responseHeaders.toString()});
            }
            if (authProvider != null) {
                authProvider.putResponseHeaders(url.toString(), respCode, responseHeaders);
            }
            return new Response(respCode, okResponse.message(), responseHeaders, inputStream, errorStream);
        }
        catch (Exception e) {
            String status = respCode > 0 ? " (HTTP status code " + respCode + ")" : "";
            throw new CmisConnectionException("Cannot access \"" + url + "\"" + status + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected OkHttpClient.Builder createClientBuilder(BindingSession session) {
        AuthenticationProvider authProvider;
        int readTimeout;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        int connectTimeout = session.get("org.apache.chemistry.opencmis.binding.connecttimeout", -1);
        if (connectTimeout >= 0) {
            clientBuilder.connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS);
        }
        if ((readTimeout = session.get("org.apache.chemistry.opencmis.binding.readtimeout", -1)) >= 0) {
            clientBuilder.readTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        }
        if ((authProvider = CmisBindingsHelper.getAuthenticationProvider(session)) != null) {
            HostnameVerifier hv;
            SSLSocketFactory sf = authProvider.getSSLSocketFactory();
            if (sf != null) {
                X509TrustManager tm = null;
                if (authProvider instanceof AbstractAuthenticationProvider) {
                    tm = ((AbstractAuthenticationProvider)authProvider).getTrustManager();
                }
                if (tm == null) {
                    clientBuilder.sslSocketFactory(sf);
                } else {
                    clientBuilder.sslSocketFactory(sf, tm);
                }
            }
            if ((hv = authProvider.getHostnameVerifier()) != null) {
                clientBuilder.hostnameVerifier(hv);
            }
        }
        return clientBuilder;
    }
}

