/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisRepositoryContextListener
implements ServletContextListener {
    public static final String SERVICES_FACTORY = "org.apache.chemistry.opencmis.servicesfactory";
    private static final Logger LOG = LoggerFactory.getLogger((String)CmisRepositoryContextListener.class.getName());
    private static final String CONFIG_INIT_PARAM = "org.apache.chemistry.opencmis.REPOSITORY_CONFIG_FILE";
    private static final String CONFIG_FILENAME = "/repository.properties";
    private static final String PROPERTY_CLASS = "class";

    public void contextInitialized(ServletContextEvent sce) {
        String configFilename = sce.getServletContext().getInitParameter(CONFIG_INIT_PARAM);
        if (configFilename == null) {
            configFilename = CONFIG_FILENAME;
        }
        CmisServiceFactory factory = null;
        try {
            factory = this.createServiceFactory(configFilename);
        }
        catch (Exception e) {
            LOG.error("Service factory couldn't be created: {}", (Object)e.toString(), (Object)e);
            return;
        }
        sce.getServletContext().setAttribute(SERVICES_FACTORY, (Object)factory);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        CmisServiceFactory factory = (CmisServiceFactory)sce.getServletContext().getAttribute(SERVICES_FACTORY);
        if (factory != null) {
            try {
                factory.destroy();
            }
            catch (Exception e) {
                LOG.error("Service factory couldn't be destroyed: {}", (Object)e.toString(), (Object)e);
                return;
            }
        }
    }

    public static CmisServiceFactory getServiceFactory(ServletContext servletContext) {
        return (CmisServiceFactory)servletContext.getAttribute(SERVICES_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmisServiceFactory createServiceFactory(String filename) {
        InputStream stream = this.getClass().getResourceAsStream(filename);
        if (stream == null) {
            LOG.warn("Cannot find configuration!");
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException e) {
            LOG.warn("Cannot load configuration: {}", (Object)e.toString(), (Object)e);
            CmisServiceFactory cmisServiceFactory = null;
            return cmisServiceFactory;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
        String className = props.getProperty(PROPERTY_CLASS);
        if (className == null) {
            LOG.warn("Configuration doesn't contain the property 'class'!");
            return null;
        }
        Object object = null;
        try {
            object = ClassLoaderUtil.loadClass((String)className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Could not create a services factory instance: {}", (Object)e.toString(), (Object)e);
            return null;
        }
        if (!(object instanceof CmisServiceFactory)) {
            LOG.warn("The provided class is not an instance of CmisServiceFactory!");
        }
        CmisServiceFactory factory = object;
        HashMap<String, String> parameters = new HashMap<String, String>(props.size());
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            parameters.put(key, value);
        }
        factory.init(parameters);
        if (LOG.isInfoEnabled()) {
            LOG.info("Initialized Services Factory: {}", (Object)factory.getClass().getName());
        }
        return factory;
    }
}

