/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.DateTimeFormat;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.impl.json.JSONValue;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParser;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;

public class RepositoryService {

    public static class DeleteType
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String typeId = this.getStringParameter(request, "typeId");
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteType(repositoryId, typeId, null);
            if (this.stopAfterService(service)) {
                return;
            }
            response.setStatus(200);
            this.writeEmpty(request, response);
        }
    }

    public static class UpdateType
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String typeStr = this.getStringParameter(request, "type");
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (typeStr == null) {
                throw new CmisInvalidArgumentException("Type definition missing!");
            }
            JSONParser parser = new JSONParser();
            Object typeJson = parser.parse(typeStr);
            if (!(typeJson instanceof Map)) {
                throw new CmisInvalidArgumentException("Invalid type definition!");
            }
            TypeDefinition typeIn = JSONConverter.convertTypeDefinition((Map)((Map)typeJson));
            if (this.stopBeforeService(service)) {
                return;
            }
            TypeDefinition typeOut = service.updateType(repositoryId, typeIn, null);
            if (this.stopAfterService(service)) {
                return;
            }
            JSONObject jsonType = JSONConverter.convert((TypeDefinition)typeOut, (DateTimeFormat)dateTimeFormat);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonType, request, response);
        }
    }

    public static class CreateType
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String typeStr = this.getStringParameter(request, "type");
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (typeStr == null) {
                throw new CmisInvalidArgumentException("Type definition missing!");
            }
            JSONParser parser = new JSONParser();
            Object typeJson = parser.parse(typeStr);
            if (!(typeJson instanceof Map)) {
                throw new CmisInvalidArgumentException("Invalid type definition!");
            }
            TypeDefinition typeIn = JSONConverter.convertTypeDefinition((Map)((Map)typeJson));
            if (this.stopBeforeService(service)) {
                return;
            }
            TypeDefinition typeOut = service.createType(repositoryId, typeIn, null);
            if (this.stopAfterService(service)) {
                return;
            }
            JSONObject jsonType = JSONConverter.convert((TypeDefinition)typeOut, (DateTimeFormat)dateTimeFormat);
            response.setStatus(201);
            response.setHeader("Location", this.compileTypeLocationUrl(request, repositoryId, typeOut.getId()));
            this.writeJSON((JSONStreamAware)jsonType, request, response);
        }
    }

    public static class GetTypeDefinition
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String typeId = this.getStringParameter(request, "typeId");
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            TypeDefinition type = service.getTypeDefinition(repositoryId, typeId, null);
            if (this.stopAfterService(service)) {
                return;
            }
            JSONObject jsonType = JSONConverter.convert((TypeDefinition)type, (DateTimeFormat)dateTimeFormat);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonType, request, response);
        }
    }

    public static class GetTypeDescendants
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String typeId = this.getStringParameter(request, "typeId");
            BigInteger depth = this.getBigIntegerParameter(request, "depth");
            boolean includePropertyDefinitions = this.getBooleanParameter(request, "includePropertyDefinitions", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            List typeTree = service.getTypeDescendants(repositoryId, typeId, depth, Boolean.valueOf(includePropertyDefinitions), null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (typeTree == null) {
                throw new CmisRuntimeException("Type tree is null!");
            }
            JSONArray jsonTypeTree = new JSONArray();
            for (TypeDefinitionContainer container : typeTree) {
                jsonTypeTree.add((Object)JSONConverter.convert((TypeDefinitionContainer)container, (DateTimeFormat)dateTimeFormat));
            }
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonTypeTree, request, response);
        }
    }

    public static class GetTypeChildren
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String typeId = this.getStringParameter(request, "typeId");
            boolean includePropertyDefinitions = this.getBooleanParameter(request, "includePropertyDefinitions", false);
            BigInteger maxItems = this.getBigIntegerParameter(request, "maxItems");
            BigInteger skipCount = this.getBigIntegerParameter(request, "skipCount");
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            TypeDefinitionList typeList = service.getTypeChildren(repositoryId, typeId, Boolean.valueOf(includePropertyDefinitions), maxItems, skipCount, null);
            if (this.stopAfterService(service)) {
                return;
            }
            JSONObject jsonTypeList = JSONConverter.convert((TypeDefinitionList)typeList, (DateTimeFormat)dateTimeFormat);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonTypeList, request, response);
        }
    }

    public static class GetLastResult
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String token = this.getStringParameter(request, "token");
            String cookieName = this.getCookieName(token);
            String cookieValue = null;
            if (request.getCookies() != null) {
                for (Cookie cookie : request.getCookies()) {
                    if (!cookieName.equals(cookie.getName())) continue;
                    cookieValue = IOUtils.decodeURL((String)cookie.getValue());
                    break;
                }
            }
            try {
                if (cookieValue == null) {
                    cookieValue = this.createCookieValue(0, null, "invalidArgument", "Unknown transaction!");
                } else if (!(JSONValue.parse(cookieValue) instanceof JSONObject)) {
                    cookieValue = this.createCookieValue(0, null, "invalidArgument", "Invalid cookie value!");
                }
            }
            catch (Exception pe) {
                cookieValue = this.createCookieValue(0, null, "runtime", "Cookie pasring error!");
            }
            this.deleteCookie(request, response, repositoryId, token);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)((JSONObject)JSONValue.parse((String)cookieValue)), request, response);
        }
    }

    public static class GetRepositoryInfo
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            if (this.stopBeforeService(service)) {
                return;
            }
            RepositoryInfo ri = service.getRepositoryInfo(repositoryId, null);
            if (this.stopAfterService(service)) {
                return;
            }
            String repositoryUrl = this.compileRepositoryUrl(request, ri.getId()).toString();
            String rootUrl = this.compileRootUrl(request, ri.getId()).toString();
            JSONObject result = new JSONObject();
            result.put(ri.getId(), (Object)JSONConverter.convert((RepositoryInfo)ri, (String)repositoryUrl, (String)rootUrl, (boolean)true));
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)result, request, response);
        }
    }

    public static class GetRepositories
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (request != null);
            assert (response != null);
            if (this.stopBeforeService(service)) {
                return;
            }
            List infoDataList = service.getRepositoryInfos(null);
            if (this.stopAfterService(service)) {
                return;
            }
            JSONObject result = new JSONObject();
            for (RepositoryInfo ri : infoDataList) {
                String repositoryUrl = this.compileRepositoryUrl(request, ri.getId()).toString();
                String rootUrl = this.compileRootUrl(request, ri.getId()).toString();
                result.put(ri.getId(), (Object)JSONConverter.convert((RepositoryInfo)ri, (String)repositoryUrl, (String)rootUrl, (boolean)true));
            }
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)result, request, response);
        }
    }
}

