/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.chemistry.opencmis.commons.impl.MimeHelper;

public class ProtectionRequestWrapper
extends HttpServletRequestWrapper {
    private static final String MULTIPART = "multipart/";
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte DASH = 45;
    private final int messageMax;
    private final ServletInputStream orgStream;
    private final ServletInputStream checkedStream;
    private final byte[] boundary;

    public ProtectionRequestWrapper(HttpServletRequest request, int max) throws ServletException {
        super(request);
        String contentType = request.getContentType();
        if (contentType == null || !contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART)) {
            throw new ServletException("Invalid multipart request!");
        }
        this.boundary = MimeHelper.getBoundaryFromMultiPart((String)contentType);
        if (this.boundary == null) {
            throw new ServletException("Invalid multipart request!");
        }
        try {
            this.messageMax = max;
            this.orgStream = super.getInputStream();
            this.checkedStream = new CheckServletInputStream();
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.checkedStream;
    }

    class CheckServletInputStream
    extends ServletInputStream {
        private final int streamMax;
        private byte[] linebuffer;
        private int pos;
        private int count;
        private int boundariesFound;

        public CheckServletInputStream() {
            this.streamMax = ProtectionRequestWrapper.this.messageMax + 2 * (ProtectionRequestWrapper.this.boundary.length + 6);
            this.linebuffer = new byte[32768];
            this.pos = 0;
            this.count = 0;
            this.boundariesFound = 0;
        }

        public boolean markSupported() {
            return false;
        }

        public synchronized void mark(int readlimit) {
        }

        public synchronized void reset() throws IOException {
        }

        public int available() throws IOException {
            return ProtectionRequestWrapper.this.orgStream.available();
        }

        public int read() throws IOException {
            int b = ProtectionRequestWrapper.this.orgStream.read();
            if (this.boundariesFound == 2) {
                return b;
            }
            this.addToLineBuffer((byte)b);
            return b;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int r = ProtectionRequestWrapper.this.orgStream.read(b, off, len);
            if (this.boundariesFound == 2) {
                return r;
            }
            this.addToLineBuffer(b, off, r);
            return r;
        }

        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            return this.read(new byte[n > 8192L ? 8192 : (int)n]);
        }

        public void close() throws IOException {
            ProtectionRequestWrapper.this.orgStream.close();
        }

        public boolean isFinished() {
            return ProtectionRequestWrapper.this.orgStream.isFinished();
        }

        public boolean isReady() {
            return ProtectionRequestWrapper.this.orgStream.isReady();
        }

        public void setReadListener(ReadListener readListener) {
            ProtectionRequestWrapper.this.orgStream.setReadListener(readListener);
        }

        private void checkBoundary(int startPos) {
            int lastLineFeed = -1;
            for (int i = startPos; i < this.pos; ++i) {
                if (this.linebuffer[i] != 10) continue;
                if (this.countBoundaries(i)) {
                    return;
                }
                lastLineFeed = i;
            }
            if (lastLineFeed == -1) {
                if (this.pos > ProtectionRequestWrapper.this.boundary.length + 3) {
                    System.arraycopy(this.linebuffer, this.pos - (ProtectionRequestWrapper.this.boundary.length + 3), this.linebuffer, 0, ProtectionRequestWrapper.this.boundary.length + 3);
                    this.pos = ProtectionRequestWrapper.this.boundary.length + 3;
                }
            } else if (lastLineFeed == this.pos - 1) {
                this.pos = 0;
            } else {
                System.arraycopy(this.linebuffer, lastLineFeed + 1, this.linebuffer, 0, this.pos - (lastLineFeed + 1));
                this.pos -= lastLineFeed + 1;
            }
        }

        private boolean countBoundaries(int lineFeedPos) {
            if (this.isBoundary(lineFeedPos)) {
                ++this.boundariesFound;
                if (this.boundariesFound == 2) {
                    this.linebuffer = null;
                }
            }
            return this.boundariesFound > 1;
        }

        private boolean isBoundary(int lineFeedPos) {
            int startPos = lineFeedPos - (ProtectionRequestWrapper.this.boundary.length + 3);
            if (startPos >= 0 && this.linebuffer[startPos] == 45 && this.linebuffer[startPos + 1] == 45 && this.linebuffer[lineFeedPos - 1] == 13) {
                for (int i = 0; i < ProtectionRequestWrapper.this.boundary.length; ++i) {
                    if (this.linebuffer[startPos + i + 2] == ProtectionRequestWrapper.this.boundary[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void addToLineBuffer(byte b) throws IOException {
            if (this.pos == this.linebuffer.length) {
                this.expandBuffer(1);
            }
            this.linebuffer[this.pos++] = b;
            if (b == 10) {
                this.checkBoundary(this.pos - 1);
            }
            if (this.boundariesFound < 2) {
                ++this.count;
                if (this.count > this.streamMax) {
                    throw new IOException("SOAP message too big!");
                }
            }
        }

        private void addToLineBuffer(byte[] b, int off, int len) throws IOException {
            if (len <= 0) {
                return;
            }
            if (this.pos + len >= this.linebuffer.length) {
                this.expandBuffer(len);
            }
            System.arraycopy(b, off, this.linebuffer, this.pos, len);
            this.pos += len;
            this.checkBoundary(this.pos - len);
            if (this.boundariesFound < 2) {
                this.count += len;
                if (this.count > this.streamMax) {
                    throw new IOException("SOAP message too big!");
                }
            }
        }

        private void expandBuffer(int len) throws IOException {
            if (this.pos + len > this.streamMax) {
                throw new IOException("SOAP message too big!");
            }
            int expand = len < 32768 ? 32768 : len;
            byte[] newBuffer = new byte[this.linebuffer.length + expand];
            System.arraycopy(this.linebuffer, 0, newBuffer, 0, this.pos);
            this.linebuffer = newBuffer;
        }
    }
}

