/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.report;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.report.AbstractCmisTestReport;
import org.apache.chemistry.opencmis.tck.runner.AbstractRunner;

public class CoreHtmlReport
extends AbstractCmisTestReport {
    private int stackTraceCounter;
    private String revision;

    @Override
    public void createReport(Map<String, String> parameters, List<CmisTestGroup> groups, Writer writer) throws IOException {
        this.stackTraceCounter = 0;
        if (parameters != null) {
            this.revision = parameters.get("org.apache.chemistry.opencmis.tck.revision");
        }
        writer.write("<h1>OpenCMIS TCK Report</h1>\n");
        writer.write(new Date() + "\n");
        writer.write("\n<h2>Parameters</h2>\n");
        if (parameters != null) {
            writer.write("<table>\n");
            for (Map.Entry entry : new TreeMap<String, String>(parameters).entrySet()) {
                String value = (String)entry.getValue();
                if ("org.apache.chemistry.opencmis.password".endsWith((String)entry.getKey())) {
                    value = "*****";
                }
                writer.write("<tr><td>" + this.escape((String)entry.getKey()) + "</td><td>" + this.escape(value) + "</td></tr>\n");
            }
            writer.write("</table>\n");
        }
        writer.write("\n<h2>Groups</h2>\n");
        if (groups != null) {
            for (CmisTestGroup cmisTestGroup : groups) {
                this.printGroupResults(cmisTestGroup, writer);
            }
        }
        writer.flush();
    }

    public static void printStyle(Writer writer) throws IOException {
        writer.write("<style type=\"text/css\">\n");
        writer.write("body { font-family: sans-serif; }\n");
        writer.write(".tckResultINFO { margin-left: 10px; margin-right: 10px; padding: 2px; }\n");
        writer.write(".tckResultSKIPPED { margin-left: 10px; margin-right: 10px; padding: 2px; background-color: #FFFFFF; }\n");
        writer.write(".tckResultOK { margin-left: 10px; margin-right: 5px; padding: 2px; background-color: #00FF00; }\n");
        writer.write(".tckResultWARNING { margin-left: 10px; margin-right: 10px; padding: 2px; background-color: #FFFF00; }\n");
        writer.write(".tckResultFAILURE { margin-left: 10px; margin-right: 10px; padding: 2px; background-color: #FF6000; }\n");
        writer.write(".tckResultUNEXPECTED_EXCEPTION { margin-left: 10px; margin-right: 10px; padding: 2px; background-color: #FF0000; }\n");
        writer.write(".tckTraceLink { cursor: pointer; text-decoration: underline; }\n");
        writer.write(".tckTrace { margin-left: 10px; margin-right: 10px; padding: 2px; border:2px solid #777777; background-color: #DDDDDD; }\n");
        writer.write("</style>\n");
    }

    public static void printJavaScript(Writer writer) throws IOException {
        writer.write("<script type=\"text/javascript\">\n");
        writer.write("function tckToggleDisplay(id) {\n");
        writer.write("(function(style) { style.display = style.display === 'none' ? '' : 'none'; })(document.getElementById(id).style);\n");
        writer.write("}\n");
        writer.write("</script>\n");
    }

    private void printGroupResults(CmisTestGroup group, Writer writer) throws IOException {
        if (!group.isEnabled()) {
            return;
        }
        writer.write("\n<hr>\n<h3>" + this.escape(group.getName()) + "</h3>\n");
        if (group.getDescription() != null) {
            writer.write("\n<p><i>" + this.escape(group.getDescription()) + "</i></p>\n");
        }
        if (group.getTests() != null) {
            for (CmisTest test : group.getTests()) {
                this.printTestResults(test, writer);
            }
        }
    }

    private void printTestResults(CmisTest test, Writer writer) throws IOException {
        if (!test.isEnabled()) {
            return;
        }
        writer.write("\n<h4>" + this.escape(test.getName()) + " (" + test.getTime() + " ms)</h4>\n");
        if (test.getDescription() != null) {
            writer.write("\n<p><i>" + this.escape(test.getDescription()) + "</i></p>\n");
        }
        if (test.getResults() != null) {
            for (CmisTestResult result : test.getResults()) {
                writer.write("<div style=\"padding: 5px;\">\n");
                this.printResult(result, writer);
                writer.write("</div>\n");
            }
        }
    }

    private void printResult(CmisTestResult result, Writer writer) throws IOException {
        ++this.stackTraceCounter;
        String stackTraceId = "tckTrace" + this.stackTraceCounter;
        String exceptionId = "tckException" + this.stackTraceCounter;
        boolean hasStackTrace = result.getStackTrace() != null && result.getStackTrace().length > 0;
        boolean hasException = result.getStatus() == CmisTestResultStatus.UNEXPECTED_EXCEPTION && result.getException() != null;
        writer.write("<div class=\"tckResult" + result.getStatus().name() + "\">\n");
        writer.write("<b>" + (Object)((Object)result.getStatus()) + "</b>: " + this.escape(result.getMessage()));
        if (hasStackTrace) {
            writer.write(" (" + this.getSourceCodeLink(result.getStackTrace()[0], this.revision) + ")");
            writer.write(" [<span class=\"tckTraceLink\" onClick=\"tckToggleDisplay('" + stackTraceId + "');\">stacktrace</span>]");
        }
        if (hasException) {
            writer.write(" [<span class=\"tckTraceLink\" onClick=\"tckToggleDisplay('" + exceptionId + "');\">exception details</span>]");
        }
        writer.write("<br/>\n");
        if (hasStackTrace) {
            writer.write("<div class=\"tckTrace\" id=\"" + stackTraceId + "\" style=\"display:none\">\n");
            for (StackTraceElement ste : result.getStackTrace()) {
                if (AbstractRunner.class.getName().equals(ste.getClassName())) break;
                writer.write(ste.getClassName() + "." + ste.getMethodName() + "(" + this.getSourceCodeLink(ste, this.revision) + ")<br/>\n");
            }
            writer.write("</div>\n");
        }
        if (hasException) {
            CmisBaseException cbe;
            writer.write("<div class=\"tckTrace\" id=\"" + exceptionId + "\" style=\"display:none\">\n");
            writer.write("<b>Exception stack trace:</b><br/><br/>\n");
            for (StackTraceElement ste : result.getException().getStackTrace()) {
                if (AbstractRunner.class.getName().equals(ste.getClassName())) break;
                writer.write(ste.getClassName() + "." + ste.getMethodName() + "(" + this.getSourceCodeLink(ste, this.revision) + ")<br/>\n");
            }
            if (result.getException() instanceof CmisBaseException && (cbe = (CmisBaseException)result.getException()).getErrorContent() != null) {
                writer.write("<br/>\n<b>Error content:</b><br/><br/><pre>\n");
                writer.write(this.escape(cbe.getErrorContent()) + "</pre>\n");
            }
            writer.write("</div>\n");
        }
        for (CmisTestResult child : result.getChildren()) {
            this.printResult(child, writer);
        }
        writer.write("</div>\n");
    }

    protected String getSourceCodeLink(StackTraceElement ste, String revision) {
        StringBuilder result = new StringBuilder(1024);
        if (!ste.getClassName().startsWith("org.apache.chemistry.opencmis.tck.")) {
            result.append(this.escape(ste.getFileName()));
            if (ste.getLineNumber() > 0) {
                result.append(':');
                result.append(ste.getLineNumber());
            }
        } else {
            result.append("<a href=\"https://svn.apache.org/viewvc/chemistry/opencmis/trunk/chemistry-opencmis-test/chemistry-opencmis-test-tck/src/main/java/");
            result.append(ste.getClassName().replaceAll("\\.", "/"));
            result.append(".java?view=markup");
            if (revision != null) {
                result.append("&revision=");
                result.append(revision);
            }
            if (ste.getLineNumber() > 0) {
                result.append("#l");
                result.append(ste.getLineNumber());
            }
            result.append("\" target=\"_blank\">");
            result.append(this.escape(ste.getFileName()));
            if (ste.getLineNumber() > 0) {
                result.append(':');
                result.append(ste.getLineNumber());
            }
            result.append("</a>");
        }
        return result.toString();
    }

    protected String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(s.length() + 32);
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

