/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.chemistry.opencmis.client.api.AsyncSession;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.async.AbstractExecutorServiceAsyncSession;
import org.apache.chemistry.opencmis.client.runtime.async.AsyncSessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class AsyncCreateAndDeleteDocumentTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Asynchronous Create and Delete Document Test");
        this.setDescription("Creates documents in parallel, checks the newly created documents and finally deletes the created documents in parallel.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        int numOfDocuments = 100;
        String mimeType = "text/plain";
        byte[] contentBytes = new byte[65536];
        for (int i = 0; i < contentBytes.length; ++i) {
            contentBytes[i] = (byte)(48 + i % 10);
        }
        AsyncSession asyncSession = AsyncSessionFactoryImpl.newInstance().createAsyncSession(session, 10);
        Folder testFolder = this.createTestFolder(session);
        try {
            ByteArrayOutputStream out;
            ArrayList<Future> docFutures = new ArrayList<Future>();
            for (int i = 0; i < numOfDocuments; ++i) {
                String name = "asyncdoc" + i + ".txt";
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("cmis:name", name);
                properties.put("cmis:objectTypeId", this.getDocumentTestTypeId());
                ContentStreamImpl contentStream = new ContentStreamImpl(name, BigInteger.valueOf(contentBytes.length), mimeType, (InputStream)new ByteArrayInputStream(contentBytes));
                Future newDocument = asyncSession.createDocument(properties, (ObjectId)testFolder, (ContentStream)contentStream, null);
                docFutures.add(newDocument);
            }
            ArrayList<ObjectId> docIds = new ArrayList<ObjectId>();
            try {
                for (Future docFuture : docFutures) {
                    ObjectId id = (ObjectId)docFuture.get();
                    docIds.add(id);
                }
            }
            catch (Exception e) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Documents could not been created! Exception: " + e.getMessage(), e, true));
            }
            int count = this.countChildren(testFolder);
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Test folder should have " + numOfDocuments + " children but has " + count + "!");
            this.addResult(this.assertEquals(count, numOfDocuments, null, (CmisTestResult)f));
            this.addResult(this.checkChildren(session, testFolder, "Test folder children check"));
            HashMap<String, Future> getObjectFutures = new HashMap<String, Future>();
            HashMap<String, Future> contentStreamFutures = new HashMap<String, Future>();
            HashMap<String, ByteArrayOutputStream> content = new HashMap<String, ByteArrayOutputStream>();
            for (ObjectId objectId : docIds) {
                Future getObjectFuture = asyncSession.getObject(objectId, SELECT_ALL_NO_CACHE_OC);
                getObjectFutures.put(objectId.getId(), getObjectFuture);
                out = new ByteArrayOutputStream(contentBytes.length);
                content.put(objectId.getId(), out);
                Future contentStreamFuture = asyncSession.storeContentStream(objectId, (OutputStream)out);
                contentStreamFutures.put(objectId.getId(), contentStreamFuture);
            }
            try {
                for (Map.Entry entry : getObjectFutures.entrySet()) {
                    CmisObject object = (CmisObject)((Future)entry.getValue()).get();
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Fetching document failed!");
                    this.addResult(this.assertIsTrue(object instanceof Document, null, f));
                    if (object == null) continue;
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Fetched wrong document!");
                    this.addResult(this.assertEquals(entry.getKey(), object.getId(), null, (CmisTestResult)f));
                }
            }
            catch (Exception e) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Documents could not been fetched! Exception: " + e.getMessage(), e, true));
            }
            try {
                for (Map.Entry entry : contentStreamFutures.entrySet()) {
                    ContentStream contentStream = (ContentStream)((Future)entry.getValue()).get();
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Fetching document content failed!");
                    this.addResult(this.assertNotNull(contentStream, null, f));
                    if (contentStream != null) {
                        if (contentStream.getMimeType() == null) {
                            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Content MIME type is null!"));
                        } else {
                            f = this.createResult(CmisTestResultStatus.WARNING, "Content MIME types don't match!");
                            this.addResult(this.assertIsTrue(contentStream.getMimeType().trim().toLowerCase(Locale.ENGLISH).startsWith(mimeType.toLowerCase(Locale.ENGLISH)), null, f));
                        }
                    }
                    out = (ByteArrayOutputStream)content.get(entry.getKey());
                    byte[] readBytes = out.toByteArray();
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Read content length doesn't match document content length!");
                    this.addResult(this.assertEquals(contentBytes.length, readBytes.length, null, (CmisTestResult)f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Read content doesn't match document content!");
                    this.addResult(this.assertEqualArray(contentBytes, readBytes, null, f));
                }
            }
            catch (Exception e) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Document content could not been fetched! Exception: " + e.getMessage(), e, true));
            }
            ArrayList<Future> delFutures = new ArrayList<Future>();
            for (ObjectId docId : docIds) {
                Future delFuture = asyncSession.delete(docId);
                delFutures.add(delFuture);
            }
            try {
                for (Future delFuture : delFutures) {
                    delFuture.get();
                }
            }
            catch (Exception exception) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Documents could not been deleted! Exception: " + exception.getMessage(), exception, true));
            }
            count = this.countChildren(testFolder);
            f = this.createResult(CmisTestResultStatus.FAILURE, "Test folder should be empty but has " + count + " children!");
            this.addResult(this.assertEquals(count, 0, null, (CmisTestResult)f));
        }
        finally {
            this.deleteTestFolder();
            if (asyncSession instanceof AbstractExecutorServiceAsyncSession) {
                ((AbstractExecutorServiceAsyncSession)asyncSession).shutdown();
            }
        }
        this.addResult(this.createInfoResult("Tested the parallel creation and deletion of " + numOfDocuments + " documents."));
    }

    private int countChildren(Folder folder) {
        int count = 0;
        ItemIterable children = folder.getChildren(SELECT_ALL_NO_CACHE_OC);
        for (CmisObject child : children) {
            if (!(child instanceof Document)) continue;
            ++count;
        }
        return count;
    }
}

