/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class BulkUpdatePropertiesTest
extends AbstractSessionTest {
    private static final String CONTENT = "Bluk update test content.";
    private static final String NEW_NAME = "bunewname.txt";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Bulk Update Properties Test");
        this.setDescription("Creates a few folders and documents, renames all documents at once, and deletes all created objects.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Bulk Update Properties is not supported by CMIS 1.0. Test skipped!"));
            return;
        }
        CmisTestResultImpl failure = null;
        int numOfObjects = 20;
        Folder testFolder = this.createTestFolder(session);
        try {
            HashMap<String, Folder> folders = new HashMap<String, Folder>();
            HashMap<String, Document> documents = new HashMap<String, Document>();
            for (int i = 0; i < numOfObjects; ++i) {
                Folder newFolder = this.createFolder(session, testFolder, "bufolder" + i);
                folders.put(newFolder.getId(), newFolder);
                Document newDocument = this.createDocument(session, newFolder, "budoc" + i + ".txt", CONTENT);
                documents.put(newDocument.getId(), newDocument);
            }
            ArrayList objects = new ArrayList(documents.values());
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cmis:name", NEW_NAME);
            List updatedIds = session.bulkUpdateProperties(objects, properties, null, null);
            if (this.getBinding() == BindingType.WEBSERVICES) {
                this.addResult(this.createResult(CmisTestResultStatus.INFO, "The Web Services binding does not return the updated ids. This issue has to be clarified by the CMIS TC and the test to adopted later."));
            } else if (updatedIds == null || updatedIds.isEmpty()) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Bulk Update Properties did not update any documents!"));
            } else {
                failure = this.createResult(CmisTestResultStatus.FAILURE, "Bulk Update Properties did not update all test documents!");
                this.addResult(this.assertEquals(documents.size(), updatedIds.size(), null, (CmisTestResult)failure));
            }
            for (Folder folder : folders.values()) {
                ArrayList<CmisObject> children = new ArrayList<CmisObject>();
                for (CmisObject child : folder.getChildren(SELECT_ALL_NO_CACHE_OC)) {
                    children.add(child);
                }
                if (children.size() != 1) {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Test folder should have exactly one child, but it has " + children.size() + "!"));
                    continue;
                }
                failure = this.createResult(CmisTestResultStatus.FAILURE, "Document does not have the new name! Id: " + ((CmisObject)children.get(0)).getId());
                this.addResult(this.assertEquals(NEW_NAME, ((CmisObject)children.get(0)).getName(), null, (CmisTestResult)failure));
            }
            for (Folder folder : folders.values()) {
                folder.deleteTree(true, null, true);
            }
        }
        finally {
            this.deleteTestFolder();
        }
    }
}

