/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class MoveTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Move Test");
        this.setDescription("Creates two folders and a document and moves the document from one folder to the other.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        try {
            Folder testFolder = this.createTestFolder(session);
            Folder folder1 = this.createFolder(session, testFolder, "movefolder1");
            Folder folder2 = this.createFolder(session, testFolder, "movefolder2");
            Document doc1 = this.createDocument(session, folder1, "movetestdoc.txt", "move test");
            Document doc2 = (Document)doc1.move((ObjectId)folder1, (ObjectId)folder2, SELECT_ALL_NO_CACHE_OC);
            if (doc2 == null) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Moved document is null!"));
            } else {
                this.addResult(this.checkObject(session, (CmisObject)doc2, this.getAllProperties((CmisObject)doc2), "Moved document check. Id: + " + doc2.getName()));
            }
            int count1 = this.countFolderChildren(folder1);
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Source folder should be empty after move but has " + count1 + " children!");
            this.addResult(this.assertEquals(0, count1, null, (CmisTestResult)f));
            int count2 = this.countFolderChildren(folder2);
            f = this.createResult(CmisTestResultStatus.FAILURE, "Target folder should have exactly one child but has " + count2 + " children!");
            this.addResult(this.assertEquals(1, count2, null, (CmisTestResult)f));
        }
        finally {
            this.deleteTestFolder();
        }
    }
}

