/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.TreeMap;
import java.util.function.IntPredicate;
import org.apache.commons.collections4.bloomfilter.IndexProducer;

@FunctionalInterface
public interface CellProducer
extends IndexProducer {
    public static CellProducer from(final IndexProducer producer) {
        return new CellProducer(){
            TreeMap<CounterCell, CounterCell> counterCells = new TreeMap();

            @Override
            public int[] asIndexArray() {
                this.populate();
                return this.counterCells.keySet().stream().mapToInt(c -> c.idx).toArray();
            }

            @Override
            public boolean forEachCell(CellConsumer consumer) {
                this.populate();
                for (CounterCell cell : this.counterCells.values()) {
                    if (consumer.test(cell.idx, cell.count)) continue;
                    return false;
                }
                return true;
            }

            private void populate() {
                if (this.counterCells.isEmpty()) {
                    producer.forEachIndex(idx -> {
                        CounterCell cell = new CounterCell(idx, 1);
                        CounterCell counter = this.counterCells.get(cell);
                        if (counter == null) {
                            this.counterCells.put(cell, cell);
                        } else {
                            ++counter.count;
                        }
                        return true;
                    });
                }
            }

            final class CounterCell
            implements Comparable<CounterCell> {
                final int idx;
                int count;

                CounterCell(int idx, int count) {
                    this.idx = idx;
                    this.count = count;
                }

                @Override
                public int compareTo(CounterCell other) {
                    return Integer.compare(this.idx, other.idx);
                }
            }
        };
    }

    public boolean forEachCell(CellConsumer var1);

    @Override
    default public boolean forEachIndex(IntPredicate predicate) {
        return this.forEachCell((i, v) -> predicate.test(i));
    }

    @Override
    default public IndexProducer uniqueIndices() {
        return this;
    }

    @FunctionalInterface
    public static interface CellConsumer {
        public boolean test(int var1, int var2);
    }
}

