/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.icc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.icc.IccTagDataType;
import org.apache.commons.imaging.util.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IccTagDataTypes implements IccTagDataType
{
    DESC_TYPE("descType", 1684370275){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(String prefix, byte[] bytes) throws ImageReadException, IOException {
            ByteArrayInputStream bis = null;
            boolean canThrow = false;
            try {
                bis = new ByteArrayInputStream(bytes);
                BinaryFunctions.read4Bytes("type_signature", bis, "ICC: corrupt tag data", ByteOrder.BIG_ENDIAN);
                BinaryFunctions.read4Bytes("ignore", bis, "ICC: corrupt tag data", ByteOrder.BIG_ENDIAN);
                int stringLength = BinaryFunctions.read4Bytes("stringLength", bis, "ICC: corrupt tag data", ByteOrder.BIG_ENDIAN);
                String s = new String(bytes, 12, stringLength - 1, "US-ASCII");
                System.out.println(prefix + "s: '" + s + "'");
                canThrow = true;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(canThrow, bis);
                throw throwable;
            }
            IoUtils.closeQuietly(canThrow, bis);
        }
    }
    ,
    DATA_TYPE("dataType", 1684108385){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(String prefix, byte[] bytes) throws ImageReadException, IOException {
            ByteArrayInputStream bis = null;
            boolean canThrow = false;
            try {
                bis = new ByteArrayInputStream(bytes);
                BinaryFunctions.read4Bytes("type_signature", bis, "ICC: corrupt tag data", ByteOrder.BIG_ENDIAN);
                canThrow = true;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(canThrow, bis);
                throw throwable;
            }
            IoUtils.closeQuietly(canThrow, bis);
        }
    }
    ,
    MULTI_LOCALIZED_UNICODE_TYPE("multiLocalizedUnicodeType", 1835824483){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(String prefix, byte[] bytes) throws ImageReadException, IOException {
            ByteArrayInputStream bis = null;
            boolean canThrow = false;
            try {
                bis = new ByteArrayInputStream(bytes);
                BinaryFunctions.read4Bytes("type_signature", bis, "ICC: corrupt tag data", ByteOrder.BIG_ENDIAN);
                canThrow = true;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(canThrow, bis);
                throw throwable;
            }
            IoUtils.closeQuietly(canThrow, bis);
        }
    }
    ,
    SIGNATURE_TYPE("signatureType", 1936287520){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(String prefix, byte[] bytes) throws ImageReadException, IOException {
            ByteArrayInputStream bis = null;
            boolean canThrow = false;
            try {
                bis = new ByteArrayInputStream(bytes);
                BinaryFunctions.read4Bytes("type_signature", bis, "ICC: corrupt tag data", ByteOrder.BIG_ENDIAN);
                BinaryFunctions.read4Bytes("ignore", bis, "ICC: corrupt tag data", ByteOrder.BIG_ENDIAN);
                int thesignature = BinaryFunctions.read4Bytes("thesignature ", bis, "ICC: corrupt tag data", ByteOrder.BIG_ENDIAN);
                System.out.println(prefix + "thesignature: " + Integer.toHexString(thesignature) + " (" + new String(new byte[]{(byte)(0xFF & thesignature >> 24), (byte)(0xFF & thesignature >> 16), (byte)(0xFF & thesignature >> 8), (byte)(0xFF & thesignature >> 0)}, "US-ASCII") + ")");
                canThrow = true;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(canThrow, bis);
                throw throwable;
            }
            IoUtils.closeQuietly(canThrow, bis);
        }
    }
    ,
    TEXT_TYPE("textType", 1952807028){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(String prefix, byte[] bytes) throws ImageReadException, IOException {
            ByteArrayInputStream bis = null;
            boolean canThrow = false;
            try {
                bis = new ByteArrayInputStream(bytes);
                BinaryFunctions.read4Bytes("type_signature", bis, "ICC: corrupt tag data", ByteOrder.BIG_ENDIAN);
                BinaryFunctions.read4Bytes("ignore", bis, "ICC: corrupt tag data", ByteOrder.BIG_ENDIAN);
                String s = new String(bytes, 8, bytes.length - 8, "US-ASCII");
                System.out.println(prefix + "s: '" + s + "'");
                canThrow = true;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(canThrow, bis);
                throw throwable;
            }
            IoUtils.closeQuietly(canThrow, bis);
        }
    };

    public final String name;
    public final int signature;

    private IccTagDataTypes(String name, int signature) {
        this.name = name;
        this.signature = signature;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSignature() {
        return this.signature;
    }
}

