/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.DebugInfo;
import org.apache.commons.jexl2.Debugger;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.ExpressionImpl;
import org.apache.commons.jexl2.Interpreter;
import org.apache.commons.jexl2.JexlArithmetic;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.JexlInfo;
import org.apache.commons.jexl2.JexlThreadedArithmetic;
import org.apache.commons.jexl2.Script;
import org.apache.commons.jexl2.UnifiedJEXL;
import org.apache.commons.jexl2.introspection.JexlMethod;
import org.apache.commons.jexl2.introspection.Uberspect;
import org.apache.commons.jexl2.introspection.UberspectImpl;
import org.apache.commons.jexl2.parser.ASTArrayAccess;
import org.apache.commons.jexl2.parser.ASTIdentifier;
import org.apache.commons.jexl2.parser.ASTJexlScript;
import org.apache.commons.jexl2.parser.ASTReference;
import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.ParseException;
import org.apache.commons.jexl2.parser.Parser;
import org.apache.commons.jexl2.parser.TokenMgrError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlEngine {
    public static final JexlContext EMPTY_CONTEXT = new JexlContext(){

        public Object get(String name) {
            return null;
        }

        public boolean has(String name) {
            return false;
        }

        public void set(String name, Object value) {
            throw new UnsupportedOperationException("Not supported in void context.");
        }
    };
    protected final Uberspect uberspect;
    protected final JexlArithmetic arithmetic;
    protected final Log logger;
    protected final Parser parser = new Parser(new StringReader(";"));
    protected volatile boolean silent = false;
    protected volatile boolean debug = true;
    private volatile boolean strict = false;
    protected Map<String, Object> functions = Collections.emptyMap();
    protected SoftCache<String, ASTJexlScript> cache = null;
    private static final float LOAD_FACTOR = 0.75f;

    public JexlEngine() {
        this(null, null, null, null);
    }

    public JexlEngine(Uberspect anUberspect, JexlArithmetic anArithmetic, Map<String, Object> theFunctions, Log log) {
        Uberspect uberspect = this.uberspect = anUberspect == null ? JexlEngine.getUberspect(log) : anUberspect;
        if (log == null) {
            log = LogFactory.getLog(JexlEngine.class);
        }
        this.logger = log;
        JexlArithmetic jexlArithmetic = this.arithmetic = anArithmetic == null ? new JexlArithmetic(true) : anArithmetic;
        if (theFunctions != null) {
            this.functions = theFunctions;
        }
        this.strict = !this.arithmetic.isLenient();
    }

    public static Uberspect getUberspect(Log logger) {
        if (logger == null || logger.equals(LogFactory.getLog(JexlEngine.class))) {
            return UberspectHolder.UBERSPECT;
        }
        return new UberspectImpl(logger);
    }

    public Uberspect getUberspect() {
        return this.uberspect;
    }

    public JexlArithmetic getArithmetic() {
        return this.arithmetic;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setSilent(boolean flag) {
        this.silent = flag;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setLenient(boolean flag) {
        boolean bl = this.strict = !flag;
        if (this.arithmetic instanceof JexlThreadedArithmetic) {
            JexlThreadedArithmetic.setLenient(flag);
        } else {
            this.arithmetic.setLenient(flag);
        }
    }

    public boolean isLenient() {
        return !this.strict;
    }

    public final void setStrict(boolean flag) {
        this.setLenient(!flag);
    }

    public final boolean isStrict() {
        return !this.isLenient();
    }

    public void setClassLoader(ClassLoader loader) {
        this.uberspect.setClassLoader(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(int size) {
        Parser parser = this.parser;
        synchronized (parser) {
            if (size <= 0) {
                this.cache = null;
            } else if (this.cache == null || this.cache.size() != size) {
                this.cache = new SoftCache(size);
            }
        }
    }

    public void setFunctions(Map<String, Object> funcs) {
        this.functions = funcs != null ? funcs : Collections.emptyMap();
    }

    public Map<String, Object> getFunctions() {
        return this.functions;
    }

    protected Expression createExpression(ASTJexlScript tree, String text) {
        return new ExpressionImpl(this, text, tree);
    }

    public Expression createExpression(String expression) {
        return this.createExpression(expression, null);
    }

    public Expression createExpression(String expression, JexlInfo info) {
        ASTJexlScript tree = this.parse(expression, info, null);
        if (tree.jjtGetNumChildren() > 1) {
            this.logger.warn((Object)("The JEXL Expression created will be a reference to the first expression from the supplied script: \"" + expression + "\" "));
        }
        return this.createExpression(tree, expression);
    }

    public Script createScript(String scriptText) {
        return this.createScript(scriptText, (JexlInfo)null, (String[])null);
    }

    @Deprecated
    public Script createScript(String scriptText, JexlInfo info) {
        if (scriptText == null) {
            throw new NullPointerException("scriptText is null");
        }
        ASTJexlScript tree = this.parse(scriptText, info);
        return this.createScript(tree, scriptText);
    }

    public Script createScript(String scriptText, String ... names) {
        return this.createScript(scriptText, (JexlInfo)null, names);
    }

    public Script createScript(String scriptText, JexlInfo info, String[] names) {
        if (scriptText == null) {
            throw new NullPointerException("scriptText is null");
        }
        ASTJexlScript tree = this.parse(scriptText, info, new Scope(names));
        return this.createScript(tree, scriptText);
    }

    protected Script createScript(ASTJexlScript tree, String text) {
        return new ExpressionImpl(this, text, tree);
    }

    public Script createScript(File scriptFile) throws IOException {
        if (scriptFile == null) {
            throw new NullPointerException("scriptFile is null");
        }
        if (!scriptFile.canRead()) {
            throw new IOException("Can't read scriptFile (" + scriptFile.getCanonicalPath() + ")");
        }
        BufferedReader reader = new BufferedReader(new FileReader(scriptFile));
        JexlInfo info = null;
        if (this.debug) {
            info = this.createInfo(scriptFile.getName(), 0, 0);
        }
        return this.createScript(JexlEngine.readerToString(reader), info, null);
    }

    public Script createScript(URL scriptUrl) throws IOException {
        if (scriptUrl == null) {
            throw new NullPointerException("scriptUrl is null");
        }
        URLConnection connection = scriptUrl.openConnection();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        JexlInfo info = null;
        if (this.debug) {
            info = this.createInfo(scriptUrl.toString(), 0, 0);
        }
        return this.createScript(JexlEngine.readerToString(reader), info, null);
    }

    public Object getProperty(Object bean, String expr) {
        return this.getProperty(null, bean, expr);
    }

    public Object getProperty(JexlContext context, Object bean, String expr) {
        if (context == null) {
            context = EMPTY_CONTEXT;
        }
        expr = "#0" + (expr.charAt(0) == '[' ? "" : ".") + expr + ";";
        try {
            this.parser.ALLOW_REGISTERS = true;
            Scope frame = new Scope("#0");
            ASTJexlScript script = this.parse(expr, null, frame);
            JexlNode node = script.jjtGetChild(0);
            Interpreter interpreter = this.createInterpreter(context);
            interpreter.setFrame(script.createFrame(bean));
            Object object = node.jjtAccept(interpreter, null);
            return object;
        }
        catch (JexlException xjexl) {
            if (this.silent) {
                this.logger.warn((Object)xjexl.getMessage(), xjexl.getCause());
                Object var5_7 = null;
                return var5_7;
            }
            throw xjexl;
        }
        finally {
            this.parser.ALLOW_REGISTERS = false;
        }
    }

    public void setProperty(Object bean, String expr, Object value) {
        this.setProperty(null, bean, expr, value);
    }

    public void setProperty(JexlContext context, Object bean, String expr, Object value) {
        if (context == null) {
            context = EMPTY_CONTEXT;
        }
        expr = "#0" + (expr.charAt(0) == '[' ? "" : ".") + expr + "=" + "#1" + ";";
        try {
            this.parser.ALLOW_REGISTERS = true;
            Scope frame = new Scope("#0", "#1");
            ASTJexlScript script = this.parse(expr, null, frame);
            JexlNode node = script.jjtGetChild(0);
            Interpreter interpreter = this.createInterpreter(context);
            interpreter.setFrame(script.createFrame(bean, value));
            node.jjtAccept(interpreter, null);
        }
        catch (JexlException xjexl) {
            if (this.silent) {
                this.logger.warn((Object)xjexl.getMessage(), xjexl.getCause());
                return;
            }
            throw xjexl;
        }
        finally {
            this.parser.ALLOW_REGISTERS = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(Object obj, String meth, Object ... args) {
        Object result;
        block9: {
            JexlException xjexl = null;
            result = null;
            JexlInfo info = this.debugInfo();
            try {
                JexlMethod method = this.uberspect.getMethod(obj, meth, args, info);
                if (method == null && this.arithmetic.narrowArguments(args)) {
                    method = this.uberspect.getMethod(obj, meth, args, info);
                }
                if (method != null) {
                    result = method.invoke(obj, args);
                } else {
                    xjexl = new JexlException(info, "failed finding method " + meth);
                }
            }
            catch (Exception xany) {
                xjexl = new JexlException(info, "failed executing method " + meth, (Throwable)xany);
                return xjexl;
            }
            finally {
                if (xjexl == null) break block9;
                if (this.silent) {
                    this.logger.warn((Object)xjexl.getMessage(), xjexl.getCause());
                    return null;
                }
                throw xjexl;
            }
        }
        return result;
    }

    public <T> T newInstance(Class<? extends T> clazz, Object ... args) {
        return clazz.cast(this.doCreateInstance(clazz, args));
    }

    public Object newInstance(String clazz, Object ... args) {
        return this.doCreateInstance(clazz, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doCreateInstance(Object clazz, Object ... args) {
        Object result;
        block9: {
            JexlException xjexl = null;
            result = null;
            JexlInfo info = this.debugInfo();
            try {
                JexlMethod ctor = this.uberspect.getConstructorMethod(clazz, args, info);
                if (ctor == null && this.arithmetic.narrowArguments(args)) {
                    ctor = this.uberspect.getConstructorMethod(clazz, args, info);
                }
                if (ctor != null) {
                    result = ctor.invoke(clazz, args);
                } else {
                    xjexl = new JexlException(info, "failed finding constructor for " + clazz.toString());
                }
            }
            catch (Exception xany) {
                xjexl = new JexlException(info, "failed executing constructor for " + clazz.toString(), (Throwable)xany);
                return xjexl;
            }
            finally {
                if (xjexl == null) break block9;
                if (this.silent) {
                    this.logger.warn((Object)xjexl.getMessage(), xjexl.getCause());
                    return null;
                }
                throw xjexl;
            }
        }
        return result;
    }

    protected Interpreter createInterpreter(JexlContext context) {
        return this.createInterpreter(context, this.isStrict(), this.isSilent());
    }

    protected Interpreter createInterpreter(JexlContext context, boolean strictFlag, boolean silentFlag) {
        return new Interpreter(this, context == null ? EMPTY_CONTEXT : context, strictFlag, silentFlag);
    }

    protected <K, V> Map<K, V> createCache(final int cacheSize) {
        return new LinkedHashMap<K, V>(cacheSize, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Parser parser = this.parser;
        synchronized (parser) {
            this.cache.clear();
        }
    }

    public Set<List<String>> getVariables(Script script) {
        if (script instanceof ExpressionImpl) {
            LinkedHashSet<List<String>> refs = new LinkedHashSet<List<String>>();
            this.getVariables(((ExpressionImpl)script).script, refs, null);
            return refs;
        }
        return Collections.emptySet();
    }

    protected void getVariables(JexlNode node, Set<List<String>> refs, List<String> ref) {
        boolean array = node instanceof ASTArrayAccess;
        boolean reference = node instanceof ASTReference;
        int num = node.jjtGetNumChildren();
        if (array || reference) {
            ArrayList<String> var = ref != null ? ref : new ArrayList<String>();
            boolean varf = true;
            for (int i = 0; i < num; ++i) {
                JexlNode child = node.jjtGetChild(i);
                if (array) {
                    if (child instanceof ASTReference && child.jjtGetNumChildren() == 1) {
                        JexlNode desc = child.jjtGetChild(0);
                        if (varf && desc.isConstant()) {
                            String image = desc.image;
                            if (image == null) {
                                var.add(new Debugger().data(desc));
                                continue;
                            }
                            var.add(image);
                            continue;
                        }
                        if (!(desc instanceof ASTIdentifier)) continue;
                        if (((ASTIdentifier)desc).getRegister() < 0) {
                            ArrayList<String> di = new ArrayList<String>(1);
                            di.add(desc.image);
                            refs.add(di);
                        }
                        var = new ArrayList();
                        varf = false;
                        continue;
                    }
                    if (child instanceof ASTIdentifier) {
                        if (i != 0 || ((ASTIdentifier)child).getRegister() >= 0) continue;
                        var.add(child.image);
                        continue;
                    }
                } else if (child instanceof ASTIdentifier) {
                    if (((ASTIdentifier)child).getRegister() >= 0) continue;
                    var.add(child.image);
                    continue;
                }
                this.getVariables(child, refs, var);
            }
            if (!var.isEmpty() && var != ref) {
                refs.add(var);
            }
        } else {
            for (int i = 0; i < num; ++i) {
                this.getVariables(node.jjtGetChild(i), refs, null);
            }
        }
    }

    protected String[] getParameters(Script script) {
        if (script instanceof ExpressionImpl) {
            return ((ExpressionImpl)script).getParameters();
        }
        return new String[0];
    }

    protected String[] getLocalVariables(Script script) {
        if (script instanceof ExpressionImpl) {
            return ((ExpressionImpl)script).getLocalVariables();
        }
        return new String[0];
    }

    @Deprecated
    protected ASTJexlScript parse(CharSequence expression, JexlInfo info) {
        return this.parse(expression, info, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ASTJexlScript parse(CharSequence expression, JexlInfo info, Scope frame) {
        String expr = JexlEngine.cleanExpression(expression);
        ASTJexlScript script = null;
        JexlInfo dbgInfo = null;
        Parser parser = this.parser;
        synchronized (parser) {
            Scope f;
            if (this.cache != null && (script = this.cache.get(expr)) != null && ((f = script.getScope()) == null && frame == null || f != null && f.equals(frame))) {
                return script;
            }
            try {
                StringReader reader = new StringReader(expr);
                dbgInfo = info == null ? this.debugInfo() : info.debugInfo();
                this.parser.setFrame(frame);
                script = this.parser.parse(reader, dbgInfo);
                frame = this.parser.getFrame();
                if (frame != null) {
                    script.setScope(frame);
                }
                if (this.cache != null) {
                    this.cache.put(expr, script);
                }
            }
            catch (TokenMgrError xtme) {
                throw new JexlException.Tokenization(dbgInfo, expression, xtme);
            }
            catch (ParseException xparse) {
                throw new JexlException.Parsing(dbgInfo, expression, xparse);
            }
            finally {
                this.parser.setFrame(null);
            }
        }
        return script;
    }

    protected JexlInfo createInfo(String fn, int l, int c) {
        return new DebugInfo(fn, l, c);
    }

    protected JexlInfo debugInfo() {
        DebugInfo info = null;
        if (this.debug) {
            Throwable xinfo = new Throwable();
            xinfo.fillInStackTrace();
            StackTraceElement[] stack = xinfo.getStackTrace();
            StackTraceElement se = null;
            Class<Object> clazz = this.getClass();
            for (int s = 1; s < stack.length; ++s) {
                se = stack[s];
                String className = se.getClassName();
                if (!className.equals(clazz.getName())) {
                    if (className.equals(JexlEngine.class.getName())) {
                        clazz = JexlEngine.class;
                    } else {
                        if (!className.equals(UnifiedJEXL.class.getName())) break;
                        clazz = UnifiedJEXL.class;
                    }
                }
                se = null;
            }
            if (se != null) {
                info = this.createInfo(se.getClassName() + "." + se.getMethodName(), se.getLineNumber(), 0).debugInfo();
            }
        }
        return info;
    }

    public static String cleanExpression(CharSequence str) {
        if (str != null) {
            int end = str.length();
            if (end > 0) {
                int start;
                for (start = 0; start < end && str.charAt(start) == ' '; ++start) {
                }
                while (end > 0 && str.charAt(end - 1) == ' ') {
                    --end;
                }
                return ((Object)str.subSequence(start, end)).toString();
            }
            return "";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readerToString(Reader scriptReader) throws IOException {
        StringBuilder buffer = new StringBuilder();
        BufferedReader reader = scriptReader instanceof BufferedReader ? (BufferedReader)scriptReader : new BufferedReader(scriptReader);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append('\n');
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException xio) {}
        }
    }

    public static final class Frame {
        private Object[] registers = null;
        private String[] parameters = null;

        Frame(Object[] r, String[] p) {
            this.registers = r;
            this.parameters = p;
        }

        public Object[] getRegisters() {
            return this.registers;
        }

        public String[] getParameters() {
            return this.parameters;
        }
    }

    public static final class Scope {
        private final int parms;
        private Map<String, Integer> namedRegisters = null;

        public Scope(String ... parameters) {
            if (parameters != null) {
                this.parms = parameters.length;
                this.namedRegisters = new LinkedHashMap<String, Integer>();
                for (int p = 0; p < this.parms; ++p) {
                    this.namedRegisters.put(parameters[p], p);
                }
            } else {
                this.parms = 0;
            }
        }

        public int hashCode() {
            return this.namedRegisters == null ? 0 : this.parms ^ ((Object)this.namedRegisters).hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Scope && this.equals((Scope)o);
        }

        public boolean equals(Scope frame) {
            if (this == frame) {
                return true;
            }
            if (frame == null || this.parms != frame.parms) {
                return false;
            }
            if (this.namedRegisters == null) {
                return frame.namedRegisters == null;
            }
            return ((Object)this.namedRegisters).equals(frame.namedRegisters);
        }

        public Integer getRegister(String name) {
            return this.namedRegisters != null ? this.namedRegisters.get(name) : null;
        }

        public Integer declareVariable(String name) {
            Integer register;
            if (this.namedRegisters == null) {
                this.namedRegisters = new LinkedHashMap<String, Integer>();
            }
            if ((register = this.namedRegisters.get(name)) == null) {
                register = this.namedRegisters.size();
                this.namedRegisters.put(name, register);
            }
            return register;
        }

        public Frame createFrame(Object ... values) {
            if (this.namedRegisters != null) {
                Object[] arguments = new Object[this.namedRegisters.size()];
                if (values != null) {
                    System.arraycopy(values, 0, arguments, 0, Math.min(this.parms, values.length));
                }
                return new Frame(arguments, this.namedRegisters.keySet().toArray(new String[0]));
            }
            return null;
        }

        public int getArgCount() {
            return this.parms;
        }

        public String[] getRegisters() {
            return this.namedRegisters != null ? this.namedRegisters.keySet().toArray(new String[0]) : new String[]{};
        }

        public String[] getParameters() {
            if (this.namedRegisters != null && this.parms > 0) {
                String[] pa = new String[this.parms];
                int p = 0;
                for (Map.Entry<String, Integer> entry : this.namedRegisters.entrySet()) {
                    if (entry.getValue() >= this.parms) continue;
                    pa[p++] = entry.getKey();
                }
                return pa;
            }
            return null;
        }

        public String[] getLocalVariables() {
            if (this.namedRegisters != null && this.parms > 0) {
                String[] pa = new String[this.parms];
                int p = 0;
                for (Map.Entry<String, Integer> entry : this.namedRegisters.entrySet()) {
                    if (entry.getValue() < this.parms) continue;
                    pa[p++] = entry.getKey();
                }
                return pa;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SoftCache<K, V> {
        private final int size;
        private SoftReference<Map<K, V>> ref = null;

        SoftCache(int theSize) {
            this.size = theSize;
        }

        int size() {
            return this.size;
        }

        void clear() {
            this.ref = null;
        }

        Set<Map.Entry<K, V>> entrySet() {
            Map<K, V> map = this.ref != null ? this.ref.get() : null;
            return map != null ? map.entrySet() : Collections.emptySet();
        }

        V get(K key) {
            Map<K, V> map = this.ref != null ? this.ref.get() : null;
            return map != null ? (V)map.get(key) : null;
        }

        void put(K key, V script) {
            Map<K, V> map;
            Map<K, V> map2 = map = this.ref != null ? this.ref.get() : null;
            if (map == null) {
                map = JexlEngine.this.createCache(this.size);
                this.ref = new SoftReference<Map<K, V>>(map);
            }
            map.put(key, script);
        }
    }

    private static final class UberspectHolder {
        private static final Uberspect UBERSPECT = new UberspectImpl(LogFactory.getLog(JexlEngine.class));

        private UberspectHolder() {
        }
    }
}

