/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

public enum DigitalBase10SizeUnit {
    BITS("b", "bit"){

        @Override
        public long convert(long s, DigitalBase10SizeUnit u) {
            return u.toBytes(s);
        }

        @Override
        public long toBits(long size) {
            return size;
        }

        @Override
        public long toBytes(long size) {
            return size / 1000L;
        }

        @Override
        public long toGigabytes(long size) {
            return size / 1000000000000L;
        }

        @Override
        public long toKilobytes(long size) {
            return size / 1000000L;
        }

        @Override
        public long toMegabytes(long size) {
            return size / 1000000000L;
        }

        @Override
        public long toTerabytes(long size) {
            return size / 1000000000000000L;
        }
    }
    ,
    BYTES("B", "byte"){

        @Override
        public long convert(long s, DigitalBase10SizeUnit u) {
            return u.toBytes(s);
        }

        @Override
        public long toBits(long size) {
            return DigitalBase10SizeUnit.x(size, 8L, 9223372036854775L);
        }

        @Override
        public long toBytes(long size) {
            return size;
        }

        @Override
        public long toGigabytes(long size) {
            return size / 1000000000L;
        }

        @Override
        public long toKilobytes(long size) {
            return size / 1000L;
        }

        @Override
        public long toMegabytes(long size) {
            return size / 1000000L;
        }

        @Override
        public long toTerabytes(long size) {
            return size / 1000000000000L;
        }
    }
    ,
    GIGABYTES("gigabyte", "G"){

        @Override
        public long convert(long s, DigitalBase10SizeUnit u) {
            return u.toGigabytes(s);
        }

        @Override
        public long toBits(long size) {
            return DigitalBase10SizeUnit.x(size, 1000000000L, 9223372036854L);
        }

        @Override
        public long toBytes(long size) {
            return DigitalBase10SizeUnit.x(size, 1000000000L, 9223372036L);
        }

        @Override
        public long toGigabytes(long size) {
            return size;
        }

        @Override
        public long toKilobytes(long size) {
            return DigitalBase10SizeUnit.x(size, 1000000L, 9223372036854L);
        }

        @Override
        public long toMegabytes(long size) {
            return DigitalBase10SizeUnit.x(size, 1000L, 9223372036854775L);
        }

        @Override
        public long toTerabytes(long size) {
            return size / 1000L;
        }
    }
    ,
    KILOBYTES("kilobytes", "K"){

        @Override
        public long convert(long s, DigitalBase10SizeUnit u) {
            return u.toKilobytes(s);
        }

        @Override
        public long toBits(long size) {
            return DigitalBase10SizeUnit.x(size, 1000L, 9223372036854775L);
        }

        @Override
        public long toBytes(long size) {
            return DigitalBase10SizeUnit.x(size, 1000L, 9223372036854775L);
        }

        @Override
        public long toGigabytes(long size) {
            return size / 1000000L;
        }

        @Override
        public long toKilobytes(long size) {
            return size;
        }

        @Override
        public long toMegabytes(long size) {
            return size / 1000L;
        }

        @Override
        public long toTerabytes(long size) {
            return size / 1000000000L;
        }
    }
    ,
    MEGABYTES("megabytes", "M"){

        @Override
        public long convert(long s, DigitalBase10SizeUnit u) {
            return u.toMegabytes(s);
        }

        @Override
        public long toBits(long size) {
            return DigitalBase10SizeUnit.x(size, 1000000L, 9223372036854775L);
        }

        @Override
        public long toBytes(long size) {
            return DigitalBase10SizeUnit.x(size, 1000000L, 9223372036854L);
        }

        @Override
        public long toGigabytes(long size) {
            return size / 1000L;
        }

        @Override
        public long toKilobytes(long size) {
            return DigitalBase10SizeUnit.x(size, 1000L, 9223372036854775L);
        }

        @Override
        public long toMegabytes(long size) {
            return size;
        }

        @Override
        public long toTerabytes(long size) {
            return size / 1000000L;
        }
    }
    ,
    TERABYTES("terabyte", "T"){

        @Override
        public long convert(long s, DigitalBase10SizeUnit u) {
            return u.toTerabytes(s);
        }

        @Override
        public long toBits(long size) {
            return DigitalBase10SizeUnit.x(size, 1000000000000L, 9223372036L);
        }

        @Override
        public long toBytes(long size) {
            return DigitalBase10SizeUnit.x(size, 1000000000000L, 0x8CBCCCL);
        }

        @Override
        public long toGigabytes(long size) {
            return DigitalBase10SizeUnit.x(size, 1000L, 9223372036854775L);
        }

        @Override
        public long toKilobytes(long size) {
            return DigitalBase10SizeUnit.x(size, 1000000000L, 9223372036L);
        }

        @Override
        public long toMegabytes(long size) {
            return DigitalBase10SizeUnit.x(size, 1000000L, 9223372036854L);
        }

        @Override
        public long toTerabytes(long size) {
            return size;
        }
    };

    private static final long MULB = 8L;
    private static final long MULK = 1000L;
    private static final long K0 = 1L;
    private static final long K1 = 1000L;
    private static final long K2 = 1000000L;
    private static final long K3 = 1000000000L;
    private static final long K4 = 1000000000000L;
    private static final long K5 = 1000000000000000L;
    private final String name;
    private final String symbol;

    private static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    private DigitalBase10SizeUnit(String symbol, String name) {
        this.name = symbol;
        this.symbol = name;
    }

    protected abstract long convert(long var1, DigitalBase10SizeUnit var3);

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public abstract long toBits(long var1);

    public abstract long toBytes(long var1);

    public abstract long toGigabytes(long var1);

    public abstract long toKilobytes(long var1);

    public abstract long toMegabytes(long var1);

    public abstract long toTerabytes(long var1);
}

