/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

public enum DigitalBase2SizeUnit {
    BITS("b", "bit"){

        @Override
        public long convert(long s, DigitalBase2SizeUnit u) {
            return u.toBytes(s);
        }

        @Override
        public long toBits(long size) {
            return size;
        }

        @Override
        public long toBytes(long size) {
            return size / 1024L;
        }

        @Override
        public long toGigabytes(long size) {
            return size / 0x10000000000L;
        }

        @Override
        public long toKilobytes(long size) {
            return size / 0x100000L;
        }

        @Override
        public long toMegabytes(long size) {
            return size / 0x40000000L;
        }

        @Override
        public long toTerabytes(long size) {
            return size / 0x4000000000000L;
        }
    }
    ,
    BYTES("B", "byte"){

        @Override
        public long convert(long s, DigitalBase2SizeUnit u) {
            return u.toBytes(s);
        }

        @Override
        public long toBits(long size) {
            return DigitalBase2SizeUnit.x(size, 8L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long size) {
            return size;
        }

        @Override
        public long toGigabytes(long size) {
            return size / 0x40000000L;
        }

        @Override
        public long toKilobytes(long size) {
            return size / 1024L;
        }

        @Override
        public long toMegabytes(long size) {
            return size / 0x100000L;
        }

        @Override
        public long toTerabytes(long size) {
            return size / 0x10000000000L;
        }
    }
    ,
    GIGABYTES("Gi", "gibibyte", "gigabyte", "G"){

        @Override
        public long convert(long s, DigitalBase2SizeUnit u) {
            return u.toGigabytes(s);
        }

        @Override
        public long toBits(long size) {
            return DigitalBase2SizeUnit.x(size, 0x40000000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toBytes(long size) {
            return DigitalBase2SizeUnit.x(size, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toGigabytes(long size) {
            return size;
        }

        @Override
        public long toKilobytes(long size) {
            return DigitalBase2SizeUnit.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMegabytes(long size) {
            return DigitalBase2SizeUnit.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toTerabytes(long size) {
            return size / 1024L;
        }
    }
    ,
    KILOBYTES("Ki", "kibibyte", "kilobytes", "K"){

        @Override
        public long convert(long s, DigitalBase2SizeUnit u) {
            return u.toKilobytes(s);
        }

        @Override
        public long toBits(long size) {
            return DigitalBase2SizeUnit.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long size) {
            return DigitalBase2SizeUnit.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGigabytes(long size) {
            return size / 0x100000L;
        }

        @Override
        public long toKilobytes(long size) {
            return size;
        }

        @Override
        public long toMegabytes(long size) {
            return size / 1024L;
        }

        @Override
        public long toTerabytes(long size) {
            return size / 0x40000000L;
        }
    }
    ,
    MEGABYTES("Mi", "mebibyte", "megabytes", "M"){

        @Override
        public long convert(long s, DigitalBase2SizeUnit u) {
            return u.toMegabytes(s);
        }

        @Override
        public long toBits(long size) {
            return DigitalBase2SizeUnit.x(size, 0x100000L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long size) {
            return DigitalBase2SizeUnit.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toGigabytes(long size) {
            return size / 1024L;
        }

        @Override
        public long toKilobytes(long size) {
            return DigitalBase2SizeUnit.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMegabytes(long size) {
            return size;
        }

        @Override
        public long toTerabytes(long size) {
            return size / 0x100000L;
        }
    }
    ,
    TERABYTES("Ti", "tebibyte", "terabyte", "T"){

        @Override
        public long convert(long s, DigitalBase2SizeUnit u) {
            return u.toTerabytes(s);
        }

        @Override
        public long toBits(long size) {
            return DigitalBase2SizeUnit.x(size, 0x10000000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toBytes(long size) {
            return DigitalBase2SizeUnit.x(size, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toGigabytes(long size) {
            return DigitalBase2SizeUnit.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKilobytes(long size) {
            return DigitalBase2SizeUnit.x(size, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toMegabytes(long size) {
            return DigitalBase2SizeUnit.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toTerabytes(long size) {
            return size;
        }
    };

    private static final long MULB = 8L;
    private static final long MULK = 1024L;
    private static final long K0 = 1L;
    private static final long K1 = 1024L;
    private static final long K2 = 0x100000L;
    private static final long K3 = 0x40000000L;
    private static final long K4 = 0x10000000000L;
    private static final long K5 = 0x4000000000000L;
    private final String name;
    private final String symbol;
    private final String customarySymbol;
    private final String customaryName;

    private static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    private DigitalBase2SizeUnit(String iecSymbol, String iecName) {
        this.name = iecName;
        this.symbol = iecName;
        this.customarySymbol = iecSymbol;
        this.customaryName = iecName;
    }

    private DigitalBase2SizeUnit(String iecSymbol, String iecName, String customarySymbol, String customaryName) {
        this.name = iecName;
        this.symbol = iecName;
        this.customarySymbol = customarySymbol;
        this.customaryName = customaryName;
    }

    protected abstract long convert(long var1, DigitalBase2SizeUnit var3);

    public String getCustomaryName() {
        return this.customaryName;
    }

    public String getCustomarySymbol() {
        return this.customarySymbol;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public abstract long toBits(long var1);

    public abstract long toBytes(long var1);

    public abstract long toGigabytes(long var1);

    public abstract long toKilobytes(long var1);

    public abstract long toMegabytes(long var1);

    public abstract long toTerabytes(long var1);
}

