/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.arch.Processor;

public class ArchUtils {
    private static final Map<String, Processor> ARCH_TO_PROCESSOR = new HashMap<String, Processor>();

    private static final void init() {
        ArchUtils.init_X86_32Bit();
        ArchUtils.init_X86_64Bit();
        ArchUtils.init_IA64_32Bit();
        ArchUtils.init_IA64_64Bit();
        ArchUtils.init_PPC_32Bit();
        ArchUtils.init_PPC_64Bit();
    }

    private static final void init_X86_32Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_32, Processor.Type.X86);
        ArchUtils.addProcessors(processor, "x86", "i386", "i486", "i586", "i686", "pentium");
    }

    private static final void init_X86_64Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_64, Processor.Type.X86);
        ArchUtils.addProcessors(processor, "x86_64", "amd64", "em64t", "universal");
    }

    private static final void init_IA64_32Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_32, Processor.Type.IA_64);
        ArchUtils.addProcessors(processor, "ia64_32", "ia64n");
    }

    private static final void init_IA64_64Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_64, Processor.Type.IA_64);
        ArchUtils.addProcessors(processor, "ia64", "ia64w");
    }

    private static final void init_PPC_32Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_32, Processor.Type.PPC);
        ArchUtils.addProcessors(processor, "ppc", "power", "powerpc", "power_pc", "power_rs");
    }

    private static final void init_PPC_64Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_64, Processor.Type.PPC);
        ArchUtils.addProcessors(processor, "ppc64", "power64", "powerpc64", "power_pc64", "power_rs64");
    }

    private static final void addProcessor(String key, Processor processor) throws IllegalStateException {
        if (ARCH_TO_PROCESSOR.containsKey(key)) {
            String msg = "Key " + key + " already exists in processor map";
            throw new IllegalStateException(msg);
        }
        ARCH_TO_PROCESSOR.put(key, processor);
    }

    private static final void addProcessors(Processor processor, String ... keys) throws IllegalStateException {
        for (String key : keys) {
            ArchUtils.addProcessor(key, processor);
        }
    }

    public static final Processor getProcessor() {
        return ArchUtils.getProcessor(SystemUtils.OS_ARCH);
    }

    public static final Processor getProcessor(String value) {
        return ARCH_TO_PROCESSOR.get(value);
    }

    static {
        ArchUtils.init();
    }
}

