/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.correlation;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.apache.commons.math3.stat.correlation.StorelessBivariateCovariance;

public class StorelessCovariance
extends Covariance {
    private StorelessBivariateCovariance[][] covMatrix;
    private int rowDimension;
    private int colDimension;
    private boolean biasCorrected;

    public StorelessCovariance(int rows, int cols) {
        this(rows, cols, true);
    }

    public StorelessCovariance(int rows, int cols, boolean biasCorrection) {
        this.rowDimension = rows;
        this.colDimension = cols;
        this.biasCorrected = biasCorrection;
        this.covMatrix = new StorelessBivariateCovariance[this.rowDimension][this.colDimension];
        this.initializeMatrix();
    }

    private void initializeMatrix() {
        for (int i = 0; i < this.rowDimension; ++i) {
            for (int j = 0; j < this.colDimension; ++j) {
                this.covMatrix[i][j] = new StorelessBivariateCovariance(this.biasCorrected);
            }
        }
    }

    public StorelessBivariateCovariance getCovariance(int xIndex, int yIndex) {
        return this.covMatrix[xIndex][yIndex];
    }

    public void setCovariance(int xIndex, int yIndex, StorelessBivariateCovariance cov) {
        this.covMatrix[xIndex][yIndex] = cov;
    }

    public void incrementCovariance(int xIndex, int yIndex, double x, double y) {
        this.covMatrix[xIndex][yIndex].increment(x, y);
    }

    public void incrementRow(double[] rowData) throws DimensionMismatchException {
        int length = rowData.length;
        if (length != this.colDimension) {
            throw new DimensionMismatchException(length, this.colDimension);
        }
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                this.covMatrix[i][j].increment(rowData[i], rowData[j]);
            }
        }
    }

    public RealMatrix getCovarianceMatrix() throws NumberIsTooSmallException {
        return MatrixUtils.createRealMatrix(this.getData());
    }

    public double[][] getData() throws NumberIsTooSmallException {
        double[][] data = new double[this.rowDimension][this.rowDimension];
        for (int i = 0; i < this.rowDimension; ++i) {
            for (int j = 0; j < this.colDimension; ++j) {
                data[i][j] = this.covMatrix[i][j].getResult();
            }
        }
        return data;
    }

    public int getN() throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }
}

