/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import org.apache.commons.math4.distribution.MultivariateRealDistribution;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.random.RandomGenerator;

public abstract class AbstractMultivariateRealDistribution
implements MultivariateRealDistribution {
    protected final RandomGenerator random;
    private final int dimension;

    protected AbstractMultivariateRealDistribution(RandomGenerator rng, int n) {
        this.random = rng;
        this.dimension = n;
    }

    @Override
    public void reseedRandomGenerator(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public abstract double[] sample();

    @Override
    public double[][] sample(int sampleSize) {
        if (sampleSize <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, sampleSize);
        }
        double[][] out = new double[sampleSize][this.dimension];
        for (int i = 0; i < sampleSize; ++i) {
            out[i] = this.sample();
        }
        return out;
    }
}

