/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import org.apache.commons.math4.distribution.AbstractIntegerDistribution;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.random.RandomGenerator;
import org.apache.commons.math4.random.Well19937c;
import org.apache.commons.math4.util.FastMath;

public class GeometricDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20130507L;
    private final double probabilityOfSuccess;

    public GeometricDistribution(double p) {
        this(new Well19937c(), p);
    }

    public GeometricDistribution(RandomGenerator rng, double p) {
        super(rng);
        if (p <= 0.0 || p > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE_LEFT, (Number)p, 0, 1);
        }
        this.probabilityOfSuccess = p;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int x) {
        double ret;
        if (x < 0) {
            ret = 0.0;
        } else {
            double p = this.probabilityOfSuccess;
            ret = FastMath.pow(1.0 - p, x) * p;
        }
        return ret;
    }

    @Override
    public double logProbability(int x) {
        double ret;
        if (x < 0) {
            ret = Double.NEGATIVE_INFINITY;
        } else {
            double p = this.probabilityOfSuccess;
            ret = (double)x * FastMath.log1p(-p) + FastMath.log(p);
        }
        return ret;
    }

    @Override
    public double cumulativeProbability(int x) {
        double ret;
        if (x < 0) {
            ret = 0.0;
        } else {
            double p = this.probabilityOfSuccess;
            ret = 1.0 - FastMath.pow(1.0 - p, x + 1);
        }
        return ret;
    }

    @Override
    public double getNumericalMean() {
        double p = this.probabilityOfSuccess;
        return (1.0 - p) / p;
    }

    @Override
    public double getNumericalVariance() {
        double p = this.probabilityOfSuccess;
        return (1.0 - p) / (p * p);
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

