/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import org.apache.commons.math4.distribution.AbstractIntegerDistribution;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.random.RandomGenerator;
import org.apache.commons.math4.random.Well19937c;
import org.apache.commons.math4.util.FastMath;

public class ZipfDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20150501L;
    private final int numberOfElements;
    private final double exponent;
    private final double nthHarmonic;
    private double numericalMean = Double.NaN;
    private boolean numericalMeanIsCalculated = false;
    private double numericalVariance = Double.NaN;
    private boolean numericalVarianceIsCalculated = false;
    private transient ZipfRejectionSampler sampler;

    public ZipfDistribution(int numberOfElements, double exponent) {
        this(new Well19937c(), numberOfElements, exponent);
    }

    public ZipfDistribution(RandomGenerator rng, int numberOfElements, double exponent) throws NotStrictlyPositiveException {
        super(rng);
        if (numberOfElements <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, numberOfElements);
        }
        if (exponent <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.EXPONENT, exponent);
        }
        this.numberOfElements = numberOfElements;
        this.exponent = exponent;
        this.nthHarmonic = this.generalizedHarmonic(numberOfElements, exponent);
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public double getExponent() {
        return this.exponent;
    }

    @Override
    public double probability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return 0.0;
        }
        return 1.0 / FastMath.pow((double)x, this.exponent) / this.nthHarmonic;
    }

    @Override
    public double logProbability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return Double.NEGATIVE_INFINITY;
        }
        return -FastMath.log(x) * this.exponent - FastMath.log(this.nthHarmonic);
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x <= 0) {
            return 0.0;
        }
        if (x >= this.numberOfElements) {
            return 1.0;
        }
        return this.generalizedHarmonic(x, this.exponent) / this.nthHarmonic;
    }

    @Override
    public double getNumericalMean() {
        if (!this.numericalMeanIsCalculated) {
            this.numericalMean = this.calculateNumericalMean();
            this.numericalMeanIsCalculated = true;
        }
        return this.numericalMean;
    }

    protected double calculateNumericalMean() {
        int N = this.getNumberOfElements();
        double s = this.getExponent();
        double Hs1 = this.generalizedHarmonic(N, s - 1.0);
        double Hs = this.nthHarmonic;
        return Hs1 / Hs;
    }

    @Override
    public double getNumericalVariance() {
        if (!this.numericalVarianceIsCalculated) {
            this.numericalVariance = this.calculateNumericalVariance();
            this.numericalVarianceIsCalculated = true;
        }
        return this.numericalVariance;
    }

    protected double calculateNumericalVariance() {
        int N = this.getNumberOfElements();
        double s = this.getExponent();
        double Hs2 = this.generalizedHarmonic(N, s - 2.0);
        double Hs1 = this.generalizedHarmonic(N, s - 1.0);
        double Hs = this.nthHarmonic;
        return Hs2 / Hs - Hs1 * Hs1 / (Hs * Hs);
    }

    private double generalizedHarmonic(int n, double m) {
        double value = 0.0;
        for (int k = n; k > 0; --k) {
            value += 1.0 / FastMath.pow((double)k, m);
        }
        return value;
    }

    @Override
    public int getSupportLowerBound() {
        return 1;
    }

    @Override
    public int getSupportUpperBound() {
        return this.getNumberOfElements();
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public int sample() {
        if (this.sampler == null) {
            this.sampler = new ZipfRejectionSampler(this.numberOfElements, this.exponent);
        }
        return this.sampler.sample(this.random);
    }

    static final class ZipfRejectionSampler {
        private final int numberOfElements;
        private final double exponent;
        private double instrumentalDistributionTailWeight = Double.NaN;

        ZipfRejectionSampler(int numberOfElements, double exponent) {
            this.numberOfElements = numberOfElements;
            this.exponent = exponent;
        }

        int sample(RandomGenerator random) {
            double randomValue;
            if (Double.isNaN(this.instrumentalDistributionTailWeight)) {
                this.instrumentalDistributionTailWeight = ZipfRejectionSampler.integratePowerFunction(-this.exponent, 1.5, (double)this.numberOfElements + 0.5);
            }
            while ((randomValue = random.nextDouble() * (this.instrumentalDistributionTailWeight + 1.0)) < this.instrumentalDistributionTailWeight) {
                double q = randomValue / this.instrumentalDistributionTailWeight;
                int sample = this.sampleFromInstrumentalDistributionTail(q);
                if (!(random.nextDouble() < this.acceptanceRateForTailSample(sample))) continue;
                return sample;
            }
            return 1;
        }

        int sampleFromInstrumentalDistributionTail(double q) {
            double a = 1.5;
            double b = (double)this.numberOfElements + 0.5;
            double logBdviA = FastMath.log(b / 1.5);
            int result = (int)(1.5 * FastMath.exp(logBdviA * ZipfRejectionSampler.helper1(q, logBdviA * (1.0 - this.exponent))) + 0.5);
            if (result < 2) {
                return 2;
            }
            if (result > this.numberOfElements) {
                return this.numberOfElements;
            }
            return result;
        }

        static double helper1(double q, double x) {
            if (Math.abs(x) > 1.0E-8) {
                return FastMath.log(1.0 - q + q * FastMath.exp(x)) / x;
            }
            return q * (1.0 + 0.5 * x * (1.0 - q) * (1.0 + 0.3333333333333333 * x * (1.0 - 2.0 * q + 0.25 * x * (6.0 * q * q * (q - 1.0) + 1.0))));
        }

        static double helper2(double x) {
            if (FastMath.abs(x) > 1.0E-8) {
                return FastMath.expm1(x) / x;
            }
            return 1.0 + x * 0.5 * (1.0 + x * 0.3333333333333333 * (1.0 + x * 0.25));
        }

        static double integratePowerFunction(double r, double a, double b) {
            double logA = FastMath.log(a);
            double logBdivA = FastMath.log(b / a);
            return FastMath.exp((1.0 + r) * logA) * ZipfRejectionSampler.helper2((1.0 + r) * logBdivA) * logBdivA;
        }

        double acceptanceRateForTailSample(int k) {
            double a = FastMath.log1p(1.0 / (2.0 * (double)k - 1.0));
            double b = FastMath.log1p(2.0 / (2.0 * (double)k - 1.0));
            return FastMath.exp((1.0 - this.exponent) * a) / ((double)k * b * ZipfRejectionSampler.helper2((1.0 - this.exponent) * b));
        }
    }
}

