/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.stat.descriptive;

import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.math4.util.Precision;

public abstract class AbstractStorelessUnivariateStatistic
implements StorelessUnivariateStatistic {
    @Override
    public double evaluate(double[] values) throws MathIllegalArgumentException {
        if (values == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        return this.evaluate(values, 0, values.length);
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues(values, begin, length)) {
            StorelessUnivariateStatistic stat = this.copy();
            stat.clear();
            stat.incrementAll(values, begin, length);
            return stat.getResult();
        }
        return Double.NaN;
    }

    @Override
    public abstract StorelessUnivariateStatistic copy();

    @Override
    public abstract void clear();

    @Override
    public abstract double getResult();

    @Override
    public abstract void increment(double var1);

    @Override
    public void incrementAll(double[] values) throws MathIllegalArgumentException {
        if (values == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        this.incrementAll(values, 0, values.length);
    }

    @Override
    public void incrementAll(double[] values, int begin, int length) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues(values, begin, length)) {
            int k = begin + length;
            for (int i = begin; i < k; ++i) {
                this.increment(values[i]);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        StorelessUnivariateStatistic stat = (StorelessUnivariateStatistic)object;
        return Precision.equalsIncludingNaN(stat.getResult(), this.getResult()) && Precision.equalsIncludingNaN(stat.getN(), this.getN());
    }

    public int hashCode() {
        return 31 * (31 + MathUtils.hash(this.getResult())) + MathUtils.hash(this.getN());
    }
}

