/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.CombinatoricsException;
import org.apache.commons.numbers.core.ArithmeticUtils;

public class BinomialCoefficient {
    private BinomialCoefficient() {
    }

    public static long value(int n, int k) {
        BinomialCoefficient.checkBinomial(n, k);
        if (n == k || k == 0) {
            return 1L;
        }
        if (k == 1 || k == n - 1) {
            return n;
        }
        if (k > n / 2) {
            return BinomialCoefficient.value(n, n - k);
        }
        long result = 1L;
        if (n <= 61) {
            int i = n - k + 1;
            for (int j = 1; j <= k; ++j) {
                result = result * (long)i / (long)j;
                ++i;
            }
        } else if (n <= 66) {
            int i = n - k + 1;
            for (int j = 1; j <= k; ++j) {
                long d = ArithmeticUtils.gcd((int)i, (int)j);
                result = result / ((long)j / d) * ((long)i / d);
                ++i;
            }
        } else {
            int i = n - k + 1;
            for (int j = 1; j <= k; ++j) {
                long d = ArithmeticUtils.gcd((int)i, (int)j);
                result = Math.multiplyExact(result / ((long)j / d), (long)i / d);
                ++i;
            }
        }
        return result;
    }

    static void checkBinomial(int n, int k) {
        if (n < 0) {
            throw new CombinatoricsException("Number {0} is negative", n);
        }
        if (k > n || k < 0) {
            throw new CombinatoricsException("Number {0} is out of range [{1}, {2}]", k, 0, n);
        }
    }
}

