/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.fraction;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.commons.numbers.core.ArithmeticUtils;
import org.apache.commons.numbers.core.NativeOperators;
import org.apache.commons.numbers.fraction.FractionException;

public class BigFraction
extends Number
implements Comparable<BigFraction>,
NativeOperators<BigFraction>,
Serializable {
    public static final BigFraction ZERO = BigFraction.of(0);
    public static final BigFraction ONE = BigFraction.of(1);
    private static final long serialVersionUID = 20190701L;
    private static final String PARAM_NAME_FRACTION = "fraction";
    private static final String PARAM_NAME_BG = "bg";
    private final BigInteger numerator;
    private final BigInteger denominator;

    private BigFraction(BigInteger num, BigInteger den) {
        BigFraction.checkNotNull(num, "numerator");
        BigFraction.checkNotNull(den, "denominator");
        if (den.signum() == 0) {
            throw new FractionException("Denominator must be different from 0", new Object[0]);
        }
        BigInteger gcd = num.gcd(den);
        if (BigInteger.ONE.compareTo(gcd) < 0) {
            num = num.divide(gcd);
            den = den.divide(gcd);
        }
        this.numerator = num;
        this.denominator = den;
    }

    private static BigFraction from(double value, double epsilon, int maxDenominator, int maxIterations) {
        long overflow = Integer.MAX_VALUE;
        double r0 = value;
        long a0 = (long)Math.floor(r0);
        if (Math.abs(a0) > overflow) {
            throw new FractionException("Overflow trying to convert {0} to fraction ({1}/{2})", value, a0, 1L);
        }
        if (Math.abs((double)a0 - value) < epsilon) {
            return new BigFraction(BigInteger.valueOf(a0), BigInteger.ONE);
        }
        long p0 = 1L;
        long q0 = 0L;
        long p1 = a0;
        long q1 = 1L;
        long p2 = 0L;
        long q2 = 1L;
        int n = 0;
        boolean stop = false;
        do {
            ++n;
            double r1 = 1.0 / (r0 - (double)a0);
            long a1 = (long)Math.floor(r1);
            p2 = a1 * p1 + p0;
            q2 = a1 * q1 + q0;
            if (p2 > overflow || q2 > overflow) {
                if (epsilon == 0.0 && Math.abs(q1) < (long)maxDenominator) break;
                throw new FractionException("Overflow trying to convert {0} to fraction ({1}/{2})", value, p2, q2);
            }
            double convergent = (double)p2 / (double)q2;
            if (n < maxIterations && Math.abs(convergent - value) > epsilon && q2 < (long)maxDenominator) {
                p0 = p1;
                p1 = p2;
                q0 = q1;
                q1 = q2;
                a0 = a1;
                r0 = r1;
                continue;
            }
            stop = true;
        } while (!stop);
        if (n >= maxIterations) {
            throw new FractionException("Unable to convert {0} to fraction after {1} iterations", value, maxIterations);
        }
        return q2 < (long)maxDenominator ? new BigFraction(BigInteger.valueOf(p2), BigInteger.valueOf(q2)) : new BigFraction(BigInteger.valueOf(p1), BigInteger.valueOf(q1));
    }

    public static BigFraction of(BigInteger num) {
        return new BigFraction(num, BigInteger.ONE);
    }

    public static BigFraction of(BigInteger num, BigInteger den) {
        return new BigFraction(num, den);
    }

    public static BigFraction from(double value) {
        int k;
        long m;
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("Cannot convert NaN value");
        }
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("Cannot convert infinite value");
        }
        long bits = Double.doubleToLongBits(value);
        long sign = bits & Long.MIN_VALUE;
        long exponent = bits & 0x7FF0000000000000L;
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        if (exponent != 0L) {
            m = mantissa | 0x10000000000000L;
            k = (int)(exponent >> 52) - 1075;
        } else {
            m = mantissa;
            k = 0;
            if (m != 0L) {
                k = -1074;
            }
        }
        if (sign != 0L) {
            m = -m;
        }
        while ((m & 0x1FFFFFFFFFFFFEL) != 0L && (m & 1L) == 0L) {
            m >>= 1;
            ++k;
        }
        return k < 0 ? new BigFraction(BigInteger.valueOf(m), BigInteger.ZERO.flipBit(-k)) : new BigFraction(BigInteger.valueOf(m).multiply(BigInteger.ZERO.flipBit(k)), BigInteger.ONE);
    }

    public static BigFraction from(double value, double epsilon, int maxIterations) {
        return BigFraction.from(value, epsilon, Integer.MAX_VALUE, maxIterations);
    }

    public static BigFraction from(double value, int maxDenominator) {
        return BigFraction.from(value, 0.0, maxDenominator, 100);
    }

    public static BigFraction of(int num) {
        return new BigFraction(BigInteger.valueOf(num), BigInteger.ONE);
    }

    public static BigFraction of(int num, int den) {
        return new BigFraction(BigInteger.valueOf(num), BigInteger.valueOf(den));
    }

    public static BigFraction of(long num) {
        return new BigFraction(BigInteger.valueOf(num), BigInteger.ONE);
    }

    public static BigFraction of(long num, long den) {
        return new BigFraction(BigInteger.valueOf(num), BigInteger.valueOf(den));
    }

    public BigFraction abs() {
        return this.signum() >= 0 ? this : this.negate();
    }

    public BigFraction add(BigInteger bg) {
        BigFraction.checkNotNull(bg, PARAM_NAME_BG);
        if (this.numerator.signum() == 0) {
            return BigFraction.of(bg);
        }
        if (bg.signum() == 0) {
            return this;
        }
        return new BigFraction(this.numerator.add(this.denominator.multiply(bg)), this.denominator);
    }

    public BigFraction add(int i) {
        return this.add(BigInteger.valueOf(i));
    }

    public BigFraction add(long l) {
        return this.add(BigInteger.valueOf(l));
    }

    public BigFraction add(BigFraction fraction) {
        BigInteger den;
        BigInteger num;
        BigFraction.checkNotNull(fraction, PARAM_NAME_FRACTION);
        if (fraction.numerator.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return fraction;
        }
        if (this.denominator.equals(fraction.denominator)) {
            num = this.numerator.add(fraction.numerator);
            den = this.denominator;
        } else {
            num = this.numerator.multiply(fraction.denominator).add(fraction.numerator.multiply(this.denominator));
            den = this.denominator.multiply(fraction.denominator);
        }
        if (num.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(num, den);
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator));
    }

    public BigDecimal bigDecimalValue(RoundingMode roundingMode) {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), roundingMode);
    }

    public BigDecimal bigDecimalValue(int scale, RoundingMode roundingMode) {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), scale, roundingMode);
    }

    @Override
    public int compareTo(BigFraction object) {
        int rhsSigNum;
        int lhsSigNum = this.numerator.signum();
        if (lhsSigNum != (rhsSigNum = object.numerator.signum())) {
            return lhsSigNum > rhsSigNum ? 1 : -1;
        }
        if (lhsSigNum == 0) {
            return 0;
        }
        BigInteger nOd = this.numerator.multiply(object.denominator);
        BigInteger dOn = this.denominator.multiply(object.numerator);
        return nOd.compareTo(dOn);
    }

    public BigFraction divide(BigInteger bg) {
        BigFraction.checkNotNull(bg, PARAM_NAME_BG);
        if (bg.signum() == 0) {
            throw new FractionException("Denominator must be different from 0", new Object[0]);
        }
        if (this.numerator.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(this.numerator, this.denominator.multiply(bg));
    }

    public BigFraction divide(int i) {
        return this.divide(BigInteger.valueOf(i));
    }

    public BigFraction divide(long l) {
        return this.divide(BigInteger.valueOf(l));
    }

    public BigFraction divide(BigFraction fraction) {
        BigFraction.checkNotNull(fraction, PARAM_NAME_FRACTION);
        if (fraction.numerator.signum() == 0) {
            throw new FractionException("Denominator must be different from 0", new Object[0]);
        }
        if (this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(fraction.reciprocal());
    }

    private long toFloatingPointBits(int exponentLength, int significandLength) {
        long maxExponent;
        int exponentBias;
        long exponent;
        int quotRightShift;
        BigInteger dividend;
        BigInteger quotient;
        long significand;
        if (exponentLength < 1 || significandLength < 1 || exponentLength > Math.min(32, 63 - significandLength)) {
            throw new IllegalArgumentException("exponent length: " + exponentLength + "; significand length: " + significandLength);
        }
        if (this.numerator.signum() == 0) {
            return 0L;
        }
        long sign = this.numerator.signum() * this.denominator.signum() == -1 ? 1L : 0L;
        BigInteger positiveNumerator = this.numerator.abs();
        BigInteger positiveDenominator = this.denominator.abs();
        int denRightShift = positiveDenominator.getLowestSetBit();
        BigInteger divisor = positiveDenominator.shiftRight(denRightShift);
        int numRightShift = positiveNumerator.bitLength() - divisor.bitLength() - (significandLength + 2);
        if (numRightShift > 0 && divisor.equals(BigInteger.ONE)) {
            numRightShift = Math.min(numRightShift, positiveNumerator.getLowestSetBit());
        }
        if (((significand = BigFraction.roundAndRightShift(quotient = (dividend = positiveNumerator.shiftRight(numRightShift)).divide(divisor), quotRightShift = quotient.bitLength() - (significandLength + 1), !divisor.equals(BigInteger.ONE)).longValue()) & 1L << significandLength + 1) != 0L) {
            significand >>= 1;
            ++quotRightShift;
        }
        if ((exponent = (long)(numRightShift - denRightShift + quotRightShift + significandLength + (exponentBias = (1 << exponentLength - 1) - 1))) >= (maxExponent = (1L << exponentLength) - 1L)) {
            exponent = maxExponent;
            significand = 0L;
        } else if (exponent > 0L) {
            significand &= -1L >>> 64 - significandLength;
        } else {
            significand = BigFraction.roundAndRightShift(quotient, 1 - exponentBias - significandLength - (numRightShift - denRightShift), !divisor.equals(BigInteger.ONE)).longValue();
            exponent = 0L;
        }
        return sign << significandLength + exponentLength | exponent << significandLength | significand;
    }

    @Override
    public double doubleValue() {
        return Double.longBitsToDouble(this.toFloatingPointBits(11, 52));
    }

    private static BigInteger roundAndRightShift(BigInteger value, int bits, boolean hasFractionalBits) {
        if (bits <= 0) {
            throw new IllegalArgumentException("bits: " + bits);
        }
        BigInteger result = value.shiftRight(bits);
        if (value.testBit(bits - 1) && (hasFractionalBits || value.getLowestSetBit() < bits - 1 || value.testBit(bits))) {
            result = result.add(BigInteger.ONE);
        }
        return result;
    }

    public boolean equals(Object other) {
        boolean ret = false;
        if (this == other) {
            ret = true;
        } else if (other instanceof BigFraction) {
            BigFraction rhs = (BigFraction)other;
            ret = this.numerator.equals(rhs.numerator) && this.denominator.equals(rhs.denominator);
        }
        return ret;
    }

    @Override
    public float floatValue() {
        return Float.intBitsToFloat((int)this.toFloatingPointBits(8, 23));
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public int getDenominatorAsInt() {
        return this.denominator.intValue();
    }

    public long getDenominatorAsLong() {
        return this.denominator.longValue();
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public int getNumeratorAsInt() {
        return this.numerator.intValue();
    }

    public long getNumeratorAsLong() {
        return this.numerator.longValue();
    }

    public int hashCode() {
        return 37 * (629 + this.numerator.hashCode()) + this.denominator.hashCode();
    }

    @Override
    public int intValue() {
        return this.numerator.divide(this.denominator).intValue();
    }

    @Override
    public long longValue() {
        return this.numerator.divide(this.denominator).longValue();
    }

    public BigFraction multiply(BigInteger bg) {
        BigFraction.checkNotNull(bg, PARAM_NAME_BG);
        if (this.numerator.signum() == 0 || bg.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(bg.multiply(this.numerator), this.denominator);
    }

    public BigFraction multiply(int i) {
        if (i == 0 || this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(i));
    }

    public BigFraction multiply(long l) {
        if (l == 0L || this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(l));
    }

    public BigFraction multiply(BigFraction fraction) {
        BigFraction.checkNotNull(fraction, PARAM_NAME_FRACTION);
        if (this.numerator.signum() == 0 || fraction.numerator.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(this.numerator.multiply(fraction.numerator), this.denominator.multiply(fraction.denominator));
    }

    public int signum() {
        int numS = this.numerator.signum();
        int denS = this.denominator.signum();
        if (numS > 0 && denS > 0 || numS < 0 && denS < 0) {
            return 1;
        }
        if (numS == 0) {
            return 0;
        }
        return -1;
    }

    public BigFraction negate() {
        return new BigFraction(this.numerator.negate(), this.denominator);
    }

    public BigFraction pow(int exponent) {
        if (exponent == 0) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (exponent < 0) {
            return new BigFraction(this.denominator.pow(-exponent), this.numerator.pow(-exponent));
        }
        return new BigFraction(this.numerator.pow(exponent), this.denominator.pow(exponent));
    }

    public BigFraction pow(long exponent) {
        if (exponent == 0L) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (exponent < 0L) {
            return new BigFraction(ArithmeticUtils.pow((BigInteger)this.denominator, (long)(-exponent)), ArithmeticUtils.pow((BigInteger)this.numerator, (long)(-exponent)));
        }
        return new BigFraction(ArithmeticUtils.pow((BigInteger)this.numerator, (long)exponent), ArithmeticUtils.pow((BigInteger)this.denominator, (long)exponent));
    }

    public BigFraction pow(BigInteger exponent) {
        if (exponent.signum() == 0) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (exponent.signum() == -1) {
            BigInteger eNeg = exponent.negate();
            return new BigFraction(ArithmeticUtils.pow((BigInteger)this.denominator, (BigInteger)eNeg), ArithmeticUtils.pow((BigInteger)this.numerator, (BigInteger)eNeg));
        }
        return new BigFraction(ArithmeticUtils.pow((BigInteger)this.numerator, (BigInteger)exponent), ArithmeticUtils.pow((BigInteger)this.denominator, (BigInteger)exponent));
    }

    public double pow(double exponent) {
        return Math.pow(this.numerator.doubleValue(), exponent) / Math.pow(this.denominator.doubleValue(), exponent);
    }

    public BigFraction reciprocal() {
        return new BigFraction(this.denominator, this.numerator);
    }

    public BigFraction subtract(BigInteger bg) {
        BigFraction.checkNotNull(bg, PARAM_NAME_BG);
        if (bg.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return BigFraction.of(bg.negate());
        }
        return new BigFraction(this.numerator.subtract(this.denominator.multiply(bg)), this.denominator);
    }

    public BigFraction subtract(int i) {
        return this.subtract(BigInteger.valueOf(i));
    }

    public BigFraction subtract(long l) {
        return this.subtract(BigInteger.valueOf(l));
    }

    public BigFraction subtract(BigFraction fraction) {
        BigInteger den;
        BigInteger num;
        BigFraction.checkNotNull(fraction, PARAM_NAME_FRACTION);
        if (fraction.numerator.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return fraction.negate();
        }
        if (this.denominator.equals(fraction.denominator)) {
            num = this.numerator.subtract(fraction.numerator);
            den = this.denominator;
        } else {
            num = this.numerator.multiply(fraction.denominator).subtract(fraction.numerator.multiply(this.denominator));
            den = this.denominator.multiply(fraction.denominator);
        }
        return new BigFraction(num, den);
    }

    public String toString() {
        String str = BigInteger.ONE.equals(this.denominator) ? this.numerator.toString() : (BigInteger.ZERO.equals(this.numerator) ? "0" : this.numerator + " / " + this.denominator);
        return str;
    }

    public BigFraction zero() {
        return ZERO;
    }

    public BigFraction one() {
        return ONE;
    }

    public static BigFraction parse(String s) {
        int slashLoc = (s = s.replace(",", "")).indexOf("/");
        if (slashLoc == -1) {
            return BigFraction.of(new BigInteger(s.trim()));
        }
        BigInteger num = new BigInteger(s.substring(0, slashLoc).trim());
        BigInteger denom = new BigInteger(s.substring(slashLoc + 1).trim());
        return BigFraction.of(num, denom);
    }

    private static void checkNotNull(Object arg, String argName) {
        if (arg == null) {
            throw new NullPointerException(argName);
        }
    }
}

