/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.webdav.WebdavFileSystem;

public class WebdavFileSystemConfigBuilder
extends HttpFileSystemConfigBuilder {
    private static final WebdavFileSystemConfigBuilder builder = new WebdavFileSystemConfigBuilder();

    public static HttpFileSystemConfigBuilder getInstance() {
        return builder;
    }

    private WebdavFileSystemConfigBuilder() {
        super("webdav.");
    }

    public void setCreatorName(FileSystemOptions opts, String creatorName) {
        this.setParam(opts, "creatorName", creatorName);
    }

    public String getCreatorName(FileSystemOptions opts) {
        return this.getString(opts, "creatorName");
    }

    public void setVersioning(FileSystemOptions opts, boolean versioning) {
        this.setParam(opts, "versioning", new Boolean(versioning));
    }

    public boolean isVersioning(FileSystemOptions opts) {
        return this.getBoolean(opts, "versioning", false);
    }

    protected Class getConfigClass() {
        return WebdavFileSystem.class;
    }
}

