/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Properties;
import org.apache.curator.test.FailedServerStartException;
import org.apache.curator.test.QuorumPeerConfigBuilder;
import org.apache.curator.test.ZooKeeperMainFace;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.embedded.ZooKeeperServerEmbedded;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.apache.zookeeper.server.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServerEmbeddedAdapter
implements ZooKeeperMainFace {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperServerEmbeddedAdapter.class);
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(1L);
    private volatile ZooKeeperServerEmbedded zooKeeperEmbedded;

    @Override
    public void start(QuorumPeerConfigBuilder configBuilder) {
        try {
            Properties properties = configBuilder.buildProperties();
            properties.put("admin.enableServer", "false");
            properties.put("4lw.commands.whitelist", "*");
            Path dataDir = Paths.get(properties.getProperty("dataDir"), new String[0]);
            this.zooKeeperEmbedded = ZooKeeperServerEmbedded.builder().configuration(properties).baseDir(dataDir.getParent()).build();
            log.info("Configure ZooKeeperServerEmbeddedAdapter with properties: {}", (Object)properties);
            if (this.hijackClientPort(0)) {
                this.zooKeeperEmbedded.start(DEFAULT_STARTUP_TIMEOUT.toMillis());
                int port = this.getServerCnxnFactory().getLocalPort();
                this.hijackClientPort(port);
            } else {
                this.zooKeeperEmbedded.start(DEFAULT_STARTUP_TIMEOUT.toMillis());
            }
        }
        catch (Exception e) {
            throw new FailedServerStartException(e);
        }
    }

    @Override
    public int getClientPort() throws Exception {
        String address = this.zooKeeperEmbedded.getConnectionString();
        try {
            String[] parts = ConfigUtils.getHostAndPort((String)address);
            return Integer.parseInt(parts[1], 10);
        }
        catch (Exception ex) {
            throw new IllegalStateException("invalid connection string: " + address);
        }
    }

    private boolean hijackClientPort(int port) {
        try {
            Class<?> clazz = Class.forName("org.apache.zookeeper.server.embedded.ZooKeeperServerEmbeddedImpl");
            Field configField = clazz.getDeclaredField("config");
            configField.setAccessible(true);
            QuorumPeerConfig peerConfig = (QuorumPeerConfig)configField.get(this.zooKeeperEmbedded);
            if (peerConfig.getClientPortAddress() == null || port != 0) {
                Field addressField = QuorumPeerConfig.class.getDeclaredField("clientPortAddress");
                addressField.setAccessible(true);
                addressField.set(peerConfig, new InetSocketAddress(port));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public ServerCnxnFactory getServerCnxnFactory() {
        try {
            Class<?> clazz = Class.forName("org.apache.zookeeper.server.embedded.ZooKeeperServerEmbeddedImpl");
            Field clusterField = clazz.getDeclaredField("maincluster");
            clusterField.setAccessible(true);
            QuorumPeerMain quorumPeerMain = (QuorumPeerMain)clusterField.get(this.zooKeeperEmbedded);
            if (quorumPeerMain != null) {
                Field quorumPeerField = QuorumPeerMain.class.getDeclaredField("quorumPeer");
                quorumPeerField.setAccessible(true);
                QuorumPeer quorumPeer = (QuorumPeer)quorumPeerField.get(quorumPeerMain);
                return ZooKeeperServerEmbeddedAdapter.getServerCnxnFactory(QuorumPeer.class, quorumPeer, "cnxnFactory");
            }
            Field serverField = clazz.getDeclaredField("mainsingle");
            serverField.setAccessible(true);
            ZooKeeperServerMain server = (ZooKeeperServerMain)serverField.get(this.zooKeeperEmbedded);
            return ZooKeeperServerEmbeddedAdapter.getServerCnxnFactory(ZooKeeperServerMain.class, server, "cnxnFactory");
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ex) {
            throw new IllegalStateException("zk server cnxn factory not found", ex);
        }
    }

    static ServerCnxnFactory getServerCnxnFactory(Class<?> clazz, Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field cnxnFactoryField = clazz.getDeclaredField(fieldName);
        cnxnFactoryField.setAccessible(true);
        return (ServerCnxnFactory)cnxnFactoryField.get(obj);
    }

    @Override
    public void kill() {
        this.close();
    }

    @Override
    public void close() {
        if (this.zooKeeperEmbedded != null) {
            this.zooKeeperEmbedded.close();
        }
    }
}

