/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.staxutils.PrettyPrintXMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;

public abstract class AbstractLoggingInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected static final String BINARY_CONTENT_MESSAGE = "--- Binary Content ---";
    private static final List<String> BINARY_CONTENT_MEDIA_TYPES = new ArrayList<String>();
    protected int limit = 49152;
    protected long threshold = -1L;
    protected PrintWriter writer;
    protected boolean prettyLogging;
    private boolean showBinaryContent;

    public AbstractLoggingInterceptor(String phase) {
        super(phase);
    }

    public AbstractLoggingInterceptor(String id, String phase) {
        super(id, phase);
    }

    protected abstract Logger getLogger();

    Logger getMessageLogger(Message message) {
        EndpointInfo endpoint = message.getExchange().getEndpoint().getEndpointInfo();
        if (endpoint.getService() == null) {
            return this.getLogger();
        }
        Logger logger = endpoint.getProperty("MessageLogger", Logger.class);
        if (logger == null) {
            String serviceName = endpoint.getService().getName().getLocalPart();
            InterfaceInfo iface = endpoint.getService().getInterface();
            String portName = endpoint.getName().getLocalPart();
            String portTypeName = iface.getName().getLocalPart();
            String logName = "org.apache.cxf.services." + serviceName + "." + portName + "." + portTypeName;
            logger = LogUtils.getL7dLogger(this.getClass(), null, logName);
            endpoint.setProperty("MessageLogger", logger);
        }
        return logger;
    }

    public void setOutputLocation(String s) {
        if (s == null || "<logger>".equals(s)) {
            this.writer = null;
        } else if ("<stdout>".equals(s)) {
            this.writer = new PrintWriter(System.out, true);
        } else if ("<stderr>".equals(s)) {
            this.writer = new PrintWriter(System.err, true);
        } else {
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                this.writer = new PrintWriter((Writer)new FileWriter(file, true), true);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Error configuring log location " + s, ex);
            }
        }
    }

    public void setPrintWriter(PrintWriter w) {
        this.writer = w;
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setPrettyLogging(boolean flag) {
        this.prettyLogging = flag;
    }

    public boolean isPrettyLogging() {
        return this.prettyLogging;
    }

    public void setInMemThreshold(long t) {
        this.threshold = t;
    }

    public long getInMemThreshold() {
        return this.threshold;
    }

    protected void writePayload(StringBuilder builder, CachedOutputStream cos, String encoding, String contentType) throws Exception {
        if (this.isPrettyLogging() && contentType != null && contentType.indexOf("xml") >= 0 && contentType.toLowerCase().indexOf("multipart/related") < 0 && cos.size() > 0L) {
            StringWriter swriter = new StringWriter();
            XMLStreamWriter xwriter = StaxUtils.createXMLStreamWriter(swriter);
            xwriter = new PrettyPrintXMLStreamWriter(xwriter, 2);
            InputStream in = cos.getInputStream();
            StaxUtils.copy((Source)new StreamSource(in), xwriter);
            xwriter.close();
            in.close();
            String result = swriter.toString();
            if (result.length() < this.limit || this.limit == -1) {
                builder.append(swriter.toString());
            } else {
                builder.append(swriter.toString().substring(0, this.limit));
            }
        } else if (StringUtils.isEmpty(encoding)) {
            cos.writeCacheTo(builder, this.limit);
        } else {
            cos.writeCacheTo(builder, encoding, this.limit);
        }
    }

    protected void writePayload(StringBuilder builder, StringWriter stringWriter, String contentType) throws Exception {
        if (this.isPrettyLogging() && contentType != null && contentType.indexOf("xml") >= 0 && stringWriter.getBuffer().length() > 0) {
            StringWriter swriter = new StringWriter();
            XMLStreamWriter xwriter = StaxUtils.createXMLStreamWriter(swriter);
            xwriter = new PrettyPrintXMLStreamWriter(xwriter, 2);
            StaxUtils.copy((Source)new StreamSource(new StringReader(stringWriter.getBuffer().toString())), xwriter);
            xwriter.close();
            String result = swriter.toString();
            if (result.length() < this.limit || this.limit == -1) {
                builder.append(swriter.toString());
            } else {
                builder.append(swriter.toString().substring(0, this.limit));
            }
        } else {
            StringBuffer buffer = stringWriter.getBuffer();
            if (buffer.length() > this.limit) {
                builder.append(buffer.subSequence(0, this.limit));
            } else {
                builder.append(buffer);
            }
        }
    }

    protected String transform(String originalLogString) {
        return originalLogString;
    }

    protected void log(Logger logger, String message) {
        message = this.transform(message);
        if (this.writer != null) {
            this.writer.println(message);
            this.writer.flush();
        } else if (logger.isLoggable(Level.INFO)) {
            LogRecord lr = new LogRecord(Level.INFO, message);
            lr.setSourceClassName(logger.getName());
            lr.setSourceMethodName(null);
            lr.setLoggerName(logger.getName());
            logger.log(lr);
        }
    }

    public void setShowBinaryContent(boolean showBinaryContent) {
        this.showBinaryContent = showBinaryContent;
    }

    public boolean isShowBinaryContent() {
        return this.showBinaryContent;
    }

    public boolean isBinaryContent(String contentType) {
        return contentType != null && BINARY_CONTENT_MEDIA_TYPES.contains(contentType);
    }

    static {
        BINARY_CONTENT_MEDIA_TYPES.add("application/octet-stream");
        BINARY_CONTENT_MEDIA_TYPES.add("image/png");
        BINARY_CONTENT_MEDIA_TYPES.add("image/jpeg");
        BINARY_CONTENT_MEDIA_TYPES.add("image/gif");
    }
}

