/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXBUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.staxutils.DepthRestrictingStreamReader;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.DocumentDepthProperties;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.transform.TransformUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractJAXBProvider<T>
extends AbstractConfigurableProvider
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractJAXBProvider.class);
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractJAXBProvider.class);
    protected static final String NS_MAPPER_PROPERTY_RI = "com.sun.xml.bind.namespacePrefixMapper";
    protected static final String NS_MAPPER_PROPERTY_RI_INT = "com.sun.xml.internal.bind.namespacePrefixMapper";
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    protected Set<Class<?>> collectionContextClasses = new HashSet();
    protected Map<String, String> jaxbElementClassMap = Collections.emptyMap();
    protected boolean unmarshalAsJaxbElement;
    protected boolean marshalAsJaxbElement;
    protected boolean xmlTypeAsJaxbElementOnly;
    protected Map<String, String> outElementsMap;
    protected Map<String, String> outAppendMap;
    protected List<String> outDropElements;
    protected List<String> inDropElements;
    protected Map<String, String> inElementsMap;
    protected Map<String, String> inAppendMap;
    protected Map<String, JAXBContext> packageContexts = new HashMap<String, JAXBContext>();
    protected Map<Class<?>, JAXBContext> classContexts = new HashMap();
    private boolean attributesToElements;
    private MessageContext mc;
    private Schema schema;
    private String catalogLocation;
    private Map<String, SchemaHandler> schemaHandlers;
    private String collectionWrapperName;
    private Map<String, String> collectionWrapperMap;
    private List<String> jaxbElementClassNames;
    private boolean xmlRootAsJaxbElement;
    private Map<String, Object> cProperties;
    private Map<String, Object> uProperties;
    private boolean skipJaxbChecks;
    private boolean singleJaxbContext;
    private boolean useSingleContextForPackages;
    private Class<?>[] extraClass;
    private boolean validateOutput;
    private boolean validateBeforeWrite;
    private ValidationEventHandler eventHandler;
    private Unmarshaller.Listener unmarshallerListener;
    private Marshaller.Listener marshallerListener;
    private DocumentDepthProperties depthProperties;
    private String namespaceMapperPropertyName;

    public void setXmlRootAsJaxbElement(boolean xmlRootAsJaxbElement) {
        this.xmlRootAsJaxbElement = xmlRootAsJaxbElement;
    }

    protected void setNamespaceMapper(Marshaller ms, Map<String, String> map) throws Exception {
        Object nsMapper = org.apache.cxf.common.jaxb.JAXBUtils.setNamespaceMapper(map, ms);
        if (this.namespaceMapperPropertyName != null) {
            AbstractJAXBProvider.setMarshallerProp(ms, nsMapper, this.namespaceMapperPropertyName, null);
        }
    }

    protected static void setMarshallerProp(Marshaller ms, Object value, String name1, String name2) throws Exception {
        try {
            ms.setProperty(name1, value);
        }
        catch (PropertyException ex) {
            if (name2 != null) {
                ms.setProperty(name2, value);
            }
            throw ex;
        }
    }

    public void setValidationHandler(ValidationEventHandler handler) {
        this.eventHandler = handler;
    }

    public void setSingleJaxbContext(boolean useSingleContext) {
        this.singleJaxbContext = useSingleContext;
    }

    public void setUseSingleContextForPackages(boolean use) {
        this.useSingleContextForPackages = use;
    }

    public void setExtraClass(Class<?>[] userExtraClass) {
        this.extraClass = userExtraClass;
    }

    @Override
    public void init(List<ClassResourceInfo> cris) {
        if (this.singleJaxbContext) {
            JAXBContext context = null;
            HashSet allTypes = null;
            if (cris != null) {
                allTypes = new HashSet(ResourceUtils.getAllRequestResponseTypes(cris, true).getAllTypes().keySet());
                context = ResourceUtils.createJaxbContext(allTypes, this.extraClass, this.cProperties);
            } else if (this.extraClass != null) {
                allTypes = new HashSet(Arrays.asList(this.extraClass));
                context = ResourceUtils.createJaxbContext(allTypes, null, this.cProperties);
            }
            if (context != null) {
                for (Class clazz : allTypes) {
                    if (this.useSingleContextForPackages) {
                        this.packageContexts.put(PackageUtils.getPackageName(clazz), context);
                        continue;
                    }
                    this.classContexts.put(clazz, context);
                }
            }
        }
    }

    public void setContextProperties(Map<String, Object> contextProperties) {
        this.cProperties = contextProperties;
    }

    public void setUnmarshallerProperties(Map<String, Object> unmarshalProperties) {
        this.uProperties = unmarshalProperties;
    }

    public void setUnmarshallAsJaxbElement(boolean value) {
        this.unmarshalAsJaxbElement = value;
    }

    public void setMarshallAsJaxbElement(boolean value) {
        this.marshalAsJaxbElement = value;
    }

    public void setXmlTypeAsJaxbElementOnly(boolean value) {
        this.xmlTypeAsJaxbElementOnly = value;
    }

    public void setJaxbElementClassNames(List<String> names) {
        this.jaxbElementClassNames = names;
    }

    public void setJaxbElementClassMap(Map<String, String> map) {
        this.jaxbElementClassMap = map;
    }

    protected void reportEmptyContentLength() throws NoContentException {
        String message = new org.apache.cxf.common.i18n.Message("EMPTY_BODY", BUNDLE, new Object[0]).toString();
        LOG.warning(message);
        throw new NoContentException(message);
    }

    protected <X> X getStreamHandlerFromCurrentMessage(Class<X> staxCls) {
        Message m = PhaseInterceptorChain.getCurrentMessage();
        if (m != null) {
            return staxCls.cast(m.getContent(staxCls));
        }
        return null;
    }

    protected boolean isXmlRoot(Class<?> cls) {
        return cls.getAnnotation(XmlRootElement.class) != null;
    }

    protected boolean isXmlType(Class<?> cls) {
        return cls.getAnnotation(XmlType.class) != null;
    }

    protected Object convertToJaxbElementIfNeeded(Object obj, Class<?> cls, Type genericType) throws Exception {
        boolean asJaxbElement;
        Class<?> jaxbElementCls = this.jaxbElementClassNames == null ? null : this.getJaxbElementClass(cls);
        boolean bl = asJaxbElement = jaxbElementCls != null;
        if (!asJaxbElement && this.isXmlRoot(cls) && !this.xmlRootAsJaxbElement) {
            return obj;
        }
        if (jaxbElementCls == null) {
            jaxbElementCls = cls;
        }
        QName name = null;
        String expandedName = this.jaxbElementClassMap.get(jaxbElementCls.getName());
        if (expandedName != null) {
            name = JAXRSUtils.convertStringToQName(expandedName);
        } else if (this.marshalAsJaxbElement || asJaxbElement) {
            name = this.getJaxbQName(jaxbElementCls, genericType, obj, false);
        }
        return name != null ? new JAXBElement(name, jaxbElementCls, null, obj) : obj;
    }

    protected Class<?> getJaxbElementClass(Class<?> cls) {
        if (cls == Object.class) {
            return null;
        }
        if (this.jaxbElementClassNames.contains(cls.getName())) {
            return cls;
        }
        return this.getJaxbElementClass(cls.getSuperclass());
    }

    public void setCollectionWrapperName(String wName) {
        this.collectionWrapperName = wName;
    }

    public void setCollectionWrapperMap(Map<String, String> map) {
        this.collectionWrapperMap = map;
    }

    protected void setContext(MessageContext context) {
        this.mc = context;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        if (InjectionUtils.isSupportedCollectionOrArray(type) && (type = InjectionUtils.getActualType(genericType)) == null) {
            return false;
        }
        return this.marshalAsJaxbElement && (!this.xmlTypeAsJaxbElementOnly || this.isXmlType(type)) || this.isSupported(type, genericType, anns);
    }

    public void writeTo(T t, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Class<?> type = t.getClass();
        this.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getCollectionContext(Class<?> type) throws JAXBException {
        Set<Class<?>> set = this.collectionContextClasses;
        synchronized (set) {
            if (!this.collectionContextClasses.contains(type)) {
                this.collectionContextClasses.add(CollectionWrapper.class);
                this.collectionContextClasses.add(type);
            }
            return JAXBContext.newInstance((Class[])this.collectionContextClasses.toArray(new Class[this.collectionContextClasses.size()]), this.cProperties);
        }
    }

    protected QName getCollectionWrapperQName(Class<?> cls, Type type, Object object, boolean pluralName) throws Exception {
        String name = this.getCollectionWrapperName(cls);
        if (name == null) {
            return this.getJaxbQName(cls, type, object, pluralName);
        }
        return JAXRSUtils.convertStringToQName(name);
    }

    private String getCollectionWrapperName(Class<?> cls) {
        if (this.collectionWrapperName != null) {
            return this.collectionWrapperName;
        }
        if (this.collectionWrapperMap != null) {
            return this.collectionWrapperMap.get(cls.getName());
        }
        return null;
    }

    protected QName getJaxbQName(Class<?> cls, Type type, Object object, boolean pluralName) throws Exception {
        if (cls == JAXBElement.class) {
            return object != null ? ((JAXBElement)object).getName() : null;
        }
        XmlRootElement root = cls.getAnnotation(XmlRootElement.class);
        if (root != null) {
            return this.getQNameFromNamespaceAndName(root.namespace(), root.name(), cls, pluralName);
        }
        if (this.isXmlType(cls)) {
            XmlType xmlType = cls.getAnnotation(XmlType.class);
            return this.getQNameFromNamespaceAndName(xmlType.namespace(), xmlType.name(), cls, pluralName);
        }
        return new QName(this.getPackageNamespace(cls), cls.getSimpleName());
    }

    private QName getQNameFromNamespaceAndName(String ns, String localName, Class<?> cls, boolean plural) {
        String name = this.getLocalName(localName, cls.getSimpleName(), plural);
        String namespace = this.getNamespace(ns);
        if ("".equals(namespace)) {
            namespace = this.getPackageNamespace(cls);
        }
        return new QName(namespace, name);
    }

    private String getLocalName(String name, String clsName, boolean pluralName) {
        if ("##default".equals(name)) {
            name = clsName;
            name = name.length() > 1 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
        }
        if (pluralName) {
            name = name + 's';
        }
        return name;
    }

    private String getPackageNamespace(Class<?> cls) {
        String packageNs = org.apache.cxf.common.jaxb.JAXBUtils.getPackageNamespace(cls);
        return packageNs != null ? this.getNamespace(packageNs) : "";
    }

    private String getNamespace(String namespace) {
        if ("##default".equals(namespace)) {
            return "";
        }
        return namespace;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        if (InjectionUtils.isSupportedCollectionOrArray(type) && (type = InjectionUtils.getActualType(genericType)) == null) {
            return false;
        }
        return this.canBeReadAsJaxbElement(type) || this.isSupported(type, genericType, anns);
    }

    protected boolean canBeReadAsJaxbElement(Class<?> type) {
        return this.unmarshalAsJaxbElement && type != Response.class;
    }

    @Deprecated
    public void setSchemas(List<String> locations) {
        this.setSchemaLocations(locations);
    }

    public void setSchemaLocations(List<String> locations) {
        this.schema = SchemaHandler.createSchema(locations, this.catalogLocation, this.getBus());
    }

    public void setCatalogLocation(String name) {
        this.catalogLocation = name;
    }

    public void setSchemaHandler(SchemaHandler handler) {
        this.setSchema(handler.getSchema());
    }

    public void setSchemaHandlers(Map<String, SchemaHandler> handlers) {
        this.schemaHandlers = handlers;
    }

    protected void setSchema(Schema s) {
        this.schema = s;
    }

    public long getSize(T o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    protected MessageContext getContext() {
        return this.mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJAXBContext(Class<?> type, Type genericType) throws JAXBException {
        JAXBContext customContext;
        ContextResolver resolver;
        if (this.mc != null && (resolver = this.mc.getResolver(ContextResolver.class, JAXBContext.class)) != null && (customContext = (JAXBContext)resolver.getContext(type)) != null) {
            return customContext;
        }
        resolver = this.classContexts;
        synchronized (resolver) {
            JAXBContext context = this.classContexts.get(type);
            if (context != null) {
                return context;
            }
        }
        JAXBContext context = this.getPackageContext(type, genericType);
        return context != null ? context : this.getClassContext(type, genericType);
    }

    public JAXBContext getClassContext(Class<?> type) throws JAXBException {
        return this.getClassContext(type, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getClassContext(Class<?> type, Type genericType) throws JAXBException {
        Map<Class<?>, JAXBContext> map = this.classContexts;
        synchronized (map) {
            JAXBContext context = this.classContexts.get(type);
            if (context == null) {
                Class[] classes = null;
                if (this.extraClass != null) {
                    classes = new Class[this.extraClass.length + 1];
                    classes[0] = type;
                    System.arraycopy(this.extraClass, 0, classes, 1, this.extraClass.length);
                } else {
                    classes = new Class[]{type};
                }
                context = JAXBContext.newInstance((Class[])classes, this.cProperties);
                this.classContexts.put(type, context);
            }
            return context;
        }
    }

    public JAXBContext getPackageContext(Class<?> type) {
        return this.getPackageContext(type, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getPackageContext(Class<?> type, Type genericType) {
        if (type == null || type == JAXBElement.class) {
            return null;
        }
        Map<String, JAXBContext> map = this.packageContexts;
        synchronized (map) {
            String packageName = PackageUtils.getPackageName(type);
            JAXBContext context = this.packageContexts.get(packageName);
            if (context == null) {
                try {
                    if (type.getClassLoader() != null && this.objectFactoryOrIndexAvailable(type)) {
                        String contextName = packageName;
                        if (this.extraClass != null) {
                            StringBuilder sb = new StringBuilder(contextName);
                            for (Class<?> extra : this.extraClass) {
                                String extraPackage = PackageUtils.getPackageName(extra);
                                if (extraPackage.equals(packageName)) continue;
                                sb.append(":").append(extraPackage);
                            }
                            contextName = sb.toString();
                        }
                        context = JAXBContext.newInstance((String)contextName, (ClassLoader)type.getClassLoader(), this.cProperties);
                        this.packageContexts.put(packageName, context);
                    }
                }
                catch (JAXBException ex) {
                    LOG.fine("Error creating a JAXBContext using ObjectFactory : " + ex.getMessage());
                    return null;
                }
            }
            return context;
        }
    }

    protected boolean isSupported(Class<?> type, Type genericType, Annotation[] anns) {
        if (this.jaxbElementClassMap != null && this.jaxbElementClassMap.containsKey(type.getName()) || this.isSkipJaxbChecks()) {
            return true;
        }
        return this.isXmlRoot(type) || JAXBElement.class.isAssignableFrom(type) || this.objectFactoryOrIndexAvailable(type) || type != genericType && this.objectFactoryForType(genericType) || JAXBUtils.getAdapter(type, anns) != null;
    }

    protected boolean objectFactoryOrIndexAvailable(Class<?> type) {
        return type.getResource("ObjectFactory.class") != null || type.getResource("jaxb.index") != null;
    }

    private boolean objectFactoryForType(Type genericType) {
        return this.objectFactoryOrIndexAvailable(InjectionUtils.getActualType(genericType));
    }

    protected Unmarshaller createUnmarshaller(Class<?> cls, Type genericType) throws JAXBException {
        return this.createUnmarshaller(cls, genericType, false);
    }

    protected Unmarshaller createUnmarshaller(Class<?> cls, Type genericType, boolean isCollection) throws JAXBException {
        JAXBContext context = isCollection ? this.getCollectionContext(cls) : this.getJAXBContext(cls, genericType);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Schema theSchema = this.getSchema(cls);
        if (theSchema != null) {
            unmarshaller.setSchema(theSchema);
        }
        if (this.eventHandler != null) {
            unmarshaller.setEventHandler(this.eventHandler);
        }
        if (this.unmarshallerListener != null) {
            unmarshaller.setListener(this.unmarshallerListener);
        }
        if (this.uProperties != null) {
            for (Map.Entry<String, Object> entry : this.uProperties.entrySet()) {
                unmarshaller.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return unmarshaller;
    }

    protected Marshaller createMarshaller(Object obj, Class<?> cls, Type genericType, String enc) throws JAXBException {
        Class objClazz = JAXBElement.class.isAssignableFrom(cls) ? ((JAXBElement)obj).getDeclaredType() : cls;
        JAXBContext context = this.getJAXBContext(objClazz, genericType);
        Marshaller marshaller = context.createMarshaller();
        if (enc != null) {
            marshaller.setProperty("jaxb.encoding", (Object)enc);
        }
        if (this.marshallerListener != null) {
            marshaller.setListener(this.marshallerListener);
        }
        this.validateObjectIfNeeded(marshaller, cls, obj);
        return marshaller;
    }

    protected void validateObjectIfNeeded(Marshaller marshaller, Class<?> cls, Object obj) throws JAXBException {
        Schema theSchema;
        if (this.validateOutput && (theSchema = this.getSchema(cls)) != null) {
            marshaller.setEventHandler(this.eventHandler);
            marshaller.setSchema(theSchema);
            if (this.validateBeforeWrite) {
                marshaller.marshal(obj, (ContentHandler)new DefaultHandler());
                marshaller.setSchema(null);
            }
        }
    }

    protected Class<?> getActualType(Class<?> type, Type genericType, Annotation[] anns) {
        Class<?> theType = null;
        theType = JAXBElement.class.isAssignableFrom(type) ? InjectionUtils.getActualType(genericType) : type;
        XmlJavaTypeAdapter adapter = JAXBUtils.getAdapter(theType, anns);
        theType = JAXBUtils.getTypeFromAdapter(adapter, theType, false);
        return theType;
    }

    protected static Object checkAdapter(Object obj, Class<?> cls, Annotation[] anns, boolean marshal) {
        XmlJavaTypeAdapter adapter = JAXBUtils.getAdapter(cls, anns);
        return JAXBUtils.useAdapter(obj, adapter, marshal);
    }

    protected Schema getSchema() {
        return this.getSchema(null);
    }

    protected Schema getSchema(Class<?> cls) {
        if (this.schema == null && this.schemaHandlers == null) {
            return null;
        }
        if (this.schema != null) {
            return this.schema;
        }
        SchemaHandler handler = this.schemaHandlers.get(cls.getName());
        return handler != null ? handler.getSchema() : null;
    }

    public void clearContexts() {
        this.classContexts.clear();
        this.packageContexts.clear();
    }

    protected static String getStackTrace(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    protected static StringBuilder handleExceptionStart(Exception e) {
        LOG.warning(AbstractJAXBProvider.getStackTrace(e));
        StringBuilder sb = new StringBuilder();
        if (e.getMessage() != null) {
            sb.append(e.getMessage()).append(". ");
        }
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            sb.append(e.getCause().getMessage()).append(". ");
        }
        return sb;
    }

    protected static void handleExceptionEnd(Throwable t, String message, boolean read) {
        Response.Status status = read ? Response.Status.BAD_REQUEST : Response.Status.INTERNAL_SERVER_ERROR;
        Response r = JAXRSUtils.toResponseBuilder(status).type("text/plain").entity((Object)message).build();
        WebApplicationException ex = read ? ExceptionUtils.toBadRequestException(t, r) : ExceptionUtils.toInternalServerErrorException(t, r);
        throw ex;
    }

    protected void handleJAXBException(JAXBException e, boolean read) {
        StringBuilder sb = AbstractJAXBProvider.handleExceptionStart((Exception)((Object)e));
        Throwable linked = e.getLinkedException();
        if (linked != null && linked.getMessage() != null) {
            if (read && linked instanceof XMLStreamException && linked.getMessage().startsWith("Maximum Number")) {
                throw ExceptionUtils.toWebApplicationException(null, JAXRSUtils.toResponse(413));
            }
            sb.append(linked.getMessage()).append(". ");
        }
        Throwable t = linked != null ? linked : (e.getCause() != null ? e.getCause() : e);
        String message = new org.apache.cxf.common.i18n.Message("JAXB_EXCEPTION", BUNDLE, sb.toString()).toString();
        AbstractJAXBProvider.handleExceptionEnd(t, message, read);
    }

    protected void handleXMLStreamException(XMLStreamException e, boolean read) {
        StringBuilder sb = AbstractJAXBProvider.handleExceptionStart(e);
        AbstractJAXBProvider.handleExceptionEnd(e, sb.toString(), read);
    }

    public void setOutTransformElements(Map<String, String> outElements) {
        this.outElementsMap = outElements;
    }

    public void setInAppendElements(Map<String, String> inElements) {
        this.inAppendMap = inElements;
    }

    public void setInTransformElements(Map<String, String> inElements) {
        this.inElementsMap = inElements;
    }

    public void setOutAppendElements(Map<String, String> map) {
        this.outAppendMap = map;
    }

    public void setOutDropElements(List<String> dropElementsSet) {
        this.outDropElements = dropElementsSet;
    }

    public void setInDropElements(List<String> dropElementsSet) {
        this.inDropElements = dropElementsSet;
    }

    public void setAttributesToElements(boolean value) {
        this.attributesToElements = value;
    }

    public void setSkipJaxbChecks(boolean skipJaxbChecks) {
        this.skipJaxbChecks = skipJaxbChecks;
    }

    public boolean isSkipJaxbChecks() {
        return this.skipJaxbChecks;
    }

    protected XMLStreamWriter createTransformWriterIfNeeded(XMLStreamWriter writer, OutputStream os, boolean dropAtXmlLevel) {
        return TransformUtils.createTransformWriterIfNeeded(writer, os, this.outElementsMap, dropAtXmlLevel ? this.outDropElements : null, this.outAppendMap, this.attributesToElements, null);
    }

    protected XMLStreamReader createTransformReaderIfNeeded(XMLStreamReader reader, InputStream is) {
        return TransformUtils.createTransformReaderIfNeeded(reader, is, this.inDropElements, this.inElementsMap, this.inAppendMap, true);
    }

    protected XMLStreamReader createDepthReaderIfNeeded(XMLStreamReader reader, InputStream is) {
        DocumentDepthProperties props = this.getDepthProperties();
        if (props != null && props.isEffective()) {
            reader = TransformUtils.createNewReaderIfNeeded(reader, is);
            reader = new DepthRestrictingStreamReader(reader, props);
        } else if (reader != null) {
            reader = this.configureReaderRestrictions(reader);
        }
        return reader;
    }

    protected XMLStreamReader configureReaderRestrictions(XMLStreamReader reader) {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (message != null) {
            try {
                return StaxUtils.configureReader(reader, message);
            }
            catch (XMLStreamException ex) {
                throw ExceptionUtils.toInternalServerErrorException(ex, null);
            }
        }
        return reader;
    }

    protected DocumentDepthProperties getDepthProperties() {
        return this.depthProperties;
    }

    public void setValidateBeforeWrite(boolean validateBeforeWrite) {
        this.validateBeforeWrite = validateBeforeWrite;
    }

    public void setValidateOutput(boolean validateOutput) {
        this.validateOutput = validateOutput;
    }

    public void setDepthProperties(DocumentDepthProperties depthProperties) {
        this.depthProperties = depthProperties;
    }

    public void setUnmarshallerListener(Unmarshaller.Listener unmarshallerListener) {
        this.unmarshallerListener = unmarshallerListener;
    }

    public void setMarshallerListener(Marshaller.Listener marshallerListener) {
        this.marshallerListener = marshallerListener;
    }

    public void setNamespaceMapperPropertyName(String namespaceMapperProperty) {
        this.namespaceMapperPropertyName = namespaceMapperProperty;
    }

    protected static class JAXBCollectionWrapperReader
    extends DepthXMLStreamReader {
        private boolean firstName;
        private boolean firstNs;

        public JAXBCollectionWrapperReader(XMLStreamReader reader) {
            super(reader);
        }

        @Override
        public String getNamespaceURI() {
            if (!this.firstNs) {
                this.firstNs = true;
                return "";
            }
            return super.getNamespaceURI();
        }

        @Override
        public String getLocalName() {
            if (!this.firstName) {
                this.firstName = true;
                return "collectionWrapper";
            }
            return super.getLocalName();
        }
    }

    @XmlRootElement
    protected static class CollectionWrapper {
        @XmlAnyElement(lax=true)
        private List<?> l;

        protected CollectionWrapper() {
        }

        public void setList(List<?> list) {
            this.l = list;
        }

        public List<?> getList() {
            if (this.l == null) {
                this.l = new ArrayList();
            }
            return this.l;
        }

        public <T> Object getCollectionOrArray(Unmarshaller unm, Class<T> type, Class<?> origType, XmlJavaTypeAdapter adapter) throws JAXBException {
            List<?> theList = this.getList();
            boolean adapterChecked = false;
            if (theList.size() > 0) {
                ArrayList<Object> newList;
                Object first = theList.get(0);
                if (first instanceof Element) {
                    newList = new ArrayList(theList.size());
                    for (Object o : theList) {
                        newList.add(unm.unmarshal((Node)((Element)o)));
                    }
                    theList = newList;
                }
                if ((first = theList.get(0)) instanceof JAXBElement && !JAXBElement.class.isAssignableFrom(type)) {
                    adapterChecked = true;
                    newList = new ArrayList(theList.size());
                    for (Object o : theList) {
                        newList.add(JAXBUtils.useAdapter(((JAXBElement)o).getValue(), adapter, false));
                    }
                    theList = newList;
                }
            }
            if (origType.isArray()) {
                Object[] values = (Object[])Array.newInstance(type, theList.size());
                for (int i = 0; i < theList.size(); ++i) {
                    values[i] = JAXBUtils.useAdapter(theList.get(i), adapter, false);
                }
                return values;
            }
            if (!adapterChecked && adapter != null) {
                ArrayList newList = new ArrayList(theList.size());
                for (Object o : theList) {
                    newList.add(JAXBUtils.useAdapter(o, adapter, false));
                }
                theList = newList;
            }
            if (origType == Set.class) {
                return new HashSet(theList);
            }
            return theList;
        }
    }
}

