/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.security.Principal;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.services.AbstractOAuthService;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;

public class AbstractTokenService
extends AbstractOAuthService {
    private boolean canSupportPublicClients;
    private boolean writeCustomErrors;

    protected Client authenticateClientIfNeeded(MultivaluedMap<String, String> params) {
        Client client = null;
        SecurityContext sc = this.getMessageContext().getSecurityContext();
        if (params.containsKey((Object)"client_id")) {
            client = this.getAndValidateClient((String)params.getFirst((Object)"client_id"), (String)params.getFirst((Object)"client_secret"));
        } else if (sc.getUserPrincipal() != null) {
            Principal p = sc.getUserPrincipal();
            String scheme = sc.getAuthenticationScheme();
            if ("Basic".equalsIgnoreCase(scheme)) {
                client = this.getClient(p.getName());
            } else {
                Object clientIdProp = this.getMessageContext().get("client_id");
                if (clientIdProp != null) {
                    client = this.getClient(clientIdProp.toString());
                }
            }
        } else {
            String[] parts = AuthorizationUtils.getAuthorizationParts(this.getMessageContext());
            if ("Basic".equalsIgnoreCase(parts[0])) {
                String[] authInfo = AuthorizationUtils.getBasicAuthParts(parts[1]);
                client = this.getAndValidateClient(authInfo[0], authInfo[1]);
            }
        }
        if (client == null) {
            this.reportInvalidClient();
        }
        return client;
    }

    protected Client getAndValidateClient(String clientId, String clientSecret) {
        Client client = this.getClient(clientId);
        if (this.canSupportPublicClients && !client.isConfidential() && client.getClientSecret() == null && clientSecret == null) {
            return client;
        }
        if (clientSecret == null || client.getClientSecret() == null || !client.getClientId().equals(clientId) || !client.getClientSecret().equals(clientSecret)) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        return client;
    }

    protected Response handleException(OAuthServiceException ex, String error) {
        OAuthError customError = ex.getError();
        if (this.writeCustomErrors && customError != null) {
            return this.createErrorResponseFromBean(customError);
        }
        return this.createErrorResponseFromBean(new OAuthError(error));
    }

    protected Response createErrorResponse(MultivaluedMap<String, String> params, String error) {
        return this.createErrorResponseFromBean(new OAuthError(error));
    }

    protected Response createErrorResponseFromBean(OAuthError errorBean) {
        return JAXRSUtils.toResponseBuilder(400).entity((Object)errorBean).build();
    }

    protected Client getClient(String clientId) {
        Client client;
        block4: {
            if (clientId == null) {
                this.reportInvalidRequestError("Client ID is null");
                return null;
            }
            client = null;
            try {
                client = this.getValidClient(clientId);
            }
            catch (OAuthServiceException ex) {
                if (ex.getError() == null) break block4;
                this.reportInvalidClient(ex.getError());
                return null;
            }
        }
        if (client == null) {
            this.reportInvalidClient();
        }
        return client;
    }

    protected void reportInvalidClient() {
        this.reportInvalidClient(new OAuthError("invalid_client"));
    }

    protected void reportInvalidClient(OAuthError error) {
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder(401);
        throw ExceptionUtils.toNotAuthorizedException(null, rb.type(MediaType.APPLICATION_JSON_TYPE).entity((Object)error).build());
    }

    public void setCanSupportPublicClients(boolean support) {
        this.canSupportPublicClients = support;
    }

    public boolean isCanSupportPublicClients() {
        return this.canSupportPublicClients;
    }

    public void setWriteCustomErrors(boolean writeCustomErrors) {
        this.writeCustomErrors = writeCustomErrors;
    }
}

