/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfigurationException;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.jms.JMSConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSDestination;

@NoJSR250Annotations
public class JMSConfigFeature
extends AbstractFeature {
    static final Logger LOG = LogUtils.getL7dLogger(JMSConfigFeature.class);
    JMSConfiguration jmsConfig;

    @Override
    public void initialize(Client client, Bus bus) {
        this.checkJmsConfig();
        Conduit conduit = client.getConduit();
        if (!(conduit instanceof JMSConduit)) {
            throw new ConfigurationException(new Message("JMSCONFIGFEATURE_ONLY_JMS", LOG, new Object[0]));
        }
        JMSConduit jmsConduit = (JMSConduit)conduit;
        jmsConduit.setJmsConfig(this.jmsConfig);
        super.initialize(client, bus);
    }

    @Override
    public void initialize(Server server, Bus bus) {
        this.checkJmsConfig();
        Destination destination = server.getDestination();
        if (!(destination instanceof JMSDestination)) {
            throw new ConfigurationException(new Message("JMSCONFIGFEATURE_ONLY_JMS", LOG, new Object[0]));
        }
        JMSDestination jmsDestination = (JMSDestination)destination;
        jmsDestination.setJmsConfig(this.jmsConfig);
        super.initialize(server, bus);
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    private void checkJmsConfig() {
        if (this.jmsConfig == null) {
            throw new ConfigurationException(new Message("JMSCONFIG_REQUIRED", LOG, new Object[0]));
        }
    }
}

