/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.util.JMSSender;
import org.apache.cxf.transport.jms.util.JndiHelper;
import org.apache.cxf.workqueue.WorkQueueManager;

public final class JMSFactory {
    static final String MESSAGE_ENDPOINT_FACTORY = "MessageEndpointFactory";
    static final String MDB_TRANSACTED_METHOD = "MDBTransactedMethod";

    private JMSFactory() {
    }

    static ConnectionFactory getConnectionFactoryFromJndi(JMSConfiguration jmsConfig) {
        if (jmsConfig.getJndiEnvironment() == null || jmsConfig.getConnectionFactoryName() == null) {
            return null;
        }
        try {
            ConnectionFactory cf = new JndiHelper(jmsConfig.getJndiEnvironment()).lookup(jmsConfig.getConnectionFactoryName(), ConnectionFactory.class);
            return cf;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public static JMSSender createJmsSender(JMSConfiguration jmsConfig, JMSMessageHeadersType messageProperties) {
        JMSSender sender = new JMSSender();
        long timeToLive = messageProperties != null && messageProperties.isSetTimeToLive() ? messageProperties.getTimeToLive() : jmsConfig.getTimeToLive();
        sender.setTimeToLive(timeToLive);
        int priority = messageProperties != null && messageProperties.isSetJMSPriority() ? messageProperties.getJMSPriority() : jmsConfig.getPriority();
        sender.setPriority(priority);
        int deliveryMode = messageProperties != null && messageProperties.isSetJMSDeliveryMode() ? messageProperties.getJMSDeliveryMode() : jmsConfig.getDeliveryMode();
        sender.setDeliveryMode(deliveryMode);
        sender.setExplicitQosEnabled(jmsConfig.isExplicitQosEnabled());
        return sender;
    }

    static String getMessageSelector(JMSConfiguration jmsConfig, String conduitId) {
        String staticSelectorPrefix = jmsConfig.getConduitSelectorPrefix();
        String conduitIdSt = jmsConfig.isUseConduitIdSelector() && conduitId != null ? conduitId : "";
        String correlationIdPrefix = staticSelectorPrefix + conduitIdSt;
        return correlationIdPrefix.isEmpty() ? null : "JMSCorrelationID LIKE '" + correlationIdPrefix + "%'";
    }

    public static Connection createConnection(JMSConfiguration jmsConfig) throws JMSException {
        Connection connection = jmsConfig.getConnectionFactory().createConnection(jmsConfig.getUserName(), jmsConfig.getPassword());
        if (jmsConfig.getDurableSubscriptionClientId() != null) {
            connection.setClientID(jmsConfig.getDurableSubscriptionClientId());
        }
        return connection;
    }

    public static Executor createExecutor(Bus bus, String name) {
        Executor workQueue;
        WorkQueueManager manager = bus.getExtension(WorkQueueManager.class);
        if (manager != null) {
            workQueue = manager.getNamedWorkQueue(name);
            if (workQueue == null) {
                workQueue = manager.getAutomaticWorkQueue();
            }
        } else {
            workQueue = Executors.newFixedThreadPool(20);
        }
        return workQueue;
    }
}

