/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.uri;

import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.jms.uri.JMSEndpoint;
import org.apache.cxf.transport.jms.wsdl.DeliveryModeType;
import org.apache.cxf.transport.jms.wsdl.JndiConnectionFactoryNameType;
import org.apache.cxf.transport.jms.wsdl.JndiContextParameterType;
import org.apache.cxf.transport.jms.wsdl.JndiInitialContextFactoryType;
import org.apache.cxf.transport.jms.wsdl.JndiURLType;
import org.apache.cxf.transport.jms.wsdl.PriorityType;
import org.apache.cxf.transport.jms.wsdl.ReplyToNameType;
import org.apache.cxf.transport.jms.wsdl.TimeToLiveType;
import org.apache.cxf.transport.jms.wsdl.TopicReplyToNameType;

public final class JMSEndpointWSDLUtil {
    private JMSEndpointWSDLUtil() {
    }

    static void retrieveWSDLInformation(JMSEndpoint endpoint, EndpointInfo ei) {
        TopicReplyToNameType topicReplyToNameType;
        ReplyToNameType replyToNameType;
        TimeToLiveType timeToLiveType;
        PriorityType priorityType;
        DeliveryModeType deliveryModeType;
        JndiURLType jndiURLType;
        JndiInitialContextFactoryType jndiInitialContextFactoryType;
        JndiConnectionFactoryNameType jndiConnectionFactoryNameType;
        JndiContextParameterType jndiContextParameterType = JMSEndpointWSDLUtil.getWSDLExtensor(ei, JndiContextParameterType.class);
        if (jndiContextParameterType != null) {
            endpoint.putJndiParameter(jndiContextParameterType.getName().trim(), jndiContextParameterType.getValue().trim());
        }
        if ((jndiConnectionFactoryNameType = JMSEndpointWSDLUtil.getWSDLExtensor(ei, JndiConnectionFactoryNameType.class)) != null) {
            endpoint.setJndiConnectionFactoryName(jndiConnectionFactoryNameType.getValue().trim());
        }
        if ((jndiInitialContextFactoryType = JMSEndpointWSDLUtil.getWSDLExtensor(ei, JndiInitialContextFactoryType.class)) != null) {
            endpoint.setJndiInitialContextFactory(jndiInitialContextFactoryType.getValue().trim());
        }
        if ((jndiURLType = JMSEndpointWSDLUtil.getWSDLExtensor(ei, JndiURLType.class)) != null) {
            endpoint.setJndiURL(jndiURLType.getValue().trim());
        }
        if ((deliveryModeType = JMSEndpointWSDLUtil.getWSDLExtensor(ei, DeliveryModeType.class)) != null) {
            String deliveryMode = deliveryModeType.getValue().trim();
            endpoint.setDeliveryMode(JMSEndpoint.DeliveryModeType.valueOf(deliveryMode));
        }
        if ((priorityType = JMSEndpointWSDLUtil.getWSDLExtensor(ei, PriorityType.class)) != null) {
            endpoint.setPriority(priorityType.getValue());
        }
        if ((timeToLiveType = JMSEndpointWSDLUtil.getWSDLExtensor(ei, TimeToLiveType.class)) != null) {
            endpoint.setTimeToLive(timeToLiveType.getValue());
        }
        if ((replyToNameType = JMSEndpointWSDLUtil.getWSDLExtensor(ei, ReplyToNameType.class)) != null) {
            endpoint.setReplyToName(replyToNameType.getValue());
        }
        if ((topicReplyToNameType = JMSEndpointWSDLUtil.getWSDLExtensor(ei, TopicReplyToNameType.class)) != null) {
            endpoint.setTopicReplyToName(topicReplyToNameType.getValue());
        }
    }

    public static <T> T getWSDLExtensor(EndpointInfo ei, Class<T> cls) {
        ServiceInfo si = ei.getService();
        BindingInfo bi = ei.getBinding();
        T o = ei.getExtensor(cls);
        if (o == null && si != null) {
            o = si.getExtensor(cls);
        }
        if (o == null && bi != null) {
            o = bi.getExtensor(cls);
        }
        if (o == null) {
            return null;
        }
        if (cls.isInstance(o)) {
            return cls.cast(o);
        }
        return null;
    }
}

