/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.jaxrs.model.ProviderInfo;

public class ProviderCache {
    private static final int MAX_PROVIDER_CACHE_SIZE = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.getInteger("org.apache.cxf.jaxrs.max_provider_cache_size", 100);
        }
    });
    private final Map<String, List<ProviderInfo<MessageBodyReader<?>>>> readerProviderCache = new ConcurrentHashMap();
    private final Map<String, List<ProviderInfo<MessageBodyWriter<?>>>> writerProviderCache = new ConcurrentHashMap();
    private boolean checkAllCandidates;

    public ProviderCache(boolean checkAllCandidates) {
        this.checkAllCandidates = checkAllCandidates;
    }

    public List<ProviderInfo<MessageBodyReader<?>>> getReaders(Class<?> type, MediaType mt) {
        if (this.readerProviderCache.isEmpty()) {
            return Collections.emptyList();
        }
        String key = this.getKey(type, mt);
        List<ProviderInfo<MessageBodyReader<?>>> list = this.readerProviderCache.get(key);
        return list != null ? list : Collections.emptyList();
    }

    public List<ProviderInfo<MessageBodyWriter<?>>> getWriters(Class<?> type, MediaType mt) {
        if (this.writerProviderCache.isEmpty()) {
            return Collections.emptyList();
        }
        String key = this.getKey(type, mt);
        List<ProviderInfo<MessageBodyWriter<?>>> list = this.writerProviderCache.get(key);
        return list != null ? list : Collections.emptyList();
    }

    public void putReaders(Class<?> type, MediaType mt, List<ProviderInfo<MessageBodyReader<?>>> candidates) {
        if (candidates == null || candidates.isEmpty()) {
            return;
        }
        ProviderCache.checkCacheSize(this.readerProviderCache);
        String key = this.getKey(type, mt);
        this.readerProviderCache.put(key, candidates);
    }

    public void putWriters(Class<?> type, MediaType mt, List<ProviderInfo<MessageBodyWriter<?>>> candidates) {
        if (candidates == null || candidates.isEmpty()) {
            return;
        }
        ProviderCache.checkCacheSize(this.writerProviderCache);
        String key = this.getKey(type, mt);
        this.writerProviderCache.put(key, candidates);
    }

    public void destroy() {
        this.readerProviderCache.clear();
        this.writerProviderCache.clear();
    }

    private String getKey(Class<?> type, MediaType mt) {
        return type.getName() + "-" + mt.toString();
    }

    private static void checkCacheSize(Map<?, ?> map) {
        int size = map.size();
        if (size >= MAX_PROVIDER_CACHE_SIZE) {
            map.clear();
        }
    }

    public boolean isCheckAllCandidates() {
        return this.checkAllCandidates;
    }
}

